/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geopose10.encodings.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.opengis.cite.geopose10.BaseJsonSchemaValidatorTest;
import org.opengis.cite.geopose10.CommonFixture;
import org.opengis.cite.geopose10.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class StreamElement
extends CommonFixture {
    private File testSubject;

    @BeforeClass
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.STREAMELEMENT_TEST_SUBJ_FILE.getName());
        this.testSubject = (File)obj;
    }

    public void setTestSubject(File testSubject) {
        this.testSubject = testSubject;
    }

    @Test(description="Implements Conformance test A.45: Verify Stream Element conformance to JSON schema (/conf/stream-encoding-json/element)")
    public void validateByStreamElementSchema() {
        if (!this.testSubject.isFile()) {
            Assert.assertTrue(this.testSubject.isFile(), "No file selected. ");
        }
        BaseJsonSchemaValidatorTest tester = new BaseJsonSchemaValidatorTest();
        String schemaToApply = "/org/opengis/cite/geopose10/jsonschema/GeoPose.Composite.Sequence.StreamElement.Schema.json";
        boolean valid = false;
        StringBuffer sb = new StringBuffer();
        InputStream inputStream = tester.getClass().getResourceAsStream(schemaToApply);
        try {
            JsonNode schemaNode = tester.getJsonNodeFromStringContent(tester.otherConvertInputStreamToString(inputStream));
            JsonSchema schema = tester.getJsonSchemaFromJsonNodeAutomaticVersion(schemaNode);
            schema.initializeValidators();
            JsonNode node = tester.getJsonNodeFromStringContent(tester.otherConvertInputStreamToString(new FileInputStream(this.testSubject)));
            Set<ValidationMessage> errors = schema.validate(node);
            Iterator<ValidationMessage> it = errors.iterator();
            while (it.hasNext()) {
                sb.append(" " + it.next() + ".\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertTrue(sb.toString().length() == 0, sb.toString());
    }
}

