/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geopose10;

import com.sun.jersey.api.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.geopose10.SuiteAttribute;
import org.opengis.cite.geopose10.TestRunArg;
import org.opengis.cite.geopose10.util.ClientUtils;
import org.opengis.cite.geopose10.util.TestSuiteLogger;
import org.opengis.cite.geopose10.util.URIUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    public void onFinish(ISuite suite) {
        if (null != System.getProperty("deleteSubjectOnFinish")) {
            this.deleteTempFiles(suite);
            System.getProperties().remove("deleteSubjectOnFinish");
        }
    }

    void processSuiteParameters(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String basicYPRParam = (String)params.get(TestRunArg.BASICYPR.toString());
        if (null == basicYPRParam || basicYPRParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.BASICYPR.toString());
        }
        URI basicYPRRef = URI.create(basicYPRParam.trim());
        File basicYPREntityFile = null;
        try {
            basicYPREntityFile = URIUtils.dereferenceURI(basicYPRRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + basicYPRRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", basicYPREntityFile.getAbsolutePath(), basicYPREntityFile.length()));
        suite.setAttribute(SuiteAttribute.BASICYPR_TEST_SUBJ_FILE.getName(), (Object)basicYPREntityFile);
        String basicQuaternionParam = (String)params.get(TestRunArg.BASICQuaternion.toString());
        if (null == basicQuaternionParam || basicQuaternionParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.BASICQuaternion.toString());
        }
        URI basicQuaternionRef = URI.create(basicQuaternionParam.trim());
        File basicQuaternionEntityFile = null;
        try {
            basicQuaternionEntityFile = URIUtils.dereferenceURI(basicQuaternionRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + basicQuaternionRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", basicQuaternionEntityFile.getAbsolutePath(), basicQuaternionEntityFile.length()));
        suite.setAttribute(SuiteAttribute.BASICQUATERNION_TEST_SUBJ_FILE.getName(), (Object)basicQuaternionEntityFile);
        String advancedParam = (String)params.get(TestRunArg.ADVANCED.toString());
        if (null == advancedParam || advancedParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.ADVANCED.toString());
        }
        URI advancedRef = URI.create(advancedParam.trim());
        File advancedEntityFile = null;
        try {
            advancedEntityFile = URIUtils.dereferenceURI(advancedRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + advancedRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", advancedEntityFile.getAbsolutePath(), advancedEntityFile.length()));
        suite.setAttribute(SuiteAttribute.ADVANCED_TEST_SUBJ_FILE.getName(), (Object)advancedEntityFile);
        String chainParam = (String)params.get(TestRunArg.CHAIN.toString());
        if (null == chainParam || chainParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.CHAIN.toString());
        }
        URI chainRef = URI.create(chainParam.trim());
        File chainEntityFile = null;
        try {
            chainEntityFile = URIUtils.dereferenceURI(chainRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + chainRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", chainEntityFile.getAbsolutePath(), chainEntityFile.length()));
        suite.setAttribute(SuiteAttribute.CHAIN_TEST_SUBJ_FILE.getName(), (Object)chainEntityFile);
        String graphParam = (String)params.get(TestRunArg.GRAPH.toString());
        if (null == graphParam || graphParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.GRAPH.toString());
        }
        URI graphRef = URI.create(graphParam.trim());
        File graphEntityFile = null;
        try {
            graphEntityFile = URIUtils.dereferenceURI(graphRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + graphRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", graphEntityFile.getAbsolutePath(), graphEntityFile.length()));
        suite.setAttribute(SuiteAttribute.GRAPH_TEST_SUBJ_FILE.getName(), (Object)graphEntityFile);
        String seriesregularParam = (String)params.get(TestRunArg.SERIESREGULAR.toString());
        if (null == seriesregularParam || seriesregularParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.SERIESREGULAR.toString());
        }
        URI seriesregularRef = URI.create(seriesregularParam.trim());
        File seriesregularEntityFile = null;
        try {
            seriesregularEntityFile = URIUtils.dereferenceURI(seriesregularRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + seriesregularRef, ioxc);
        }
        System.out.println(String.format("Wrote test subject to file: %s (%d bytes)", seriesregularEntityFile.getAbsolutePath(), seriesregularEntityFile.length()));
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", seriesregularEntityFile.getAbsolutePath(), seriesregularEntityFile.length()));
        suite.setAttribute(SuiteAttribute.SERIESREGULAR_TEST_SUBJ_FILE.getName(), (Object)seriesregularEntityFile);
        String streamelementParam = (String)params.get(TestRunArg.STREAMELEMENT.toString());
        if (null == streamelementParam || streamelementParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.STREAMELEMENT.toString());
        }
        URI streamelementRef = URI.create(streamelementParam.trim());
        File streamelementEntityFile = null;
        try {
            streamelementEntityFile = URIUtils.dereferenceURI(streamelementRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + streamelementRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", streamelementEntityFile.getAbsolutePath(), streamelementEntityFile.length()));
        suite.setAttribute(SuiteAttribute.STREAMELEMENT_TEST_SUBJ_FILE.getName(), (Object)streamelementEntityFile);
        String streamheaderParam = (String)params.get(TestRunArg.STREAMHEADER.toString());
        if (null == streamheaderParam || streamheaderParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.STREAMHEADER.toString());
        }
        URI streamheaderRef = URI.create(streamheaderParam.trim());
        File streamheaderEntityFile = null;
        try {
            streamheaderEntityFile = URIUtils.dereferenceURI(streamheaderRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + streamheaderRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", streamheaderEntityFile.getAbsolutePath(), streamheaderEntityFile.length()));
        suite.setAttribute(SuiteAttribute.STREAMHEADER_TEST_SUBJ_FILE.getName(), (Object)streamheaderEntityFile);
        String streamrecordParam = (String)params.get(TestRunArg.STREAMRECORD.toString());
        if (null == streamrecordParam || streamrecordParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.STREAMRECORD.toString());
        }
        URI streamrecordRef = URI.create(streamrecordParam.trim());
        File streamrecordEntityFile = null;
        try {
            streamrecordEntityFile = URIUtils.dereferenceURI(streamrecordRef);
        }
        catch (IOException ioxc) {
            throw new RuntimeException("Failed to dereference resource located at " + streamrecordRef, ioxc);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", streamrecordEntityFile.getAbsolutePath(), streamrecordEntityFile.length()));
        suite.setAttribute(SuiteAttribute.STREAMRECORD_TEST_SUBJ_FILE.getName(), (Object)streamrecordEntityFile);
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), (Object)client);
        }
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
        File testSubjFile = (File)suite.getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testSubjFile.exists()) {
            testSubjFile.delete();
        }
    }
}

