/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geopose10.encodings.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.opengis.cite.geopose10.BaseJsonSchemaValidatorTest;
import org.opengis.cite.geopose10.CommonFixture;
import org.opengis.cite.geopose10.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Graph
extends CommonFixture {
    private File testSubject;

    @BeforeClass
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.GRAPH_TEST_SUBJ_FILE.getName());
        this.testSubject = (File)obj;
    }

    public void setTestSubject(File testSubject) {
        this.testSubject = testSubject;
    }

    @Test(description="Implements Conformance test A.41: Verify conformance via JSON schema (/conf/graph-encoding-json/definition)")
    public void validateByGraphSchema() {
        if (!this.testSubject.isFile()) {
            Assert.assertTrue((boolean)this.testSubject.isFile(), (String)"No file selected. ");
        }
        BaseJsonSchemaValidatorTest tester = new BaseJsonSchemaValidatorTest();
        String schemaToApply = "/org/opengis/cite/geopose10/jsonschema/GeoPose.Composite.Graph.Schema.json";
        boolean valid = false;
        StringBuffer sb = new StringBuffer();
        InputStream inputStream = tester.getClass().getResourceAsStream(schemaToApply);
        try {
            JsonNode schemaNode = tester.getJsonNodeFromStringContent(tester.otherConvertInputStreamToString(inputStream));
            JsonSchema schema = tester.getJsonSchemaFromJsonNodeAutomaticVersion(schemaNode);
            schema.initializeValidators();
            JsonNode node = tester.getJsonNodeFromStringContent(tester.otherConvertInputStreamToString(new FileInputStream(this.testSubject)));
            Set errors = schema.validate(node);
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                sb.append(" " + it.next() + ".\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((sb.toString().length() == 0 ? 1 : 0) != 0, (String)sb.toString());
    }
}

