/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalPropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AdditionalPropertiesValidator.class);
    private final boolean allowAdditionalProperties;
    private final JsonSchema additionalPropertiesSchema;
    private final Set<String> allowedProperties;
    private final List<Pattern> patternProperties = new ArrayList<Pattern>();

    public AdditionalPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ADDITIONAL_PROPERTIES, validationContext);
        JsonNode patternPropertiesNode;
        if (schemaNode.isBoolean()) {
            this.allowAdditionalProperties = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else if (schemaNode.isObject()) {
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema);
        } else {
            this.allowAdditionalProperties = false;
            this.additionalPropertiesSchema = null;
        }
        this.allowedProperties = new HashSet<String>();
        JsonNode propertiesNode = parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null) {
            Iterator<String> it = propertiesNode.fieldNames();
            while (it.hasNext()) {
                this.allowedProperties.add(it.next());
            }
        }
        if ((patternPropertiesNode = parentSchema.getSchemaNode().get("patternProperties")) != null) {
            Iterator<String> it = patternPropertiesNode.fieldNames();
            while (it.hasNext()) {
                this.patternProperties.add(Pattern.compile(it.next()));
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    private void addToEvaluatedProperties(String propertyPath) {
        Object evaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
        ArrayList<String> evaluatedPropertiesList = null;
        if (evaluatedProperties == null) {
            evaluatedPropertiesList = new ArrayList<String>();
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", evaluatedPropertiesList);
        } else {
            evaluatedPropertiesList = (ArrayList<String>)evaluatedProperties;
        }
        evaluatedPropertiesList.add(propertyPath);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        Iterator<String> it;
        if (logger.isDebugEnabled()) {
            this.debug(logger, node, rootNode, at);
        }
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isObject()) {
            return errors;
        }
        if (this.allowAdditionalProperties) {
            it = node.fieldNames();
            while (it.hasNext()) {
                this.addToEvaluatedProperties(at + "." + it.next());
            }
        }
        it = node.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (Pattern pattern : this.patternProperties) {
                Matcher m3 = pattern.matcher(pname);
                if (!m3.find()) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties) continue;
            if (!this.allowAdditionalProperties) {
                errors.add(this.buildValidationMessage(at, pname));
                continue;
            }
            if (this.additionalPropertiesSchema == null) continue;
            ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
            if (state != null && state.isWalkEnabled()) {
                errors.addAll(this.additionalPropertiesSchema.walk(node.get(pname), rootNode, at + "." + pname, state.isValidationEnabled()));
                continue;
            }
            errors.addAll(this.additionalPropertiesSchema.validate(node.get(pname), rootNode, at + "." + pname));
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        if (node == null || !node.isObject()) {
            return Collections.emptySet();
        }
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            ValidatorState state;
            String pname = it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (Pattern pattern : this.patternProperties) {
                Matcher m3 = pattern.matcher(pname);
                if (!m3.find()) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties || !this.allowAdditionalProperties || this.additionalPropertiesSchema == null || (state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState")) == null || !state.isWalkEnabled()) continue;
            this.additionalPropertiesSchema.walk(node.get(pname), rootNode, at + "." + pname, state.isValidationEnabled());
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.initializeValidators();
        }
    }
}

