/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, parentSchema.getSchemaPath() + "/" + this.getValidatorType().getValue() + "/" + i, parentSchema.getCurrentUri(), schemaNode.get(i), parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
        LinkedHashSet<Object> childSchemaErrors = new LinkedHashSet<Object>();
        Object backupEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
        ArrayList totalEvaluatedProperties = new ArrayList();
        for (JsonSchema schema : this.schemas) {
            block8: {
                List backupEvaluatedPropertiesList;
                try {
                    CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                    Set<Object> localErrors = new HashSet();
                    localErrors = !state.isWalkEnabled() ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, true);
                    childSchemaErrors.addAll(localErrors);
                    if (localErrors.isEmpty()) {
                        totalEvaluatedProperties.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                    }
                    if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                        Iterator<JsonNode> arrayElements = this.schemaNode.elements();
                        while (arrayElements.hasNext()) {
                            ObjectNode discriminator;
                            ValidationContext.DiscriminatorContext currentDiscriminatorContext;
                            ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                            JsonNode $ref = allOfEntry.get("$ref");
                            if (null == $ref || null == (currentDiscriminatorContext = this.validationContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                            AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, at);
                            String discriminatorPropertyName = discriminator.get("propertyName").asText();
                            JsonNode discriminatorNode = node.get(discriminatorPropertyName);
                            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.textValue();
                            JsonSchema jsonSchema = this.parentSchema;
                            AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
                        }
                    }
                    if (!childSchemaErrors.isEmpty()) break block8;
                    backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                }
                catch (Throwable throwable) {
                    if (childSchemaErrors.isEmpty()) {
                        List backupEvaluatedPropertiesList2 = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                        backupEvaluatedPropertiesList2.addAll(totalEvaluatedProperties);
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList2);
                    } else {
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
                    }
                    throw throwable;
                }
                backupEvaluatedPropertiesList.addAll(totalEvaluatedProperties);
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
                continue;
            }
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
        }
        return Collections.unmodifiableSet(childSchemaErrors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(node, rootNode, at, false);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

