/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.walk.DefaultItemWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PrefixItemsValidator.class);
    private static final String PROPERTY_ITEMS = "items";
    private final JsonSchema schema;
    private final List<JsonSchema> tupleSchema = new ArrayList<JsonSchema>();
    private boolean additionalItems = true;
    private final JsonSchema additionalSchema;
    private WalkListenerRunner arrayItemWalkListenerRunner;

    public PrefixItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ITEMS, validationContext);
        JsonSchema foundSchema = null;
        JsonSchema foundAdditionalSchema = null;
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            foundSchema = new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), schemaNode, parentSchema);
        } else {
            for (JsonNode s2 : schemaNode) {
                this.tupleSchema.add(new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), s2, parentSchema));
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ITEMS);
            if (addItemNode != null) {
                if (addItemNode.isBoolean()) {
                    this.additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    foundAdditionalSchema = new JsonSchema(validationContext, "#", parentSchema.getCurrentUri(), addItemNode, parentSchema);
                }
            }
        }
        this.arrayItemWalkListenerRunner = new DefaultItemWalkListenerRunner(validationContext.getConfig().getArrayItemWalkListeners());
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        this.schema = foundSchema;
        this.additionalSchema = foundAdditionalSchema;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isArray() && !this.validationContext.getConfig().isTypeLoose()) {
            return errors;
        }
        if (node.isArray()) {
            int i = 0;
            for (JsonNode n : node) {
                this.doValidate(errors, i, n, rootNode, at);
                ++i;
            }
        } else {
            this.doValidate(errors, 0, node, rootNode, at);
        }
        return Collections.unmodifiableSet(errors);
    }

    private void doValidate(Set<ValidationMessage> errors, int i, JsonNode node, JsonNode rootNode, String at) {
        if (this.schema != null) {
            errors.addAll(this.schema.validate(node, rootNode, at + "[" + i + "]"));
        }
        if (this.tupleSchema != null) {
            if (i < this.tupleSchema.size()) {
                errors.addAll(this.tupleSchema.get(i).validate(node, rootNode, at + "[" + i + "]"));
            } else if (this.additionalSchema != null) {
                errors.addAll(this.additionalSchema.validate(node, rootNode, at + "[" + i + "]"));
            } else if (!this.additionalItems) {
                errors.add(this.buildValidationMessage(at, "" + i));
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            JsonNode defaultNode = null;
            if (this.applyDefaultsStrategy.shouldApplyArrayDefaults() && this.schema != null) {
                defaultNode = this.schema.getSchemaNode().get("default");
            }
            int i = 0;
            for (JsonNode n : arrayNode) {
                if (n.isNull() && defaultNode != null) {
                    arrayNode.set(i, defaultNode);
                    n = defaultNode;
                }
                this.doWalk(validationMessages, i, n, rootNode, at, shouldValidateSchema);
                ++i;
            }
        } else {
            this.doWalk(validationMessages, 0, node, rootNode, at, shouldValidateSchema);
        }
        return validationMessages;
    }

    private void doWalk(HashSet<ValidationMessage> validationMessages, int i, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (this.schema != null) {
            this.walkSchema(this.schema, node, rootNode, at + "[" + i + "]", shouldValidateSchema, validationMessages);
        }
        if (this.tupleSchema != null) {
            if (i < this.tupleSchema.size()) {
                this.walkSchema(this.tupleSchema.get(i), node, rootNode, at + "[" + i + "]", shouldValidateSchema, validationMessages);
            } else if (this.additionalSchema != null) {
                this.walkSchema(this.additionalSchema, node, rootNode, at + "[" + i + "]", shouldValidateSchema, validationMessages);
            }
        }
    }

    private void walkSchema(JsonSchema walkSchema, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages) {
        boolean executeWalk = this.arrayItemWalkListenerRunner.runPreWalkListeners(ValidatorTypeCode.ITEMS.getValue(), node, rootNode, at, walkSchema.getSchemaPath(), walkSchema.getSchemaNode(), walkSchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory());
        if (executeWalk) {
            validationMessages.addAll(walkSchema.walk(node, rootNode, at, shouldValidateSchema));
        }
        this.arrayItemWalkListenerRunner.runPostWalkListeners(ValidatorTypeCode.ITEMS.getValue(), node, rootNode, at, walkSchema.getSchemaPath(), walkSchema.getSchemaNode(), walkSchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
    }

    public List<JsonSchema> getTupleSchema() {
        return this.tupleSchema;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
        this.preloadJsonSchemas(this.tupleSchema);
        if (null != this.additionalSchema) {
            this.additionalSchema.initializeValidators();
        }
    }
}

