/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.util.TEPath;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.saxon.s9api.XdmNode;

public class RuntimeOptions {
    private int mode = 0;
    private File testLogDir = null;
    private File workDir = null;
    private String sessionId;
    private String testName = "";
    private String suiteName = "";
    private String sourcesName = "default";
    private String baseURI = "";
    private ArrayList<String> profiles = new ArrayList();
    private ArrayList<String> testPaths = new ArrayList();
    private ArrayList<String> params = new ArrayList();
    private List<File> recordedForms = new ArrayList<File>();
    private static Logger jLogger = Logger.getLogger("com.occamlab.te.RuntimeOptions");
    private static final String UUID_PATTERN = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$";

    public RuntimeOptions() {
        File baseDir = SetupOptions.getBaseConfigDirectory();
        File usersDir = new File(baseDir, "users");
        File userDir = new File(usersDir, System.getProperty("user.name"));
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        this.testLogDir = userDir;
        SetupOptions sopts = new SetupOptions();
        this.workDir = sopts.getWorkDir();
        jLogger.setLevel(Level.INFO);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public boolean setBaseURI(String baseURI) {
        Logger.getLogger(RuntimeOptions.class.getName()).log(Level.CONFIG, "Setting baseURI = " + baseURI);
        if (baseURI == null) {
            return false;
        }
        this.baseURI = baseURI;
        return true;
    }

    public String getSourcesName() {
        return this.sourcesName;
    }

    public boolean setSourcesName(String sourcesName) {
        if (sourcesName == null) {
            return false;
        }
        this.sourcesName = sourcesName;
        return true;
    }

    public File getLogDir() {
        return this.testLogDir;
    }

    public boolean setLogDir(File logDir) {
        if (logDir == null) {
            return false;
        }
        TEPath tpath = new TEPath(logDir.getAbsolutePath());
        if (tpath.isValid()) {
            this.testLogDir = logDir;
            return true;
        }
        return false;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public boolean setWorkDir(File workDir) {
        if (workDir == null) {
            return false;
        }
        TEPath tpath = new TEPath(workDir.getAbsolutePath());
        if (tpath.isValid()) {
            this.workDir = workDir;
            return true;
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean setMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 4 && mode != 5 && mode != 6) {
            return false;
        }
        this.mode = mode;
        return true;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean setSessionId(String sessionId) {
        jLogger.log(Level.INFO, "RuntimeOptions: Setting session to " + sessionId);
        if (sessionId == null) {
            return false;
        }
        this.sessionId = sessionId;
        return true;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public boolean setSuiteName(String suiteName) {
        if (suiteName == null) {
            return false;
        }
        this.suiteName = suiteName;
        return true;
    }

    public ArrayList<String> getProfiles() {
        return this.profiles;
    }

    public boolean addProfile(String profile) {
        if (profile == null) {
            return false;
        }
        this.profiles.add(profile);
        return true;
    }

    public ArrayList<String> getTestPaths() {
        return this.testPaths;
    }

    public boolean addTestPath(String testPath) {
        if (testPath == null) {
            return false;
        }
        this.testPaths.add(testPath);
        return true;
    }

    public ArrayList<String> getParams() {
        return this.params;
    }

    public boolean addParam(String param) {
        if (param == null) {
            return false;
        }
        this.params.add(param);
        return true;
    }

    public XdmNode getContextNode() {
        return null;
    }

    public String getTestName() {
        return this.testName;
    }

    public boolean setTestName(String testName) {
        if (testName == null) {
            return false;
        }
        this.testName = testName;
        return true;
    }

    public boolean addRecordedForm(String recordedForm) {
        if (recordedForm == null) {
            return false;
        }
        this.recordedForms.add(new File(recordedForm));
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RuntimeOptions {\n");
        sb.append("mode=").append(this.mode).append(",\n");
        sb.append("testLogDir=").append(this.testLogDir).append(",\n");
        sb.append("workDir=").append(this.workDir).append(",\n");
        sb.append("sessionId=").append(this.sessionId).append(",\n");
        sb.append("testName=").append(this.testName).append(",\n");
        sb.append("suiteName=").append(this.suiteName).append(",\n");
        sb.append("sourcesName=").append(this.sourcesName).append(",\n");
        sb.append("baseURI=").append(this.baseURI).append(",\n");
        sb.append("profiles=").append(this.profiles).append(",\n");
        sb.append("testPaths=").append(this.testPaths).append(",\n");
        sb.append("recordedFroms=").append(this.recordedForms).append(",\n");
        sb.append("params=").append(this.params).append("\n}");
        return sb.toString();
    }

    public List<File> getRecordedForms() {
        return this.recordedForms;
    }
}

