/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.Engine;
import com.occamlab.te.Generator;
import com.occamlab.te.RuntimeOptions;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.TEClassLoader;
import com.occamlab.te.TECore;
import com.occamlab.te.ViewLog;
import com.occamlab.te.index.Index;
import com.occamlab.te.util.DocumentationHelper;
import com.occamlab.te.util.LogUtils;
import com.occamlab.te.util.Misc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;

public class Test {
    private static final Logger LOGR = Logger.getLogger(Test.class.getName());
    public static final int TEST_MODE = 0;
    public static final int RETEST_MODE = 1;
    public static final int RESUME_MODE = 2;
    public static final int REDO_FROM_CACHE_MODE = 3;
    public static final int DOC_MODE = 4;
    public static final int CHECK_MODE = 5;
    public static final int PRETTYLOG_MODE = 6;
    public static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";
    public static final String TE_NS = "http://www.occamlab.com/te";
    public static final String CTL_NS = "http://www.occamlab.com/ctl";
    public static final String CTLP_NS = "http://www.occamlab.com/te/parsers";
    SetupOptions setupOpts = new SetupOptions();
    RuntimeOptions runOpts = new RuntimeOptions();

    void setRuntimeOptions(RuntimeOptions runOpts) {
        this.runOpts = runOpts;
    }

    private void executeTest(String relativePathToMainCtl) throws Exception {
        String[] arguments = new String[]{"-source=" + relativePathToMainCtl};
        this.execute(arguments);
    }

    public static void main(String[] args) throws Exception {
        Test test = new Test();
        test.execute(args);
    }

    public void execute(String[] args) throws Exception {
        ClassLoader cl;
        File workDir = this.setupOpts.getWorkDir();
        boolean rslt = this.runOpts.setWorkDir(workDir);
        String cmd = "java com.occamlab.te.Test";
        File logDir = this.runOpts.getLogDir();
        String session = null;
        int mode = 0;
        File sourceFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-cmd=")) {
                cmd = arg.substring(5);
                continue;
            }
            if (arg.startsWith("-source=")) {
                String sourcePath = arg.substring(8);
                sourceFile = new File(sourcePath);
                if (!sourceFile.isAbsolute()) {
                    File scriptsDir = new File(SetupOptions.getBaseConfigDirectory(), "scripts");
                    sourceFile = new File(scriptsDir, sourcePath);
                }
                if (sourceFile.exists() && this.setupOpts.addSourceWithValidation(sourceFile)) continue;
                System.out.println("Error: Cannot find CTL script(s) at " + sourceFile.getAbsolutePath());
                return;
            }
            if (arg.startsWith("-session=")) {
                session = arg.substring(9);
                continue;
            }
            if (arg.startsWith("-base=")) {
                rslt = this.runOpts.setBaseURI(arg.substring(6));
                continue;
            }
            if (arg.startsWith("-test=")) {
                rslt = this.runOpts.setTestName(arg.substring(6));
                continue;
            }
            if (arg.startsWith("-suite=")) {
                rslt = this.runOpts.setSuiteName(arg.substring(7));
                continue;
            }
            if (arg.startsWith("-profile=")) {
                rslt = this.runOpts.addProfile(arg.substring(9));
                continue;
            }
            if (arg.startsWith("@")) {
                rslt = this.runOpts.addParam(arg.substring(1));
                continue;
            }
            if (arg.equals("-mode=test")) {
                mode = 0;
                continue;
            }
            if (arg.equals("-mode=retest")) {
                mode = 1;
                continue;
            }
            if (arg.equals("-mode=resume")) {
                mode = 2;
                continue;
            }
            if (arg.equals("-mode=doc")) {
                mode = 4;
                continue;
            }
            if (arg.equals("-mode=check")) {
                mode = 5;
                continue;
            }
            if (arg.equals("-mode=pplogs")) {
                mode = 6;
                continue;
            }
            if (arg.equals("-mode=cache")) {
                mode = 3;
                continue;
            }
            if (arg.startsWith("-mode=")) {
                System.out.println("Error: Invalid mode.");
                return;
            }
            if (arg.equals("-validate=no")) {
                this.setupOpts.setValidate(false);
                continue;
            }
            if (arg.startsWith("-form=")) {
                rslt = this.runOpts.addRecordedForm(arg.substring(6));
                continue;
            }
            if (!arg.startsWith("-")) {
                if (mode == 1) {
                    rslt = this.runOpts.addTestPath(arg);
                    continue;
                }
                System.out.println("Unrecognized parameter \"" + arg + "\"");
                continue;
            }
            System.out.println("Unrecognized parameter \"" + arg + "\"");
        }
        rslt = this.runOpts.setMode(mode);
        if (mode == 1 && (logDir == null || session == null) || mode == 2 && (logDir == null || session == null)) {
            Test.syntax(cmd);
            return;
        }
        if (mode == 3 && (logDir == null || session == null)) {
            Test.syntax(cmd);
            return;
        }
        if (this.runOpts.getProfiles().size() > 0 && logDir == null) {
            System.out.println("Error: A -logdir parameter is required for testing profiles");
            return;
        }
        if (mode == 6 && logDir == null) {
            System.out.println("Error: A -logdir parameter is required to create report");
            return;
        }
        if (session == null) {
            session = System.getProperty("team.session");
        }
        if (session == null) {
            session = logDir == null ? "s0001" : LogUtils.generateSessionId(logDir);
        }
        rslt = this.runOpts.setSessionId(session);
        Thread.currentThread().setName("TEAM Engine");
        Index masterIndex = null;
        File indexFile = null;
        if (logDir != null && session != null) {
            File dir = new File(logDir, this.runOpts.getSessionId());
            indexFile = new File(dir, "index.xml");
        }
        if (mode == 4) {
            cl = Thread.currentThread().getContextClassLoader();
            DocumentationHelper docCode = new DocumentationHelper(cl.getResource("com/occamlab/te/PseudoCTLDocumentation.xsl"));
            File html_output_documentation_file = new File(workDir.getAbsolutePath() + File.separator + "documentation.html");
            if (html_output_documentation_file.exists()) {
                throw new Exception("Error: Documentation file already exists, check the file " + html_output_documentation_file.getAbsolutePath() + " ");
            }
            FileOutputStream fos = new FileOutputStream(html_output_documentation_file);
            docCode.generateDocumentation(this.setupOpts.getSources().get(0).getAbsolutePath(), fos);
            fos.close();
            System.out.println("Test documentation file \"" + html_output_documentation_file.getAbsolutePath() + "\" created!");
            return;
        }
        if (mode == 6) {
            cl = Thread.currentThread().getContextClassLoader();
            DocumentationHelper docLogs = new DocumentationHelper(cl.getResource("com/occamlab/te/test_report_html.xsl"));
            docLogs.prettyPrintsReport(logDir);
            return;
        }
        if (mode == 0 || mode == 5) {
            masterIndex = Generator.generateXsl(this.setupOpts);
            if (indexFile != null) {
                masterIndex.persist(indexFile);
            }
        } else if (mode == 3) {
            boolean regenerate = false;
            if (indexFile != null && indexFile.canRead()) {
                masterIndex = new Index(indexFile);
                if (masterIndex.outOfDate()) {
                    System.out.println("Warning: Scripts have changed since this session was first executed.");
                    regenerate = true;
                }
            } else {
                System.out.println("Error: Can't read index file.");
                regenerate = true;
            }
            if (regenerate) {
                System.out.println("Regenerating masterIndex from source scripts");
                masterIndex = Generator.generateXsl(this.setupOpts);
                if (indexFile != null) {
                    masterIndex.persist(indexFile);
                }
            }
        } else {
            if (indexFile == null) {
                System.out.println("Error: Can't read index file.");
                return;
            }
            if (!indexFile.canRead()) {
                System.out.println("Error: Can't read index file.");
                return;
            }
            masterIndex = new Index(indexFile);
            if (masterIndex.outOfDate()) {
                System.out.println("Warning: Scripts have changed since this session was first executed.");
            }
        }
        if (mode == 3) {
            File stylesheet = Misc.getResourceAsFile("com/occamlab/te/web/viewlog.xsl");
            Templates ViewLogTemplates = ViewLog.transformerFactory.newTemplates(new StreamSource(stylesheet));
            File userlog = logDir;
            StringWriter sw = new StringWriter();
            String testName = null;
            ViewLog.view_log(testName, userlog, session, new ArrayList(), ViewLogTemplates, sw);
            boolean hasCache = ViewLog.hasCache();
            if (!hasCache) {
                File dir = new File(logDir, this.runOpts.getSessionId());
                throw new Exception("Error: no cache for " + dir.getAbsolutePath());
            }
        }
        if (masterIndex != null) {
            masterIndex.setElements(null);
        } else {
            masterIndex = new Index();
        }
        TEClassLoader cl2 = new TEClassLoader(Test.findResourcesDirectory(sourceFile));
        Engine engine = new Engine(masterIndex, this.setupOpts.getSourcesName(), cl2);
        if (this.setupOpts.isPreload() || mode == 5) {
            engine.preload(masterIndex, this.setupOpts.getSourcesName());
        }
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(this.runOpts.toString());
        }
        if (mode != 5) {
            TECore core = new TECore(engine, masterIndex, this.runOpts);
            core.execute();
        }
    }

    static File findResourcesDirectory(File sourceFile) {
        File parent = sourceFile.getParentFile();
        if (null == parent) {
            return null;
        }
        File[] resourceDirs = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("resources") && new File(dir, name).isDirectory();
            }
        });
        if (resourceDirs.length > 0) {
            return resourceDirs[0];
        }
        return Test.findResourcesDirectory(parent);
    }

    static void syntax(String cmd) {
        System.out.println();
        System.out.println("Test mode:");
        System.out.println("  Use to start a test session.\n");
        System.out.println("  " + cmd + " [-mode=test] [-source=ctlfile|dir]...");
        System.out.println("  [-session=session] [-base=baseURI]");
        System.out.println("    [-suite=qname|-test=qname [@param-name=value] ...] [-profile=qname|*] ...\n");
        System.out.println("    qname=[namespace_uri,|prefix:]local_name]\n");
        System.out.println("Resume mode:");
        System.out.println("  Use to resume a test session that was interrupted before completion.\n");
        System.out.println("  " + cmd + " -mode=resume -logdir=dir -session=session\n");
        System.out.println("Retest mode:");
        System.out.println("  Use to reexecute individual tests.\n");
        System.out.println("  " + cmd + " -mode=retest -logdir=dir -session=session testpath1 [testpath2] ...\n");
        System.out.println("Doc mode:");
        System.out.println("  Use to generate documentation of tests.\n");
        System.out.println("  " + cmd + " -mode=doc -source=<main ctl file> [-suite=[{namespace_uri,|prefix:}]suite_name]\n");
        System.out.println("PPLogs mode:");
        System.out.println("  Pretty Print Logs mode is used to generate a readable HTML report of execution.\n");
        System.out.println("  " + cmd + " -mode=pplogs -logdir=<dir of a session log>  \n");
        System.out.println("  " + cmd + "-mode=cache -logdir=dir -session=session\n");
    }

    public static String getModeName(int mode) {
        switch (mode) {
            case 0: {
                return "Test Mode";
            }
            case 1: {
                return "Retest Mode";
            }
            case 2: {
                return "Resume Mode";
            }
            case 3: {
                return "Redo From Cache Mode";
            }
            case 4: {
                return "Doc Mode";
            }
            case 5: {
                return "Check Mode";
            }
            case 6: {
                return "Pretty Log Mode";
            }
        }
        return "Invalid Mode";
    }
}

