/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;

public class ExpressionContext
implements XSLTStaticContext {
    private StyleElement element;
    private NamePool namePool;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getNamePool();
    }

    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    public Executable getExecutable() {
        return this.element.getExecutable();
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.element.getPrincipalStylesheet().getCollationMap());
    }

    public LocationMap getLocationMap() {
        return this.element.getPrincipalStylesheet().getLocationMap();
    }

    public void issueWarning(String s2, SourceLocator locator) {
        this.element.issueWarning(s2, locator);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.element.getSystemId();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.element.getURIForPrefix(prefix, false);
        if (uri == null) {
            XPathException err = new XPathException("Undeclared namespace prefix " + Err.wrap(prefix));
            err.setErrorCode("XPST0081");
            err.setIsStaticError(true);
            throw err;
        }
        return uri;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.element.makeNamespaceContext();
    }

    public int getFingerprint(String qname, boolean useDefault) throws XPathException {
        String[] parts;
        try {
            parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
        }
        catch (QNameException err) {
            throw new XPathException(err.getMessage());
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            String uri = "";
            if (useDefault) {
                uri = this.getURIForPrefix(prefix);
            }
            return this.namePool.getFingerprint(uri, qname);
        }
        String uri = this.getURIForPrefix(prefix);
        return this.namePool.getFingerprint(uri, parts[1]);
    }

    public StructuredQName getStructuredQName(String qname, boolean useDefault) throws XPathException {
        String[] parts;
        try {
            parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
        }
        catch (QNameException err) {
            throw new XPathException(err.getMessage());
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            String uri = "";
            if (useDefault) {
                uri = this.getURIForPrefix(prefix);
            }
            return new StructuredQName("", uri, qname);
        }
        String uri = this.getURIForPrefix(prefix);
        return new StructuredQName(prefix, uri, parts[1]);
    }

    public VariableReference bindVariable(StructuredQName qName) throws XPathException {
        XSLVariableDeclaration xslVariableDeclaration = this.element.bindVariable(qName);
        VariableReference var = new VariableReference();
        xslVariableDeclaration.registerReference(var);
        return var;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.element.getPrincipalStylesheet().getFunctionLibrary();
    }

    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
            String uri = parts[0].length() == 0 ? this.getDefaultElementNamespace() : this.getURIForPrefix(parts[0]);
            return this.element.getPreparedStylesheet().getStyleNodeFactory().isElementAvailable(uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }

    public StringCollator getCollation(String name) {
        return this.element.getPrincipalStylesheet().findCollation(name);
    }

    public String getDefaultCollationName() {
        return this.element.getDefaultCollationName();
    }

    public String getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.element.backwardsCompatibleModeIsEnabled();
    }

    public boolean isImportedSchema(String namespace) {
        return this.getXSLStylesheet().isImportedSchema(namespace);
    }

    public Set getImportedSchemaNamespaces() {
        return this.getXSLStylesheet().getImportedSchemaTable();
    }

    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return this.getConfiguration().isSchemaAware(50) || type.isAllowedInBasicXSLT() || this.getXSLStylesheet().allowsAllBuiltInTypes();
    }

    public XSLStylesheet getXSLStylesheet() {
        return this.element.getPrincipalStylesheet();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

