/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.RandomOrderIterator;

public class RandomOrderGraph
extends WrappedGraph {
    private final int bufsz;

    public static Graph createDefaultGraph() {
        return new RandomOrderGraph(Factory.createDefaultGraph());
    }

    public static Model createDefaultModel() {
        return ModelFactory.createModelForGraph(RandomOrderGraph.createDefaultGraph());
    }

    public RandomOrderGraph(int bufsz, Graph base) {
        super(base);
        this.bufsz = bufsz;
    }

    public RandomOrderGraph(Graph base) {
        this(10, base);
    }

    @Override
    public ExtendedIterator<Triple> find(Triple triple) {
        return new RandomOrderIterator<Triple>(this.bufsz, super.find(triple));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s2, Node p, Node o) {
        return new RandomOrderIterator<Triple>(this.bufsz, super.find(s2, p, o));
    }

    @Override
    public Capabilities getCapabilities() {
        return new MyCapabilities(super.getCapabilities());
    }

    private class MyCapabilities
    implements Capabilities {
        private Capabilities parentCapabilities;

        public MyCapabilities(Capabilities parentCapabilities) {
            this.parentCapabilities = parentCapabilities;
        }

        @Override
        public boolean sizeAccurate() {
            return this.parentCapabilities.sizeAccurate();
        }

        @Override
        public boolean addAllowed() {
            return this.parentCapabilities.addAllowed();
        }

        @Override
        public boolean addAllowed(boolean everyTriple) {
            return this.parentCapabilities.addAllowed(everyTriple);
        }

        @Override
        public boolean deleteAllowed() {
            return this.parentCapabilities.deleteAllowed();
        }

        @Override
        public boolean deleteAllowed(boolean everyTriple) {
            return this.parentCapabilities.deleteAllowed(everyTriple);
        }

        @Override
        public boolean canBeEmpty() {
            return this.parentCapabilities.canBeEmpty();
        }

        @Override
        public boolean findContractSafe() {
            return this.parentCapabilities.findContractSafe();
        }

        @Override
        public boolean handlesLiteralTyping() {
            return this.parentCapabilities.handlesLiteralTyping();
        }

        @Override
        public boolean iteratorRemoveAllowed() {
            return false;
        }
    }
}

