/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class TextChunk
extends Chunk {
    protected String propName;

    public TextChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        String name = this.readText();
        module.addAiffProperty(new Property(this.propName, PropertyType.STRING, name));
        return true;
    }

    protected String readText() throws IOException {
        byte[] buf = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf(this._dstream, buf, this._module);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] >= 32 && buf[i] <= 127) continue;
            buf[i] = 32;
        }
        return new String(buf, "ASCII");
    }
}

