/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Html3_2DocDesc
extends HtmlDocDesc {
    private static Map stSupportedElements;

    public Html3_2DocDesc() {
        this.supportedElements = stSupportedElements;
        this.init();
    }

    private static void addAddressElement(List textContent) {
        String name = "address";
        ArrayList<String> addressContent = new ArrayList<String>(36);
        addressContent.addAll(textContent);
        addressContent.add("p");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, addressContent, null);
        stSupportedElements.put(name, td);
    }

    private static void addAElement(List textContent) {
        String name = "a";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, textContent, null);
        td.setAttributes(new String[]{"name", "href", "rel", "rev", "title"});
        td.setExcludedContent(new String[]{"a"});
        stSupportedElements.put(name, td);
    }

    private static void addAppletElement(HtmlAttributeDesc ialignAtt, List textContent) {
        String name = "applet";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(9);
        Html3_2DocDesc.addSimpleAttribute(atts, "codebase");
        atts.add(new HtmlAttributeDesc("code", null, 1));
        Html3_2DocDesc.addSimpleAttribute(atts, "alt");
        Html3_2DocDesc.addSimpleAttribute(atts, "name");
        atts.add(new HtmlAttributeDesc("width", null, 1));
        atts.add(new HtmlAttributeDesc("height", null, 1));
        atts.add(ialignAtt);
        Html3_2DocDesc.addSimpleAttribute(atts, "hspace");
        Html3_2DocDesc.addSimpleAttribute(atts, "vspace");
        ArrayList<String> appletContent = new ArrayList<String>(36);
        appletContent.addAll(textContent);
        appletContent.add("param");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, appletContent, atts);
        stSupportedElements.put(name, td);
    }

    private static void addAreaElement() {
        String name = "area";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(5);
        atts.add(new HtmlAttributeDesc("shape", new String[]{"rect", "circle", "poly"}, 1));
        Html3_2DocDesc.addSimpleAttribute(atts, "coords");
        Html3_2DocDesc.addSimpleAttribute(atts, "href");
        atts.add(new HtmlAttributeDesc("nohref", new String[]{"nohref"}, 4));
        atts.add(new HtmlAttributeDesc("alt", null, 1));
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    private static void addBaseElement() {
        String name = "base";
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(atts, "href");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    private static void addBasefontElement() {
        String name = "basefont";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, null);
        td.setAttributes(new String[]{"size"});
        stSupportedElements.put(name, td);
    }

    private static void addBlockquoteElement(List bodyContent) {
        String name = "blockquote";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, bodyContent, null);
        stSupportedElements.put(name, td);
    }

    private static void addBodyElement(List bodyContent) {
        String name = "body";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, bodyContent, null);
        td.setAttributes(new String[]{"bgcolor", "text", "link", "vlink", "alink", "background"});
        stSupportedElements.put(name, td);
    }

    private static void addBrElement() {
        String name = "br";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, null);
        stSupportedElements.put(name, td);
    }

    private static void addCaptionElement(List textContent, HtmlAttributeDesc valignAtt) {
        String name = "caption";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(1);
        atts.add(valignAtt);
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, textContent, atts);
        stSupportedElements.put(name, td);
    }

    private static void addCenterElement(List bodyContent) {
        String name = "center";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, bodyContent, null);
        stSupportedElements.put(name, td);
    }

    private static void addDdElement(List flowContent) {
        String name = "dd";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, flowContent, null);
        stSupportedElements.put(name, td);
    }

    private static void addDirElement(List listContent) {
        String name = "dir";
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, listContent, atts);
        stSupportedElements.put(name, td);
    }

    private static void addDivElement(List bodyContent, HtmlAttributeDesc halignAtt) {
        String name = "div";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(1);
        atts.add(halignAtt);
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, bodyContent, atts);
        stSupportedElements.put(name, td);
    }

    private static void addDlElement() {
        String name = "dl";
        ArrayList dlContent = new ArrayList(2);
        Html3_2DocDesc.addStringsToList(new String[]{"dt", "dd"}, dlContent);
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, dlContent, atts);
        stSupportedElements.put(name, td);
    }

    private static void addDtElement(List textContent) {
        String name = "dt";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, textContent, null);
        stSupportedElements.put(name, td);
    }

    private static void addFontElement(List textContent) {
        String name = "font";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, textContent, null);
        td.setAttributes(new String[]{"size", "color"});
        stSupportedElements.put(name, td);
    }

    private static void addFormElement(List bodyContent) {
        String name = "form";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(3);
        Html3_2DocDesc.addSimpleAttribute(atts, "action");
        atts.add(new HtmlAttributeDesc("method", null, 5));
        atts.add(new HtmlAttributeDesc("enctype", null, 5));
        ArrayList formContent = new ArrayList(bodyContent.size());
        formContent.addAll(bodyContent);
        Html3_2DocDesc.removeStringsFromList(formContent, new String[]{"form"});
        HtmlTagDesc td = new HtmlTagDesc("form", true, true, formContent, atts);
        stSupportedElements.put("form", td);
    }

    private static void addHeadElement() {
        String name = "head";
        String[] headMisc = new String[]{"script", "style", "meta", "link"};
        ArrayList<String> headContent = new ArrayList<String>(7);
        headContent.add("title");
        headContent.add("isindex");
        headContent.add("base");
        HtmlTagDesc td = new HtmlTagDesc(name, false, false, headContent, null);
        stSupportedElements.put(name, td);
        Html3_2DocDesc.addStringsToList(headMisc, headContent);
    }

    private static void addHrElement(HtmlAttributeDesc halignAtt) {
        String name = "hr";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(4);
        atts.add(halignAtt);
        Html3_2DocDesc.addSelfAttribute(atts, "noshade");
        Html3_2DocDesc.addSimpleAttribute(atts, "size");
        Html3_2DocDesc.addSimpleAttribute(atts, "width");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    private static void addImgElement(HtmlAttributeDesc ialignAtt) {
        String name = "img";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(10);
        Html3_2DocDesc.addRequiredAttribute(atts, "src");
        Html3_2DocDesc.addSimpleAttribute(atts, "alt");
        atts.add(ialignAtt);
        Html3_2DocDesc.addSimpleAttribute(atts, "height");
        Html3_2DocDesc.addSimpleAttribute(atts, "width");
        Html3_2DocDesc.addSimpleAttribute(atts, "border");
        Html3_2DocDesc.addSimpleAttribute(atts, "hspace");
        Html3_2DocDesc.addSimpleAttribute(atts, "vspace");
        Html3_2DocDesc.addSimpleAttribute(atts, "usemap");
        Html3_2DocDesc.addSelfAttribute(atts, "ismap");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    private static void addInputElement(HtmlAttributeDesc ialignAtt) {
        String name = "input";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(8);
        atts.add(new HtmlAttributeDesc("type", new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image"}, 5));
        Html3_2DocDesc.addSimpleAttribute(atts, "name");
        Html3_2DocDesc.addSimpleAttribute(atts, "value");
        Html3_2DocDesc.addSelfAttribute(atts, "checked");
        Html3_2DocDesc.addSimpleAttribute(atts, "size");
        Html3_2DocDesc.addSimpleAttribute(atts, "maxlength");
        Html3_2DocDesc.addSimpleAttribute(atts, "src");
        atts.add(ialignAtt);
        HtmlTagDesc td = new HtmlTagDesc("input", true, true, null, atts);
        stSupportedElements.put("input", td);
    }

    private static void addIsindexElement() {
        String name = "isindex";
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(atts, "prompt");
        HtmlTagDesc td = new HtmlTagDesc("isindex", true, false, null, atts);
        stSupportedElements.put("isindex", td);
    }

    private static void addLiElement(List flowContent) {
        String name = "li";
        ArrayList atts = new ArrayList(2);
        Html3_2DocDesc.addSimpleAttribute(atts, "type");
        Html3_2DocDesc.addSimpleAttribute(atts, "value");
        HtmlTagDesc td = new HtmlTagDesc("li", true, false, flowContent, atts);
        stSupportedElements.put("li", td);
    }

    private static void addLinkElement() {
        String name = "link";
        HtmlTagDesc td = new HtmlTagDesc("link", true, false, null, null);
        td.setAttributes(new String[]{"href", "rel", "rev", "title"});
        stSupportedElements.put("link", td);
    }

    private static void addMapElement() {
        String name = "map";
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(atts, "name");
        ArrayList<String> mapContent = new ArrayList<String>(1);
        mapContent.add("area");
        HtmlTagDesc td = new HtmlTagDesc("map", true, true, mapContent, atts);
        stSupportedElements.put("map", td);
    }

    private static void addMenuElement(List listContent) {
        String name = "menu";
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc("menu", true, true, listContent, atts);
        stSupportedElements.put("menu", td);
    }

    private static void addMetaElement() {
        String name = "meta";
        ArrayList atts = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(atts, "http-equiv");
        Html3_2DocDesc.addSimpleAttribute(atts, "name");
        Html3_2DocDesc.addRequiredAttribute(atts, "content");
        HtmlTagDesc td = new HtmlTagDesc("meta", true, false, null, atts);
        stSupportedElements.put("meta", td);
    }

    private static void addOlElement(List listContent) {
        String name = "ol";
        ArrayList atts = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(atts, "type");
        Html3_2DocDesc.addSimpleAttribute(atts, "start");
        Html3_2DocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc("ol", true, true, listContent, atts);
        stSupportedElements.put("ol", td);
    }

    private static void addOptionElement() {
        String name = "option";
        ArrayList atts = new ArrayList(2);
        Html3_2DocDesc.addSelfAttribute(atts, "selected");
        Html3_2DocDesc.addSimpleAttribute(atts, "value");
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc("option", true, true, content, atts);
        stSupportedElements.put("option", td);
    }

    private static void addPElement(HtmlAttributeDesc halignAtt, List textContent) {
        String name = "p";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(1);
        atts.add(halignAtt);
        HtmlTagDesc td = new HtmlTagDesc("p", true, false, textContent, atts);
        stSupportedElements.put("p", td);
    }

    private static void addParamElement() {
        String name = "param";
        ArrayList atts = new ArrayList(2);
        Html3_2DocDesc.addRequiredAttribute(atts, "name");
        Html3_2DocDesc.addSimpleAttribute(atts, "value");
        HtmlTagDesc td = new HtmlTagDesc("param", true, false, null, atts);
        stSupportedElements.put("param", td);
    }

    private static void addPreElement(List textContent) {
        String name = "pre";
        ArrayList atts = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(atts, "width");
        ArrayList preContent = new ArrayList(35);
        preContent.addAll(textContent);
        Html3_2DocDesc.removeStringsFromList(preContent, new String[]{"img", "big", "small", "sub", "sup", "font"});
        HtmlTagDesc td = new HtmlTagDesc("pre", true, true, preContent, atts);
        stSupportedElements.put("pre", td);
    }

    private static void addScriptElement() {
        String name = "script";
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc("script", true, true, content, null);
        stSupportedElements.put("script", td);
    }

    private static void addSelectElement() {
        String name = "select";
        ArrayList atts = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(atts, "name");
        Html3_2DocDesc.addSimpleAttribute(atts, "size");
        Html3_2DocDesc.addSelfAttribute(atts, "multiple");
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("option");
        HtmlTagDesc td = new HtmlTagDesc("select", true, true, content, atts);
        stSupportedElements.put("select", td);
    }

    private static void addStyleElement() {
        String name = "style";
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc("style", true, true, content, null);
        stSupportedElements.put("style", td);
    }

    private static void addTableElement() {
        String name = "table";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(5);
        atts.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4));
        Html3_2DocDesc.addSimpleAttribute(atts, "width");
        Html3_2DocDesc.addSimpleAttribute(atts, "border");
        Html3_2DocDesc.addSimpleAttribute(atts, "cellspacing");
        Html3_2DocDesc.addSimpleAttribute(atts, "cellpadding");
        ArrayList<String> content = new ArrayList<String>(2);
        content.add("caption");
        content.add("tr");
        HtmlTagDesc td = new HtmlTagDesc("table", true, true, content, atts);
        stSupportedElements.put("table", td);
    }

    private static void addTextareaElement() {
        String name = "textarea";
        ArrayList atts = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(atts, "name");
        Html3_2DocDesc.addSimpleAttribute(atts, "rows");
        Html3_2DocDesc.addSimpleAttribute(atts, "cols");
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc("textarea", true, true, content, atts);
        stSupportedElements.put("textarea", td);
    }

    private static void addTdElement(List bodyContent, List thtdAtts) {
        String name = "td";
        HtmlTagDesc td = new HtmlTagDesc("td", true, false, bodyContent, thtdAtts);
        stSupportedElements.put("td", td);
    }

    private static void addThElement(List bodyContent, List thtdAtts) {
        String name = "th";
        HtmlTagDesc td = new HtmlTagDesc("th", true, false, bodyContent, thtdAtts);
        stSupportedElements.put("th", td);
    }

    private static void addTitleElement() {
        String name = "title";
        ArrayList<HtmlSpecialToken> pcdataContent = new ArrayList<HtmlSpecialToken>(1);
        pcdataContent.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, pcdataContent, null);
        stSupportedElements.put(name, td);
    }

    private static void addTrElement(HtmlAttributeDesc halignAtt, HtmlAttributeDesc valignAtt) {
        String name = "tr";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(2);
        atts.add(halignAtt);
        atts.add(valignAtt);
        ArrayList<String> content = new ArrayList<String>(2);
        content.add("th");
        content.add("td");
        HtmlTagDesc td = new HtmlTagDesc("tr", true, false, content, atts);
        stSupportedElements.put("tr", td);
    }

    private static void addUlElement(List listContent) {
        String name = "ul";
        ArrayList atts = new ArrayList(2);
        Html3_2DocDesc.addSimpleAttribute(atts, "type");
        Html3_2DocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc("ul", true, true, listContent, atts);
        stSupportedElements.put("ul", td);
    }

    static {
        HtmlTagDesc td;
        String name;
        int i;
        stSupportedElements = new HashMap(280);
        String[] fontMarkup = new String[]{"tt", "i", "b", "u", "strike", "big", "small", "sub", "sup"};
        String[] phraseMarkup = new String[]{"em", "strong", "dfn", "code", "samp", "kbd", "var", "cite"};
        String[] specialMarkup = new String[]{"a", "img", "applet", "font", "basefont", "br", "script", "map"};
        String[] formMarkup = new String[]{"input", "select", "textarea"};
        String[] listMarkup = new String[]{"ul", "ol", "dir", "menu"};
        ArrayList<HtmlSpecialToken> textContent = new ArrayList<HtmlSpecialToken>(35);
        Html3_2DocDesc.addStringsToList(fontMarkup, textContent);
        Html3_2DocDesc.addStringsToList(phraseMarkup, textContent);
        Html3_2DocDesc.addStringsToList(specialMarkup, textContent);
        Html3_2DocDesc.addStringsToList(formMarkup, textContent);
        textContent.add(HtmlSpecialToken.PCDATA);
        ArrayList blockContent = new ArrayList(20);
        Html3_2DocDesc.addStringsToList(listMarkup, blockContent);
        String[] blockMisc = new String[]{"p", "pre", "dl", "div", "center", "blockquote", "form", "isindex", "hr", "table"};
        Html3_2DocDesc.addStringsToList(blockMisc, blockContent);
        ArrayList flowContent = new ArrayList(30);
        flowContent.addAll(blockContent);
        flowContent.addAll(textContent);
        for (i = 0; i < fontMarkup.length; ++i) {
            name = fontMarkup[i];
            td = new HtmlTagDesc(name, true, true, textContent, null);
            stSupportedElements.put(name, td);
        }
        for (i = 0; i < phraseMarkup.length; ++i) {
            name = phraseMarkup[i];
            td = new HtmlTagDesc(name, true, true, textContent, null);
            stSupportedElements.put(name, td);
        }
        Html3_2DocDesc.addFontElement(textContent);
        Html3_2DocDesc.addBasefontElement();
        Html3_2DocDesc.addBrElement();
        ArrayList<Object> bodyContent = new ArrayList<Object>(100);
        Html3_2DocDesc.addStringsToList(headings, bodyContent);
        bodyContent.addAll(textContent);
        bodyContent.addAll(blockContent);
        bodyContent.add("address");
        Html3_2DocDesc.addBodyElement(bodyContent);
        Html3_2DocDesc.addAddressElement(textContent);
        HtmlAttributeDesc halignAtt = new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4);
        Html3_2DocDesc.addDivElement(bodyContent, halignAtt);
        Html3_2DocDesc.addCenterElement(bodyContent);
        Html3_2DocDesc.addAElement(textContent);
        Html3_2DocDesc.addMapElement();
        Html3_2DocDesc.addAreaElement();
        Html3_2DocDesc.addLinkElement();
        HtmlAttributeDesc ialignAtt = new HtmlAttributeDesc("align", new String[]{"top", "middle", "bottom", "left", "right"}, 4);
        Html3_2DocDesc.addImgElement(ialignAtt);
        Html3_2DocDesc.addAppletElement(ialignAtt, textContent);
        Html3_2DocDesc.addParamElement();
        Html3_2DocDesc.addHrElement(halignAtt);
        Html3_2DocDesc.addPElement(halignAtt, textContent);
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(1);
        atts.add(halignAtt);
        for (i = 0; i < headings.length; ++i) {
            name = headings[i];
            td = new HtmlTagDesc(name, true, true, textContent, atts);
            stSupportedElements.put(name, td);
        }
        Html3_2DocDesc.addPreElement(textContent);
        Html3_2DocDesc.addBlockquoteElement(bodyContent);
        Html3_2DocDesc.addDlElement();
        Html3_2DocDesc.addDtElement(textContent);
        Html3_2DocDesc.addDdElement(flowContent);
        ArrayList<String> listContent = new ArrayList<String>(1);
        listContent.add("li");
        Html3_2DocDesc.addOlElement(listContent);
        Html3_2DocDesc.addUlElement(listContent);
        Html3_2DocDesc.addDirElement(listContent);
        Html3_2DocDesc.addMenuElement(listContent);
        Html3_2DocDesc.addLiElement(flowContent);
        Html3_2DocDesc.addFormElement(bodyContent);
        Html3_2DocDesc.addInputElement(ialignAtt);
        Html3_2DocDesc.addSelectElement();
        Html3_2DocDesc.addOptionElement();
        Html3_2DocDesc.addTableElement();
        HtmlAttributeDesc valignAtt = new HtmlAttributeDesc("valign", new String[]{"top", "middle", "bottom"}, 4);
        Html3_2DocDesc.addTrElement(halignAtt, valignAtt);
        ArrayList<HtmlAttributeDesc> thtdAtts = new ArrayList<HtmlAttributeDesc>(7);
        Html3_2DocDesc.addSelfAttribute(thtdAtts, "nowrap");
        Html3_2DocDesc.addSimpleAttribute(thtdAtts, "rowspan");
        Html3_2DocDesc.addSimpleAttribute(thtdAtts, "colspan");
        thtdAtts.add(halignAtt);
        thtdAtts.add(valignAtt);
        Html3_2DocDesc.addSimpleAttribute(thtdAtts, "width");
        Html3_2DocDesc.addSimpleAttribute(thtdAtts, "height");
        Html3_2DocDesc.addThElement(bodyContent, thtdAtts);
        Html3_2DocDesc.addTdElement(bodyContent, thtdAtts);
        Html3_2DocDesc.addCaptionElement(textContent, valignAtt);
        Html3_2DocDesc.addHeadElement();
        Html3_2DocDesc.addTitleElement();
        Html3_2DocDesc.addIsindexElement();
        Html3_2DocDesc.addBaseElement();
        Html3_2DocDesc.addMetaElement();
        Html3_2DocDesc.addScriptElement();
        Html3_2DocDesc.addStyleElement();
        name = "html";
        ArrayList<String> htmlContent = new ArrayList<String>(2);
        htmlContent.add("head");
        htmlContent.add("body");
        td = new HtmlTagDesc(name, false, false, htmlContent, null);
        td.setAttributes(new String[]{"version"});
        stSupportedElements.put(name, td);
    }
}

