/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg.JpegStrings;

public class QuantizationTable {
    private int _precision;
    private int _destIdentifier;

    public QuantizationTable(int precision, int destIdentifier) {
        this._precision = precision;
        this._destIdentifier = destIdentifier;
    }

    public Property makeProperty(boolean raw) {
        Property[] parray = new Property[2];
        if (raw) {
            parray[0] = new Property("Precision", PropertyType.INTEGER, new Integer(this._precision));
        } else {
            String prec = "Undefined";
            try {
                prec = JpegStrings.DQT_PRECISION[this._precision];
            }
            catch (Exception exception) {
                // empty catch block
            }
            parray[0] = new Property("Precision", PropertyType.STRING, prec);
        }
        parray[1] = new Property("DestinationIdentifier", PropertyType.INTEGER, new Integer(this._destIdentifier));
        return new Property("QuantizationTable", PropertyType.PROPERTY, PropertyArity.ARRAY, parray);
    }
}

