/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorGroupBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;

public class ColorSpecBox
extends JP2Box {
    public ColorSpecBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof ColorGroupBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        ArrayList<Property> subProps = new ArrayList<Property>(2);
        Property prop = new Property("ColorSpec", PropertyType.PROPERTY, PropertyArity.LIST, subProps);
        int meth = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        if (meth > 2) {
            this._module.setJP2Compliant(false);
        }
        subProps.add(this._module.addIntegerProperty("Method", meth, JP2Strings.methodStr));
        int prec = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        subProps.add(new Property("Precedence", PropertyType.INTEGER, new Integer(prec)));
        int approx = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        if (approx == 0) {
            this._module.setJPXCompliant(false);
            subProps.add(new Property("Approx", PropertyType.INTEGER, new Integer(0)));
        } else {
            this._module.setJP2Compliant(false);
            subProps.add(this._module.addIntegerProperty("Approx", approx, JP2Strings.approxStr, JP2Strings.approxIdx));
        }
        if (meth == 1) {
            long enumCS = this._module.readUnsignedInt(this._dstrm);
            this._module.skipBytes(this._dstrm, len - 7, this._module);
            Property p = this._module.addIntegerProperty("EnumCS", (int)enumCS, JP2Strings.enumCSStr);
            subProps.add(p);
        } else if (meth == 2) {
            this._module.skipBytes(this._dstrm, 128L, this._module);
            long tagCount = this._module.readUnsignedInt(this._dstrm);
            HashSet<String> tagSignatureSet = new HashSet<String>();
            int i = 0;
            while ((long)i < tagCount) {
                tagSignatureSet.add(this._module.read4Chars(this._dstrm));
                this._module.skipBytes(this._dstrm, 8L, this._module);
                ++i;
            }
            if (tagSignatureSet.contains("desc") && tagSignatureSet.contains("kTRC") && tagSignatureSet.contains("wtpt") && tagSignatureSet.contains("cprt")) {
                subProps.add(new Property("RestrictedICCProfile", PropertyType.STRING, "Monochrome Input Profile"));
            } else if (tagSignatureSet.contains("desc") && tagSignatureSet.contains("rXYZ") && tagSignatureSet.contains("gXYZ") && tagSignatureSet.contains("bXYZ") && tagSignatureSet.contains("rTRC") && tagSignatureSet.contains("gTRC") && tagSignatureSet.contains("bTRC") && tagSignatureSet.contains("wtpt") && tagSignatureSet.contains("cprt")) {
                subProps.add(new Property("RestrictedICCProfile", PropertyType.STRING, "Three-Component Matrix-Based Input Profile"));
            } else {
                this._repInfo.setMessage(new ErrorMessage("Color spec box with method 2 has unrecognized ICC profile", this.filePos));
                this._repInfo.setValid(false);
            }
        } else {
            this._module.setJP2Compliant(false);
        }
        if (this._parentBox instanceof JP2HeaderBox) {
            this._module.addColorSpec(prop);
        } else if (this._parentBox instanceof ColorGroupBox) {
            ((ColorGroupBox)this._parentBox).addColorSpec(prop);
        }
        if (this._boxHeader.getLength() != 0L) {
            this._module.skipBytes(this._dstrm, (int)((long)len - (this._module.getFilePos() - this.startBytesRead)), this._module);
        }
        this.finalizeBytesRead();
        this._module.setColorSpecSeen(true);
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Color Specification Box";
    }
}

