/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ROIBox
extends JP2Box {
    private Property roiProp;

    public ROIBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        String baddata = "Invalid data in ROI";
        this.initBytesRead();
        int nroi = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        ArrayList<Property> propList = new ArrayList<Property>(nroi);
        JhoveBase je = this._module.getBase();
        boolean raw = je.getShowRawFlag();
        for (int i = 0; i < nroi; ++i) {
            ArrayList<Property> roiPropList = new ArrayList<Property>(7);
            int incs = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            if (incs > 1) {
                this._repInfo.setMessage(new ErrorMessage("Invalid data in ROI", this._module.getFilePos()));
                this._repInfo.setValid(false);
            }
            roiPropList.add(this._module.addIntegerProperty("InCodestream", incs, JP2Strings.inCodestreamStr));
            int rtyp = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            if (rtyp > 1) {
                this._repInfo.setMessage(new ErrorMessage("Invalid region type in ROI Box", this._module.getFilePos()));
                this._repInfo.setValid(false);
            }
            roiPropList.add(this._module.addIntegerProperty("RegionType", rtyp, JP2Strings.roiTypeStr));
            int rcp = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            roiPropList.add(new Property("CodingPriority", PropertyType.INTEGER, new Integer(rcp)));
            long lcx = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("HorizontalLocation", PropertyType.LONG, new Long(lcx)));
            long lcy = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("HorizontalLocation", PropertyType.LONG, new Long(lcy)));
            long wdt = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("Width", PropertyType.LONG, new Long(wdt)));
            long hth = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("Height", PropertyType.LONG, new Long(hth)));
            propList.add(new Property("ROI", PropertyType.PROPERTY, PropertyArity.LIST, roiPropList));
        }
        this.roiProp = new Property("ROIs", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        if (!(this._parentBox instanceof AssociationBox)) {
            if (this._parentBox instanceof CodestreamHeaderBox) {
                Codestream cs = ((CodestreamHeaderBox)this._parentBox).getCodestream();
                cs.setROIProperty(this.roiProp);
            } else {
                this._module.addProperty(this.roiProp);
            }
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "ROI Description Box";
    }

    @Override
    protected Property getSelfPropDesc() {
        if (this.roiProp != null) {
            return new Property("Description", PropertyType.PROPERTY, this.roiProp);
        }
        return null;
    }
}

