/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.TilePart;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Tile
extends MainOrTile {
    private List _tileParts = new LinkedList();
    private List _pptLengthList;

    public void addTilePart(TilePart tp) {
        this._tileParts.add(tp);
    }

    public List getTileParts() {
        return this._tileParts;
    }

    public void addPPTLength(long len) {
        this._pptLengthList.add(new Long(len));
    }

    public Property makeProperty() {
        LinkedList<Property> propList = new LinkedList<Property>();
        if (!this._tileParts.isEmpty()) {
            ListIterator tpiter = this._tileParts.listIterator();
            while (tpiter.hasNext()) {
                TilePart tp = (TilePart)tpiter.next();
                propList.add(tp.makeProperty());
            }
        }
        if (this._components != null) {
            for (int i = 0; i < this._components.length; ++i) {
                if (this._components[i] != null) continue;
                this._components[i] = new Property("Component", PropertyType.PROPERTY, PropertyArity.LIST, new LinkedList());
            }
            propList.add(new Property("Components", PropertyType.PROPERTY, PropertyArity.ARRAY, this._components));
        }
        if (this._codProperty != null) {
            propList.add(this._codProperty);
        }
        if (this._qcdProperty != null) {
            propList.add(this._qcdProperty);
        }
        if (this._pocProperty != null) {
            propList.add(this._pocProperty);
        }
        if (this._packetLengthList != null && !this._packetLengthList.isEmpty()) {
            propList.add(new Property("PacketLengths", PropertyType.LONG, PropertyArity.LIST, this._packetLengthList));
        }
        if (this._pptLengthList != null && this._pptLengthList.isEmpty()) {
            propList.add(new Property("PackedPacketHeaderLengths", PropertyType.LONG, PropertyArity.LIST, this._pptLengthList));
        }
        if (!this._comments.isEmpty()) {
            propList.add(new Property("Comments", PropertyType.PROPERTY, PropertyArity.LIST, this._comments));
        }
        return new Property("Tile", PropertyType.PROPERTY, PropertyArity.LIST, propList);
    }
}

