/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DataEntryURLBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDListBox;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class UUIDInfoBox
extends JP2Box {
    private Property _urlProp;
    private Property _uuidListProp;

    public UUIDInfoBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        int sizeLeft = (int)this._boxHeader.getDataLength();
        BoxHeader subhdr = new BoxHeader(this._module, this._dstrm);
        JP2Box box = null;
        while (this.hasNext() && (box = (JP2Box)this.next()) != null) {
            if (box instanceof UUIDListBox || box instanceof UUIDListBox || box instanceof DataEntryURLBox) {
                box.setBoxHeader(subhdr);
                box.setDataInputStream(this._dstrm);
                box.setRandomAccessFile(this._raf);
                box.setRepInfo(this._repInfo);
                box.setModule(this._module);
                if (box.readBox()) continue;
                return false;
            }
            box.skipBox();
        }
        if (sizeLeft != 0) {
            this._repInfo.setMessage(new ErrorMessage("Size of contained boxes underruns UUID Info Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        ArrayList<Property> propList = new ArrayList<Property>(2);
        if (this._urlProp != null) {
            propList.add(this._urlProp);
        }
        if (this._uuidListProp != null) {
            propList.add(this._uuidListProp);
        }
        this._module.addUUIDInfo(new Property("UUIDInfo", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        this.finalizeBytesRead();
        return true;
    }

    protected void setURL(String url) {
        this._urlProp = new Property("URL", PropertyType.STRING, url);
    }

    protected void setUUIDList(byte[][] uuids) {
        ArrayList<Property> propList = new ArrayList<Property>(uuids.length);
        for (int i = 0; i < uuids.length; ++i) {
            propList.add(new Property("UUIDList", PropertyType.BYTE, PropertyArity.ARRAY, uuids[i]));
        }
        this._uuidListProp = new Property("UUIDInfo", PropertyType.PROPERTY, PropertyArity.LIST, propList);
    }

    @Override
    protected String getSelfPropName() {
        return "UUID Info Box";
    }
}

