/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class DataChunk
extends Chunk {
    public DataChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        Property lenProp = new Property("DataLength", PropertyType.LONG, new Long(this.bytesLeft));
        if (module.getCompressionCode() == 1) {
            module.addSamples(this.bytesLeft / (long)module.getBlockAlign());
        }
        module.addWaveProperty(new Property("Data", PropertyType.PROPERTY, lenProp));
        module.markFirstSampleOffset();
        module.skipBytes(this._dstream, this.bytesLeft, module);
        return true;
    }
}

