/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifUserCommentChunk
extends Chunk {
    private static final String asciiDes = "ASCII";
    private static final String jisDes = "JIS";
    private static final String unicodeDes = "UNICODE";

    public ExifUserCommentChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        if (this.bytesLeft < 8L) {
            info.setMessage(new ErrorMessage("Exif User Comment Chunk is too short"));
            info.setWellFormed(false);
            return false;
        }
        byte[] buf = new byte[8];
        ModuleBase.readByteBuf(this._dstream, buf, module);
        String encoding = new String(buf).trim();
        this.bytesLeft -= 8L;
        String charset = null;
        if (asciiDes.equals(encoding)) {
            charset = "US-ASCII";
        } else if (jisDes.equals(encoding)) {
            charset = "EUC_JP";
        } else if (unicodeDes.equals(encoding)) {
            charset = "UTF-16";
        }
        buf = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf(this._dstream, buf, module);
        String text = null;
        try {
            if (charset != null) {
                text = new String(buf, charset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (text == null) {
            text = new String(buf);
        }
        ExifInfo exif = module.getExifInfo();
        module.getExifInfo().setUserComment(text);
        return true;
    }
}

