/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.tiffTests;

import java.util.List;
import org.opengis.cite.geotiff11.tiffTests.CommonTiffMeta;
import org.opengis.cite.geotiff11.util.TiffDump;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GeoKeyDirectoryTests
extends CommonTiffMeta {
    @Test(description="GeoKey Directory Test", groups={"verifyGeoKeyDirectory"})
    public void verifyGeoKeyDirectory() throws Exception {
        for (TiffDump.Directory directory : this.tiffDump.getDirectories()) {
            TiffDump.Tag geoKeyDirectory = directory.getTag(34735);
            if (directory.getOffset() == 0 || geoKeyDirectory == null) continue;
            List<Object> keyEntrySet = geoKeyDirectory.getValues();
            Assert.assertTrue(geoKeyDirectory.getTypeValue() == 3, "the GeoKeyDirectoryTag SHALL have type = SHORT (2-byte unsigned integer)");
            if (keyEntrySet != null) {
                Assert.assertTrue(keyEntrySet.size() >= 4, "the GeoKeyDirectoryTag SHALL include at least 4 keys (short integers) as header information");
                Assert.assertTrue(keyEntrySet.size() % 4 == 0, "each Key Entry in the Key Entry Set SHALL include 4 unsigned short integer values");
                Assert.assertTrue(keyEntrySet.get(0).equals(1), "the value of KeyDirectoryVersion SHALL be 1");
                Assert.assertTrue(keyEntrySet.get(1).equals(1), "the value of KeyRevision SHALL be 1");
                Assert.assertTrue(keyEntrySet.get(2).equals(0) || keyEntrySet.get(2).equals(1), "the MinorRevision for this standard SHALL be O or 1");
                int keySetCount = (Integer)keyEntrySet.get(3);
                int count = 0;
                int previousGeoKey = -1000;
                for (int i = 4; i < keyEntrySet.size(); i += 4) {
                    int geoKey = (Integer)keyEntrySet.get(i);
                    if (geoKey < previousGeoKey) {
                        Assert.assertTrue(count == keySetCount, "the GeoKeyDirectoryTag SHALL hold NumberOfKeys KeyEntry Sets in addition to the header information");
                        break;
                    }
                    Assert.assertTrue(geoKey > previousGeoKey, "the GeoKey entries in a GeoTIFF file SHALL be written out to the file with the key-IDs sorted in ascending order");
                    previousGeoKey = geoKey;
                    ++count;
                    int type = (Integer)keyEntrySet.get(i + 1);
                    if (type == 0 || type == 34735) {
                        // empty if block
                    }
                    if (type == 34736) {
                        // empty if block
                    }
                    if (type != 34737) continue;
                }
            }
            return;
        }
        Assert.fail("GeoKeyDirectoryTag not found");
    }
}

