/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PageLabelNode {
    protected PdfModule _module;
    protected PageLabelNode _parent;
    protected PdfDictionary _dict;
    protected boolean _walkFinished;
    private List<PageLabelNode> _descendants;
    private Iterator<PageLabelNode> _descendantsIter;
    private int _currentKey;
    private PdfObject _currentValue;
    private int _prevKey;
    private PdfObject _prevValue;
    private int _currentNumsIndex;
    private int _currentNumsLength;
    private Vector _currentNumsVec;
    private PageLabelNode _currentDescendant;
    private PageLabelNode _currentLeaf;

    public PageLabelNode(PdfModule module, PageLabelNode parent, PdfDictionary dict) {
        this._module = module;
        this._parent = parent;
        this._dict = dict;
    }

    public void buildSubtree() throws PdfException {
        PdfArray kids = null;
        try {
            kids = (PdfArray)this._dict.get("Kids");
            if (kids != null) {
                Vector<PdfObject> kidsVec = kids.getContent();
                this._descendants = new ArrayList<PageLabelNode>(kidsVec.size());
                for (int i = 0; i < kidsVec.size(); ++i) {
                    PdfDictionary kid = (PdfDictionary)this._module.resolveIndirectObject(kidsVec.elementAt(i));
                    PageLabelNode nodeObj = new PageLabelNode(this._module, this, kid);
                    nodeObj.buildSubtree();
                    this._descendants.add(nodeObj);
                }
            } else {
                this._descendants = null;
            }
        }
        catch (PdfException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PdfInvalidException("Invalid page label node");
        }
    }

    public void startWalk() {
        if (this._descendants != null) {
            this._descendantsIter = this._descendants.listIterator();
            this._walkFinished = false;
        } else {
            this._descendantsIter = null;
            this._walkFinished = true;
        }
        this._currentDescendant = null;
        this._currentLeaf = null;
        this._currentKey = -1;
        this._currentValue = null;
        this._prevKey = -1;
        this._prevValue = null;
    }

    public PageLabelNode nextLeafObject() {
        PageLabelNode retval;
        if (this._walkFinished) {
            return null;
        }
        if (this._currentDescendant == null) {
            if (this._descendantsIter == null) {
                this._walkFinished = true;
                return this;
            }
            this._currentDescendant = this._descendantsIter.next();
            this._currentDescendant.startWalk();
        }
        if ((retval = this._currentDescendant.nextLeafObject()) == null) {
            if (this._descendantsIter.hasNext()) {
                this._currentDescendant = this._descendantsIter.next();
                this._currentDescendant.startWalk();
                return this._currentDescendant.nextLeafObject();
            }
            this._walkFinished = true;
            return null;
        }
        return retval;
    }

    public boolean findNextKeyValue() throws PdfException {
        try {
            if (this._currentLeaf == null || this._currentNumsIndex >= this._currentNumsLength) {
                this._currentLeaf = this.nextLeafObject();
                if (this._currentLeaf == null) {
                    this._prevKey = this._currentKey;
                    this._prevValue = this._currentValue;
                    this._currentKey = Integer.MAX_VALUE;
                    return false;
                }
                this._currentNumsIndex = 0;
                PdfArray pairArray = (PdfArray)this._module.resolveIndirectObject(this._currentLeaf._dict.get("Nums"));
                if (pairArray == null) {
                    throw new PdfInvalidException("Missing expected element in page number dictionary");
                }
                this._currentNumsVec = pairArray.getContent();
                this._currentNumsLength = this._currentNumsVec.size();
            }
            PdfSimpleObject keyObj = (PdfSimpleObject)this._currentNumsVec.elementAt(this._currentNumsIndex);
            this._prevKey = this._currentKey;
            this._prevValue = this._currentValue;
            this._currentKey = keyObj.getIntValue();
            this._currentValue = (PdfObject)this._currentNumsVec.elementAt(this._currentNumsIndex + 1);
            this._currentNumsIndex += 2;
            return true;
        }
        catch (PdfInvalidException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PdfInvalidException("Invalid date in page number tree");
        }
    }

    public int getCurrentKey() {
        return this._currentKey;
    }

    public PdfObject _getCurrentValue() {
        return this._currentValue;
    }

    public int getPrevKey() {
        return this._prevKey;
    }

    public PdfObject getPrevValue() {
        return this._prevValue;
    }

    public static String intToRoman(int n, boolean upperCase) {
        StringBuffer buf = new StringBuffer();
        while (n >= 1000) {
            buf.append("M");
            n -= 1000;
        }
        if (n >= 900) {
            buf.append("CM");
            n -= 900;
        }
        if (n >= 500) {
            buf.append("D");
            while (n >= 600) {
                buf.append("C");
                n -= 100;
            }
            n -= 500;
        }
        if (n >= 400) {
            buf.append("CD");
            n -= 400;
        }
        while (n >= 100) {
            buf.append("C");
            n -= 100;
        }
        if (n >= 90) {
            buf.append("XC");
            n -= 90;
        }
        if (n >= 50) {
            buf.append("L");
            while (n >= 60) {
                buf.append("X");
                n -= 10;
            }
            n -= 50;
        }
        if (n >= 40) {
            buf.append("XL");
            n -= 40;
        }
        while (n >= 10) {
            buf.append("X");
            n -= 10;
        }
        switch (n) {
            case 1: {
                buf.append("I");
                break;
            }
            case 2: {
                buf.append("II");
                break;
            }
            case 3: {
                buf.append("III");
                break;
            }
            case 4: {
                buf.append("IV");
                break;
            }
            case 5: {
                buf.append("V");
                break;
            }
            case 6: {
                buf.append("VI");
                break;
            }
            case 7: {
                buf.append("VII");
                break;
            }
            case 8: {
                buf.append("VIII");
                break;
            }
            case 9: {
                buf.append("IX");
            }
        }
        String val = buf.toString();
        if (upperCase) {
            return val;
        }
        return val.toLowerCase();
    }

    public static String intToBase26(int n, boolean upperCase) {
        int repeatCount = (n - 1) / 26 + 1;
        StringBuffer buf = new StringBuffer();
        int ch = upperCase ? 65 + (n - 1) % 26 : 97 + (n - 1) % 26;
        while (--repeatCount >= 0) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

