/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class PeakEnvelopeChunk
extends Chunk {
    public PeakEnvelopeChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        long version = module.readUnsignedInt(this._dstream);
        long format = module.readUnsignedInt(this._dstream);
        long pointsPerValue = module.readUnsignedInt(this._dstream);
        long blockSize = module.readUnsignedInt(this._dstream);
        long peakChannels = module.readUnsignedInt(this._dstream);
        long numPeakFrames = module.readUnsignedInt(this._dstream);
        long posPeakOfPeaks = module.readUnsignedInt(this._dstream);
        long offsetToPeaks = module.readUnsignedInt(this._dstream);
        byte[] buf28 = new byte[28];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf28, (ModuleBase)module);
        String timestamp = this.byteBufString(buf28);
        module.skipBytes(this._dstream, 60L, module);
        Property peaksProp = null;
        if (this.bytesLeft > 120L) {
            int pointBytes = (int)(this.bytesLeft - 120L);
            int nPoints = 0;
            int nValues = 0;
            if (format == 1L) {
                nPoints = pointBytes;
            } else if (format == 2L) {
                nPoints = pointBytes / 2;
            } else {
                info.setValid(false);
                info.setMessage((Message)new ErrorMessage("Invalid format value in Peak Envelope Chunk"));
            }
            if (pointsPerValue == 1L) {
                nValues = nPoints;
            } else if (pointsPerValue == 2L) {
                nValues = nPoints / 2;
            } else {
                info.setValid(false);
                info.setMessage((Message)new ErrorMessage("Invalid pointsPerValue in Peak Envelope Chunk"));
            }
            if (info.getValid() == 0) {
                module.skipBytes(this._dstream, (int)this.bytesLeft - 120, module);
                return true;
            }
            if (pointsPerValue == 2L) {
                Property[] pointArray = new Property[nValues];
                for (int i = 0; i < nValues; ++i) {
                    int[] point = new int[2];
                    pointArray[i] = new Property("Point", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)point);
                    if (format == 1L) {
                        point[0] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
                        point[1] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module);
                        continue;
                    }
                    point[0] = module.readUnsignedShort(this._dstream);
                    point[1] = module.readUnsignedShort(this._dstream);
                }
                peaksProp = new Property("PeakEnvelopeData", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)pointArray);
            } else {
                int[] pointArray = new int[nValues];
                for (int i = 0; i < nValues; ++i) {
                    pointArray[i] = format == 1L ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)module) : module.readUnsignedShort(this._dstream);
                }
                peaksProp = new Property("PeakEnvelopeData", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)pointArray);
            }
        }
        ArrayList<Property> plist = new ArrayList<Property>(20);
        plist.add(new Property("Version", PropertyType.LONG, (Object)new Long(version)));
        plist.add(new Property("Format", PropertyType.LONG, (Object)new Long(format)));
        plist.add(new Property("PointsPerValue", PropertyType.LONG, (Object)new Long(pointsPerValue)));
        plist.add(new Property("BlockSize", PropertyType.LONG, (Object)new Long(blockSize)));
        plist.add(new Property("PeakChannels", PropertyType.LONG, (Object)new Long(peakChannels)));
        plist.add(new Property("NumPeakFrames", PropertyType.LONG, (Object)new Long(numPeakFrames)));
        plist.add(new Property("PosPeakOfPeaks", PropertyType.LONG, (Object)new Long(posPeakOfPeaks)));
        plist.add(new Property("OffsetToPeaks", PropertyType.LONG, (Object)new Long(offsetToPeaks)));
        if (timestamp.length() > 0) {
            plist.add(new Property("Timestamp", PropertyType.STRING, (Object)timestamp));
        }
        if (peaksProp != null) {
            plist.add(peaksProp);
        }
        module.addWaveProperty(new Property("PeakEnvelope", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        return true;
    }
}

