/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountedInputStream
extends FilterInputStream {
    private int bytesLeft;

    public CountedInputStream(InputStream instrm, int count) {
        super(instrm);
        this.bytesLeft = count;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft <= 0) {
            return -1;
        }
        int ch = super.read();
        if (ch != -1) {
            --this.bytesLeft;
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = b.length;
        int bytesRead = len <= this.bytesLeft ? super.read(b) : super.read(b, 0, this.bytesLeft);
        this.bytesLeft -= bytesRead;
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = len <= this.bytesLeft ? super.read(b, off, len) : super.read(b, off, this.bytesLeft);
        this.bytesLeft -= bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesRead = super.skip(n);
        this.bytesLeft = (long)this.bytesLeft < bytesRead ? 0 : (int)((long)this.bytesLeft - bytesRead);
        return bytesRead;
    }
}

