/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Property {
    private String _name;
    private PropertyType _type;
    private PropertyArity _arity;
    private Object _value;

    public Property(String name, PropertyType type, Object value) {
        this.init(name, type, PropertyArity.SCALAR, value);
    }

    public Property(String name, PropertyType type, PropertyArity arity, Object value) {
        this.init(name, type, arity, value);
    }

    private void init(String name, PropertyType type, PropertyArity arity, Object value) {
        if (value == null) {
            throw new NullPointerException("Null value for Property not permitted");
        }
        if (arity == PropertyArity.SCALAR) {
            if (value instanceof List || value instanceof Map || value instanceof Set) {
                throw new IncompatibleClassChangeError("Wrong class for Scalar Property");
            }
        } else if (arity == PropertyArity.MAP) {
            if (!(value instanceof Map)) {
                throw new IncompatibleClassChangeError("Wrong class for Map Property");
            }
        } else if (arity == PropertyArity.SET) {
            if (!(value instanceof Set)) {
                throw new IncompatibleClassChangeError("Wrong class for Set Property");
            }
        } else if (arity == PropertyArity.LIST && !(value instanceof List)) {
            throw new IncompatibleClassChangeError("Wrong class for List Property");
        }
        this._name = name;
        this._type = type;
        this._arity = arity;
        this._value = value;
    }

    public PropertyArity getArity() {
        return this._arity;
    }

    public Property getByName(String name) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (this._name.equals(name)) {
                            return this;
                        }
                        if (this._arity.equals(PropertyArity.SCALAR) || !this._type.equals(PropertyType.PROPERTY)) break block5;
                        if (!this._arity.equals(PropertyArity.ARRAY)) break block6;
                        Property[] array = (Property[])this._value;
                        for (int i = 0; i < array.length; ++i) {
                            Property prop = array[i].getByName(name);
                            if (prop == null) continue;
                            return prop;
                        }
                        break block5;
                    }
                    if (!this._arity.equals(PropertyArity.LIST)) break block7;
                    List list = (List)this._value;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        Property prop = ((Property)list.get(i)).getByName(name);
                        if (prop == null) continue;
                        return prop;
                    }
                    break block5;
                }
                if (!this._arity.equals(PropertyArity.MAP)) break block8;
                Collection coll = ((Map)this._value).values();
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Property prop = ((Property)iter.next()).getByName(name);
                    if (prop == null) continue;
                    return prop;
                }
                break block5;
            }
            if (!this._arity.equals(PropertyArity.SET)) break block5;
            Iterator iter = ((Set)this._value).iterator();
            while (iter.hasNext()) {
                Property prop = ((Property)iter.next()).getByName(name);
                if (prop == null) continue;
                return prop;
            }
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public PropertyType getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }
}

