/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.module.Utf8BlockMarker;
import edu.harvard.hul.ois.jhove.module.html.DTDMapper;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.xml.ProcessingInstructionInfo;
import edu.harvard.hul.ois.jhove.module.xml.SchemaInfo;
import edu.harvard.hul.ois.jhove.module.xml.XmlDeclHandler;
import edu.harvard.hul.ois.jhove.module.xml.XmlDeclStream;
import edu.harvard.hul.ois.jhove.module.xml.XmlLexicalHandler;
import edu.harvard.hul.ois.jhove.module.xml.XmlModuleHandler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlModule
extends ModuleBase {
    private static final String NAME = "XML-hul";
    private static final String RELEASE = "1.4";
    private static final int[] DATE = new int[]{2007, 1, 8};
    private static final String[] FORMAT = new String[]{"XML", "XHTML"};
    private static final String COVERAGE = "XML 1.0";
    private static final String[] MIMETYPE = new String[]{"text/xml", "application/xml", "text/html"};
    private static final String WELLFORMED = "An XML file is well-formed if it meets the criteria defined in Section 2.1 of the XML specification (W3C Recommendation, 3rd edition, 2004-02-04)";
    private static final String VALIDITY = "An XML file is valid if well-formed, and the file has an associated DTD or XML Schema and the file meets the constraints defined by that DTD or Schema";
    private static final String REPINFO = "Additional representation information includes: version, endcoding, standalone flag, DTD or schema, namespaces, notations, character references, entities, processing instructions, and comments";
    private static final String NOTE = "This module determines well-formedness and validity using the SAX2-conforming parser specified by the invoking application";
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected List<Property> _propList;
    protected Property _metadata;
    protected String _xhtmlDoctype;
    protected String _baseURL;
    protected boolean _sigWantsDecl;
    protected boolean _parseFromSig;
    protected boolean _withTextMD = false;
    protected TextMDMetadata _textMD;
    protected Map<String, File> _localSchemas;

    public XmlModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("Extensible Markup Language (XML) 1.0 (Third Edition)", DocumentType.REPORT);
        doc.setPublisher(Agent.newW3CInstance());
        doc.setDate("2004-02-04");
        doc.setIdentifier(new Identifier("http://www.w3.org/TR/REC-xml", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("SAX", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://sax.sourceforge.net/", IdentifierType.URL));
        this._specification.add(doc);
        ExternalSignature sig = new ExternalSignature(".xml", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        this._localSchemas = new HashMap<String, File>();
    }

    public void setXhtmlDoctype(String doctype) {
        this._xhtmlDoctype = doctype;
        if (this._textMD != null) {
            this._textMD.setMarkup_language(this._xhtmlDoctype);
        }
    }

    @Override
    public void resetParams() throws Exception {
        this._baseURL = null;
        this._sigWantsDecl = false;
        this._parseFromSig = false;
    }

    @Override
    public void param(String param) {
        if (param != null) {
            if ((param = param.toLowerCase()).startsWith("schema=")) {
                this.addLocalSchema(param);
            } else if (param.indexOf(115) == 0) {
                this._sigWantsDecl = true;
                param = param.substring(1);
            } else if (param.indexOf(98) == 0) {
                this._baseURL = param.substring(1);
            }
        }
    }

    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        List<String> comm;
        List<String[]> notations;
        ArrayList<Property> subPropList;
        String name;
        String[] entarr;
        ListIterator<String[]> iter;
        List<String[]> declEnts;
        List<Integer> refs;
        if (this._defaultParams != null) {
            this._withTextMD = false;
            for (String param : this._defaultParams) {
                if (!"withtextmd=true".equalsIgnoreCase(param)) continue;
                this._withTextMD = true;
            }
        }
        boolean canValidate = true;
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        if (this._textMD == null || parseIndex == 0) {
            this._textMD = new TextMDMetadata();
            this._xhtmlDoctype = null;
        }
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            this._ckSummer = new Checksummer();
        }
        this._cstream = new ChecksumInputStream(stream, this._ckSummer);
        this._propList = new LinkedList<Property>();
        this._metadata = new Property("XMLMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        XMLReader parser = null;
        InputSource src = null;
        XmlModuleHandler handler = null;
        XmlLexicalHandler lexHandler = new XmlLexicalHandler();
        XmlDeclHandler declHandler = new XmlDeclHandler();
        XmlDeclStream xds = new XmlDeclStream(this._cstream);
        try {
            String saxClass;
            src = new InputSource(xds);
            if (this._baseURL != null) {
                src.setSystemId(new File(this._baseURL).toURI().toURL().toString());
            }
            if ((saxClass = this._je.getSaxClass()) == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                parser = factory.newSAXParser().getXMLReader();
            } else {
                parser = XMLReaderFactory.createXMLReader(saxClass);
            }
            handler = new XmlModuleHandler();
            handler.setXhtmlFlag(this._xhtmlDoctype != null);
            handler.setLocalSchemas(this._localSchemas);
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.setEntityResolver(handler);
            parser.setDTDHandler(handler);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", lexHandler);
            }
            catch (SAXException e) {
                info.setMessage(new InfoMessage("The XML implementation in use does not support the LexicalHandler interface. This may result in some properties not being reported."));
            }
            try {
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", declHandler);
            }
            catch (SAXException e) {
                info.setMessage(new InfoMessage("The XML implementation in use does not support the DeclHandler interface. This may result in some properties not being reported."));
            }
        }
        catch (Exception f) {
            info.setMessage(new ErrorMessage(f.getMessage()));
            info.setWellFormed(false);
            return 0;
        }
        try {
            parser.setFeature("http://xml.org/sax/features/validation", parseIndex != 0);
        }
        catch (SAXException se) {
            if (parseIndex != 0) {
                info.setMessage(new InfoMessage("The SAX parser is not capable of validation."));
            }
            canValidate = false;
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXException se) {
            info.setMessage(new InfoMessage("The SAX parser does not support namespaces."));
        }
        if (parseIndex > 0) {
            try {
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXException ee) {
                try {
                    parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                catch (SAXException e) {
                    info.setMessage(new InfoMessage("The XML implementation in use does not support schema language identification.  This may result in documents specified by schemas being reported as invalid."));
                }
            }
        }
        try {
            parser.parse(src);
        }
        catch (FileNotFoundException ef) {
            info.setMessage(new ErrorMessage("File not found", ef.getMessage().toString()));
            info.setWellFormed(false);
            return 0;
        }
        catch (UTFDataFormatException u) {
            if (handler.getSigFlag() && !this._parseFromSig) {
                info.setSigMatch(this._name);
            }
            info.setMessage(new ErrorMessage("Invalid character encoding"));
            info.setWellFormed(false);
            return 0;
        }
        catch (IOException e) {
            if (handler.getSigFlag() && !this._parseFromSig) {
                info.setSigMatch(this._name);
            }
            info.setMessage(new ErrorMessage(e.getClass().getName() + ": " + e.getMessage().toString()));
            info.setWellFormed(false);
            return 0;
        }
        catch (SAXParseException e) {
            if (handler.getSigFlag() && !this._parseFromSig) {
                info.setSigMatch(this._name);
            }
            int line = e.getLineNumber();
            int col = e.getColumnNumber();
            info.setMessage(new ErrorMessage(e.getMessage().toString(), "Line = " + line + ", Column = " + col));
            info.setWellFormed(false);
            return 0;
        }
        catch (SAXException e) {
            String msg;
            if (handler.getSigFlag()) {
                info.setSigMatch(this._name);
            }
            if ((msg = e.getMessage()) == null) {
                Throwable ee = e.getCause();
                msg = ee != null ? "SAXException, cause = " + ee.getClass().getName() : "Unspecified SAXException";
            }
            info.setMessage(new ErrorMessage(msg));
            info.setWellFormed(false);
            return 0;
        }
        if (this._je.getAbort()) {
            return 0;
        }
        if (handler.getSigFlag() && parseIndex == 0) {
            info.setSigMatch(this._name);
        }
        String dtdURI = handler.getDTDURI();
        List<SchemaInfo> schemaList = handler.getSchemas();
        if (!schemaList.isEmpty()) {
            SchemaInfo schItems = schemaList.get(0);
            if (XmlModule.isNotEmpty(schItems.namespaceURI)) {
                this._textMD.setMarkup_language(schItems.namespaceURI);
            } else if (XmlModule.isNotEmpty(schItems.location)) {
                this._textMD.setMarkup_language(schItems.location);
            }
        } else if (XmlModule.isNotEmpty(dtdURI)) {
            this._textMD.setMarkup_language(dtdURI);
        }
        if (parseIndex == 0) {
            if ((handler.getDTDURI() != null || !schemaList.isEmpty()) && canValidate) {
                return 1;
            }
            info.setValid(-1);
        }
        info.setProperty(this._metadata);
        HtmlMetadata hMetadata = handler.getHtmlMetadata();
        if (hMetadata != null) {
            info.setProperty(hMetadata.toProperty(this._withTextMD ? this._textMD : null));
        }
        this._propList.add(new Property("Parser", PropertyType.STRING, parser.getClass().getName()));
        String vers = null;
        if (this._xhtmlDoctype != null) {
            vers = DTDMapper.getXHTMLVersion(this._xhtmlDoctype);
            this._textMD.setMarkup_language_version(vers);
        }
        if (vers != null) {
            info.setVersion(vers);
        } else {
            vers = xds.getVersion();
            if (vers != null) {
                info.setVersion(vers);
            }
        }
        this._textMD.setMarkup_basis_version(vers);
        String encoding = xds.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this._propList.add(new Property("Encoding", PropertyType.STRING, encoding));
        this._textMD.setCharset(encoding);
        String textMDEncoding = this._textMD.getCharset();
        if (textMDEncoding.indexOf("UTF") != -1) {
            this._textMD.setByte_order(this._bigEndian ? 0 : 1);
            this._textMD.setByte_size("8");
            this._textMD.setCharacter_size("variable");
        } else {
            this._textMD.setByte_order(this._bigEndian ? 0 : 1);
            this._textMD.setByte_size("8");
            this._textMD.setCharacter_size("1");
        }
        String lineEnd = xds.getKindOfLineEnd();
        if (lineEnd == null) {
            info.setMessage(new InfoMessage("Not able to determine type of end of line"));
            this._textMD.setLinebreak(-1);
        } else if ("CR".equalsIgnoreCase(lineEnd)) {
            this._textMD.setLinebreak(0);
        } else if ("LF".equalsIgnoreCase(lineEnd)) {
            this._textMD.setLinebreak(1);
        } else if ("CRLF".equalsIgnoreCase(lineEnd)) {
            this._textMD.setLinebreak(2);
        }
        String sa = xds.getStandalone();
        if (sa != null) {
            this._propList.add(new Property("Standalone", PropertyType.STRING, sa));
        }
        if (dtdURI != null) {
            this._propList.add(new Property("DTD_URI", PropertyType.STRING, dtdURI));
        }
        if (!schemaList.isEmpty()) {
            ArrayList<Property> schemaPropList = new ArrayList<Property>(schemaList.size());
            ListIterator<SchemaInfo> iter2 = schemaList.listIterator();
            while (iter2.hasNext()) {
                SchemaInfo schItems = iter2.next();
                Property[] schItemProps = new Property[]{new Property("NamespaceURI", PropertyType.STRING, schItems.namespaceURI), new Property("SchemaLocation", PropertyType.STRING, schItems.location)};
                schemaPropList.add(new Property("Schema", PropertyType.PROPERTY, PropertyArity.ARRAY, schItemProps));
            }
            Property prop = new Property("Schemas", PropertyType.PROPERTY, PropertyArity.LIST, schemaPropList);
            this._propList.add(prop);
        }
        String root = handler.getRoot();
        String rootPrefix = null;
        if (root != null) {
            int indexOfColon;
            this._propList.add(new Property("Root", PropertyType.STRING, root));
            if ("html".equals(root)) {
                info.setFormat(this._format[1]);
            }
            if ((indexOfColon = root.indexOf(58)) != -1) {
                rootPrefix = root.substring(0, indexOfColon);
            }
        }
        if (rootPrefix == null) {
            rootPrefix = "";
        }
        Property namespaceProp = null;
        Property notationsProp = null;
        Property charRefsProp = null;
        Property entitiesProp = null;
        Property procInstProp = null;
        Property commentProp = null;
        Property unicodeBlocksProp = null;
        Map<String, String> ns = handler.getNamespaces();
        if (!ns.isEmpty()) {
            Set<String> keys = ns.keySet();
            ArrayList<Property> nsList = new ArrayList<Property>(keys.size());
            for (String key : keys) {
                String val = ns.get(key);
                Property[] supPropArr = new Property[]{new Property("Prefix", PropertyType.STRING, key), new Property("URI", PropertyType.STRING, val)};
                Property onens = new Property("Namespace", PropertyType.PROPERTY, PropertyArity.ARRAY, supPropArr);
                nsList.add(onens);
                if (!rootPrefix.equalsIgnoreCase(key) || !XmlModule.isNotEmpty(val)) continue;
                this._textMD.setMarkup_language(val);
            }
            namespaceProp = new Property("Namespaces", PropertyType.PROPERTY, PropertyArity.LIST, nsList);
        }
        if (!(refs = xds.getCharacterReferences()).isEmpty()) {
            Utf8BlockMarker utf8BM = new Utf8BlockMarker();
            ArrayList<String> refList = new ArrayList<String>(refs.size());
            ListIterator<Integer> iter3 = refs.listIterator();
            while (iter3.hasNext()) {
                Integer refi = iter3.next();
                int refint = refi;
                refList.add(XmlModule.intTo4DigitHex(refint));
                utf8BM.markBlock(refint);
            }
            charRefsProp = new Property("CharacterReferences", PropertyType.STRING, PropertyArity.LIST, refList);
            unicodeBlocksProp = utf8BM.getBlocksUsedProperty("UnicodeCharRefBlocks");
        }
        Set<String> entNames = lexHandler.getEntityNames();
        Set<String> attributeVals = handler.getAttributeValues();
        LinkedList<Property> entProps = new LinkedList<Property>();
        List<String[]> uent = handler.getUnparsedEntities();
        LinkedList<String> unparsedNotationNames = new LinkedList<String>();
        if (!uent.isEmpty()) {
            ListIterator<String[]> iter4 = uent.listIterator();
            while (iter4.hasNext()) {
                String[] entarr2 = iter4.next();
                String name2 = entarr2[0];
                if (!XmlModule.nameInCollection(name2, attributeVals)) continue;
                unparsedNotationNames.add(entarr2[3]);
                ArrayList<Property> subPropList2 = new ArrayList<Property>(6);
                subPropList2.add(new Property("Name", PropertyType.STRING, name2));
                subPropList2.add(new Property("Type", PropertyType.STRING, "External unparsed"));
                subPropList2.add(new Property("PublicID", PropertyType.STRING, entarr2[1]));
                subPropList2.add(new Property("SystemID", PropertyType.STRING, entarr2[2]));
                subPropList2.add(new Property("NotationName", PropertyType.STRING, entarr2[3]));
                entProps.add(new Property("Entity", PropertyType.PROPERTY, PropertyArity.LIST, subPropList2));
            }
        }
        if (!(declEnts = declHandler.getInternalEntityDeclarations()).isEmpty()) {
            iter = declEnts.listIterator();
            while (iter.hasNext()) {
                entarr = iter.next();
                name = entarr[0];
                if (!XmlModule.nameInCollection(name, entNames)) continue;
                subPropList = new ArrayList<Property>(4);
                subPropList.add(new Property("Name", PropertyType.STRING, name));
                subPropList.add(new Property("Type", PropertyType.STRING, "Internal"));
                subPropList.add(new Property("Value", PropertyType.STRING, entarr[1]));
                entProps.add(new Property("Entity", PropertyType.PROPERTY, PropertyArity.LIST, subPropList));
            }
        }
        if (!(declEnts = declHandler.getExternalEntityDeclarations()).isEmpty()) {
            iter = declEnts.listIterator();
            while (iter.hasNext()) {
                entarr = iter.next();
                name = entarr[0];
                if (!XmlModule.nameInCollection(name, entNames)) continue;
                subPropList = new ArrayList(4);
                subPropList.add(new Property("Name", PropertyType.STRING, name));
                subPropList.add(new Property("Type", PropertyType.STRING, "External parsed"));
                if (entarr[1] != null) {
                    subPropList.add(new Property("PublicID", PropertyType.STRING, entarr[1]));
                }
                if (entarr[2] != null) {
                    subPropList.add(new Property("SystemID", PropertyType.STRING, entarr[2]));
                }
                entProps.add(new Property("Entity", PropertyType.PROPERTY, PropertyArity.LIST, subPropList));
            }
        }
        if (!entProps.isEmpty()) {
            entitiesProp = new Property("Entities", PropertyType.PROPERTY, PropertyArity.LIST, entProps);
        }
        List<ProcessingInstructionInfo> pi = handler.getProcessingInstructions();
        LinkedList<String> piTargets = new LinkedList<String>();
        if (!pi.isEmpty()) {
            ArrayList<Property> piPropList = new ArrayList<Property>(pi.size());
            ListIterator<ProcessingInstructionInfo> pii = pi.listIterator();
            while (pii.hasNext()) {
                ProcessingInstructionInfo pistr = pii.next();
                Property[] subPropArr = new Property[]{new Property("Target", PropertyType.STRING, pistr.target), new Property("Data", PropertyType.STRING, pistr.data)};
                piPropList.add(new Property("ProcessingInstruction", PropertyType.PROPERTY, PropertyArity.ARRAY, subPropArr));
            }
            procInstProp = new Property("ProcessingInstructions", PropertyType.PROPERTY, PropertyArity.LIST, piPropList);
        }
        if (!(notations = handler.getNotations()).isEmpty()) {
            ArrayList<Property> notProps = new ArrayList<Property>(notations.size());
            ListIterator<String[]> iter5 = notations.listIterator();
            ArrayList<Property> subPropList3 = new ArrayList<Property>(3);
            while (iter5.hasNext()) {
                String[] notArray = iter5.next();
                String notName = notArray[0];
                if (!XmlModule.nameInCollection(notName, piTargets) && !XmlModule.nameInCollection(notName, unparsedNotationNames)) continue;
                subPropList3.add(new Property("Name", PropertyType.STRING, notName));
                if (notArray[1] != null) {
                    subPropList3.add(new Property("PublicID", PropertyType.STRING, notArray[1]));
                }
                if (notArray[2] != null) {
                    subPropList3.add(new Property("SystemID", PropertyType.STRING, notArray[2]));
                }
                notProps.add(new Property("Notation", PropertyType.PROPERTY, PropertyArity.LIST, subPropList3));
            }
            if (!notProps.isEmpty()) {
                notationsProp = new Property("Notations", PropertyType.PROPERTY, PropertyArity.LIST, notProps);
            }
        }
        if (namespaceProp != null) {
            this._propList.add(namespaceProp);
        }
        if (notationsProp != null) {
            this._propList.add(notationsProp);
        }
        if (charRefsProp != null) {
            this._propList.add(charRefsProp);
        }
        if (unicodeBlocksProp != null) {
            this._propList.add(unicodeBlocksProp);
        }
        if (entitiesProp != null) {
            this._propList.add(entitiesProp);
        }
        if (procInstProp != null) {
            this._propList.add(procInstProp);
        }
        if (!(comm = lexHandler.getComments()).isEmpty()) {
            commentProp = new Property("Comments", PropertyType.STRING, PropertyArity.LIST, comm);
        }
        if (commentProp != null) {
            this._propList.add(commentProp);
        }
        if (!handler.isValid()) {
            info.setValid(false);
        }
        if (info.getWellFormed() == 1) {
            if (this._xhtmlDoctype != null) {
                info.setMimeType(this._mimeType[2]);
            } else {
                info.setMimeType(this._mimeType[0]);
            }
        }
        List<Message> msgs = handler.getMessages();
        ListIterator<Message> msgi = msgs.listIterator();
        while (msgi.hasNext()) {
            info.setMessage(msgi.next());
        }
        if (this._withTextMD) {
            this._textMD.setMarkup_basis(info.getFormat());
            this._textMD.setMarkup_basis_version(info.getVersion());
            Property property = new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, this._textMD);
            this._propList.add(property);
        }
        if (this._ckSummer != null) {
            info.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = this._ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = this._ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
        if (info.getVersion() == null) {
            info.setVersion("1.0");
            this._textMD.setMarkup_basis_version("1.0");
        }
        return 0;
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        this._parseFromSig = false;
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        String sigStr = "<?xml";
        int sigidx = 0;
        JhoveBase jb = this.getBase();
        int sigBytes = jb.getSigBytes();
        DataInputStream dstream = new DataInputStream(stream);
        try {
            for (int charsRead = 0; charsRead < sigBytes; ++charsRead) {
                char ch = dstream.readChar();
                if (sigidx <= 2 && Character.isWhitespace(ch)) continue;
                if (ch != sigStr.charAt(sigidx)) break;
                if (++sigidx < sigStr.length()) continue;
                info.setSigMatch(this._name);
                return;
            }
        }
        catch (IOException e) {
            info.setWellFormed(false);
            return;
        }
        if (this._sigWantsDecl) {
            info.setWellFormed(false);
            return;
        }
        int parseIndex = 1;
        this._parseFromSig = true;
        while (parseIndex != 0) {
            stream.close();
            stream = new FileInputStream(file);
            parseIndex = this.parse(stream, info, parseIndex);
        }
        if (info.getWellFormed() == 1) {
            info.setSigMatch(this._name);
        }
    }

    @Override
    protected void initParse() {
        super.initParse();
    }

    protected static boolean nameInCollection(String name, Collection<String> coll) {
        for (String s : coll) {
            if (!name.equals(s)) continue;
            return true;
        }
        return false;
    }

    protected static String intTo4DigitHex(int n) {
        StringBuffer buf = new StringBuffer(4);
        for (int i = 3; i >= 0; --i) {
            int d = n >> 4 * i & 0xF;
            if (d < 10) {
                buf.append((char)(48 + d));
                continue;
            }
            buf.append((char)(65 + (d - 10)));
        }
        return buf.toString();
    }

    protected static boolean isNotEmpty(String value) {
        return value != null && value.length() != 0 && !"[None]".equals(value);
    }

    private void addLocalSchema(String param) {
        int eq = param.indexOf(61);
        int semi = param.indexOf(59);
        try {
            String uri = param.substring(eq + 1, semi).trim();
            String path = param.substring(semi + 1).trim();
            File f = new File(path);
            if (f.exists()) {
                this._localSchemas.put(uri, f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

