/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class CommonChunk
extends Chunk {
    public CommonChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        int numChannels = module.readUnsignedShort(this._dstream);
        long numSampleFrames = module.readUnsignedInt(this._dstream);
        int sampleSize = module.readUnsignedShort(this._dstream);
        this.bytesLeft -= 8L;
        String compressionType = null;
        String compressionName = null;
        double sampleRate = module.read80BitDouble(this._dstream);
        this.bytesLeft -= 10L;
        if (module.getFileType() == 2) {
            if (this.bytesLeft == 0L) {
                info.setMessage(new ErrorMessage("Common Chunk in AIFF-C does not have compression type", module.getNByte()));
                info.setWellFormed(false);
                return false;
            }
            compressionType = module.read4Chars(this._dstream);
            if (compressionType.equals("sowt")) {
                module.setEndian(false);
            }
            this.bytesLeft -= 4L;
            compressionName = module.readPascalString(this._dstream);
            this.bytesLeft -= (long)(compressionName.length() + 1);
        }
        AESAudioMetadata aes = module.getAESMetadata();
        aes.setBitDepth(sampleSize);
        aes.setSampleRate(sampleRate);
        aes.setNumChannels(numChannels);
        this.setChannelLocations(aes, numChannels);
        aes.setDuration(numSampleFrames);
        module.addAiffProperty(new Property("SampleFrames", PropertyType.LONG, new Long(numSampleFrames)));
        if (compressionType != null) {
            module.addAiffProperty(new Property("CompressionType", PropertyType.STRING, compressionType));
            if (!compressionType.equals("NONE")) {
                if (compressionType.equals("raw ")) {
                    aes.setAudioDataEncoding("PCM 8-bit offset-binary");
                } else if (compressionType.equals("twos")) {
                    aes.setAudioDataEncoding("PCM 16-bit twos-complement big-endian");
                } else if (compressionType.equals("sowt")) {
                    aes.setAudioDataEncoding("PCM 16-bit twos-complement little-endian");
                } else if (compressionType.equals("fl32")) {
                    aes.setAudioDataEncoding("PCM 32-bit integer");
                } else if (compressionType.equals("fl64")) {
                    aes.setAudioDataEncoding("PCM 64-bit floating point");
                } else if (compressionType.equals("in24")) {
                    aes.setAudioDataEncoding("PCM 24-bit integer");
                } else if (compressionType.equals("in32")) {
                    aes.setAudioDataEncoding("PCM 32-bit integer");
                } else {
                    aes.setAudioDataEncoding(compressionName);
                    String name = compressionName;
                    if (name == null || name.length() == 0) {
                        name = compressionType;
                    }
                    aes.setBitrateReduction(compressionName, "", "", "", "LOSSY", "UNKNOWN", "FIXED");
                }
            }
        }
        if (compressionName != null && compressionName.length() > 0) {
            module.addAiffProperty(new Property("CompressionName", PropertyType.STRING, compressionName));
        }
        return true;
    }

    private void setChannelLocations(AESAudioMetadata aes, int numChannels) {
        String[] mapLoc = new String[numChannels];
        switch (numChannels) {
            case 1: {
                mapLoc[0] = "UNKNOWN";
                break;
            }
            case 4: {
                mapLoc[3] = "SURROUND";
            }
            case 3: {
                mapLoc[2] = "CENTER";
            }
            case 2: {
                mapLoc[0] = "LEFT";
                mapLoc[1] = "RIGHT";
                break;
            }
            case 6: {
                mapLoc[0] = "LEFT";
                mapLoc[1] = "LEFT_CENTER";
                mapLoc[2] = "CENTER";
                mapLoc[3] = "RIGHT";
                mapLoc[4] = "RIGHT_CENTER";
                mapLoc[5] = "SURROUND";
                break;
            }
            default: {
                for (int i = 0; i < numChannels; ++i) {
                    mapLoc[i] = "UNKNOWN";
                }
            }
        }
        aes.setMapLocations(mapLoc);
    }
}

