/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Tiling {
    private List<long[]> tileList = new LinkedList<long[]>();
    private int _tilingType;
    private int _vertScale;
    private int _horScale;
    private long _refGridHeight;
    private long _refGridWidth;

    public void addTile(long vertScale, long horScale, long vertOffset, long horOffset) {
        long[] tile = new long[]{vertScale, horScale, vertOffset, horOffset};
        this.tileList.add(tile);
    }

    public Property buildTileListProp() {
        LinkedList<Property> tpList = new LinkedList<Property>();
        ListIterator<long[]> iter = this.tileList.listIterator();
        while (iter.hasNext()) {
            long[] tile = iter.next();
            Property[] tProp = new Property[]{new Property("VerticalScale", PropertyType.LONG, new Long(tile[0])), new Property("HorizontalScale", PropertyType.LONG, new Long(tile[1])), new Property("VerticalOffsret", PropertyType.LONG, new Long(tile[2])), new Property("HorizontalOffset", PropertyType.LONG, new Long(tile[3]))};
            tpList.add(new Property("Tile", PropertyType.PROPERTY, PropertyArity.ARRAY, tProp));
        }
        return new Property("Tiles", PropertyType.PROPERTY, PropertyArity.LIST, tpList);
    }

    public void setTilingType(int tilingType) {
        this._tilingType = tilingType;
    }

    public void setVertScale(int vertScale) {
        this._vertScale = vertScale;
    }

    public void setHorScale(int horScale) {
        this._horScale = horScale;
    }

    public void setRefGridHeight(long refGridHeight) {
        this._refGridHeight = refGridHeight;
    }

    public void setRefGridWidth(long refGridWidth) {
        this._refGridWidth = refGridWidth;
    }

    public int getTilingType() {
        return this._tilingType;
    }

    public int getVertScale() {
        return this._vertScale;
    }

    public int getHorScale() {
        return this._horScale;
    }

    public long getRefGridHeight() {
        return this._refGridHeight;
    }

    public long getRefGridWidth() {
        return this._refGridWidth;
    }
}

