/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ImageHeaderBox
extends JP2Box {
    public ImageHeaderBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        int unk;
        int compression;
        NisoImageMetadata niso;
        if (!(this._parentBox instanceof JP2HeaderBox)) {
            this._repInfo.setMessage(new ErrorMessage("ImageHeader Box in illegal context", this._module.getFilePos()));
            return false;
        }
        this.initBytesRead();
        if (this._boxHeader.getLength() != 22L) {
            this._repInfo.setMessage(new ErrorMessage("Image Header Box is incorrect size", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        if (this._parentBox instanceof CodestreamHeaderBox) {
            Codestream cs = ((CodestreamHeaderBox)this._parentBox).getCodestream();
            niso = cs.getNiso();
        } else {
            niso = this._module.getDefaultNiso();
        }
        long height = this._module.readUnsignedInt(this._dstrm);
        niso.setImageLength(height);
        long width = this._module.readUnsignedInt(this._dstrm);
        niso.setImageWidth(width);
        int nc = this._module.readUnsignedShort(this._dstrm);
        if (nc == 0) {
            this._repInfo.setMessage(new ErrorMessage("ImageHeader Box haz zero components", this._module.getFilePos()));
            return false;
        }
        niso.setSamplesPerPixel(nc);
        int bpc = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        if (bpc != 255) {
            int[] bits = new int[nc];
            int bps = (bpc & 0x7F) + 1;
            for (int i = 0; i < nc; ++i) {
                bits[i] = bps;
            }
            niso.setBitsPerSample(bits);
        }
        if ((compression = ModuleBase.readUnsignedByte(this._dstrm, this._module)) == 7) {
            niso.setCompressionScheme(34712);
        }
        this._module.addProperty(new Property("ColorspaceUnknown", PropertyType.BOOLEAN, new Boolean((unk = ModuleBase.readUnsignedByte(this._dstrm, this._module)) != 0)));
        int ipr = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        this.finalizeBytesRead();
        this._module.setImageHeaderSeen(true);
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Image Header Box";
    }
}

