/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;

public class QCDMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int[] spqcd;
        int sqcd = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int sqcdLow = sqcd & 0x1F;
        switch (sqcdLow) {
            case 0: {
                int i;
                int nspqcd = bytesToEat - 1;
                spqcd = new int[nspqcd];
                for (i = 0; i < nspqcd; ++i) {
                    spqcd[i] = ModuleBase.readUnsignedByte(this._dstream, this._module);
                }
                break;
            }
            case 1: 
            case 2: {
                int i;
                int nspqcd = (bytesToEat - 1) / 2;
                spqcd = new int[nspqcd];
                for (i = 0; i < nspqcd; ++i) {
                    spqcd[i] = this._module.readUnsignedShort(this._dstream);
                }
                break;
            }
            default: {
                this._repInfo.setMessage(new ErrorMessage("Unrecognized quantization type in QCD marker segment"));
                return false;
            }
        }
        ArrayList<Property> propList = new ArrayList<Property>(2);
        propList.add(new Property("QuantizationStyle", PropertyType.INTEGER, new Integer(sqcd)));
        propList.add(new Property("StepValue", PropertyType.INTEGER, PropertyArity.ARRAY, spqcd));
        MainOrTile cs = this.getMainOrTile();
        cs.setQCDProperty(new Property("QuantizationDefault", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }
}

