/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ReaderRequirementsBox
extends JP2Box {
    public ReaderRequirementsBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        String badRR = "Invalid data in Reader Requirements box";
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        int maskLength = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        switch (maskLength) {
            case 1: {
                long fuam = ModuleBase.readUnsignedByte(this._dstrm, this._module);
                long dcm = ModuleBase.readUnsignedByte(this._dstrm, this._module);
                break;
            }
            case 2: {
                long fuam = this._module.readUnsignedShort(this._dstrm);
                long dcm = this._module.readUnsignedShort(this._dstrm);
                break;
            }
            case 4: {
                long fuam = this._module.readUnsignedInt(this._dstrm);
                long dcm = this._module.readUnsignedInt(this._dstrm);
                break;
            }
            case 8: {
                long fuam = this._module.readSignedLong(this._dstrm);
                long dcm = this._module.readSignedLong(this._dstrm);
                break;
            }
            default: {
                this._repInfo.setMessage(new ErrorMessage("Invalid data in Reader Requirements box", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        }
        int nsf = this._module.readUnsignedShort(this._dstrm);
        for (int i = 0; i < nsf; ++i) {
            int n = this._module.readUnsignedShort(this._dstrm);
        }
        this._module.skipBytes(this._dstrm, (int)((long)len - (this._module.getFilePos() - this.startBytesRead)), this._module);
        this.finalizeBytesRead();
        this._module.setRReqSeen(true);
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Reader Requirements Box";
    }
}

