/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.util.Vector;

public abstract class XProfileBase
extends PdfProfile {
    public static int PDFX1 = 1;
    public static int PDFX1A = 2;
    public static int PDFX2 = 3;
    public static int PDFX3 = 4;
    protected int _xType;
    protected boolean _bleedBoxPresent = false;

    public XProfileBase(PdfModule module, int xType) {
        super(module);
        this._xType = xType;
    }

    protected boolean infoDictOK(String xVersion) {
        PdfDictionary docInfo = this._module.getDocInfo();
        try {
            PdfSimpleObject trapped = (PdfSimpleObject)docInfo.get("Trapped");
            PdfSimpleObject xvers = (PdfSimpleObject)docInfo.get("GTS_PDFXVersion");
            if (docInfo.get("CreationDate") == null || xvers == null || docInfo.get("ModDate") == null || docInfo.get("Title") == null || trapped == null) {
                return false;
            }
            String trappedVal = trapped.getStringValue();
            if (!"True".equals(trappedVal) && !"False".equals(trappedVal)) {
                return false;
            }
            String vers = xvers.getStringValue();
            if (!vers.startsWith(xVersion)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean isBleedBoxPresent() {
        return this._bleedBoxPresent;
    }

    protected boolean outputIntentsOK(PdfArray intents) {
        Vector<PdfObject> intVec = intents.getContent();
        int matchCount = 0;
        try {
            for (int i = 0; i < intVec.size(); ++i) {
                String subtype;
                PdfDictionary intent = (PdfDictionary)this._module.resolveIndirectObject(intVec.elementAt(i));
                PdfSimpleObject sval = (PdfSimpleObject)this._module.resolveIndirectObject(intent.get("S"));
                if (sval == null || !"GTS_PDFX".equals(subtype = sval.getStringValue())) continue;
                ++matchCount;
                PdfSimpleObject outcond = (PdfSimpleObject)this._module.resolveIndirectObject(intent.get("OutputConditionIdentifier"));
                if (outcond == null) {
                    return false;
                }
                if (this._xType != PDFX1) continue;
                PdfSimpleObject regName = (PdfSimpleObject)this._module.resolveIndirectObject(intent.get("RegistryName"));
                PdfStream dop = (PdfStream)this._module.resolveIndirectObject(intent.get("DestOutputProfile"));
                if (regName != null || dop != null) continue;
                return false;
            }
            return matchCount == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean trailerDictOK() {
        PdfDictionary trailerDict = this._module.getTrailerDict();
        if (trailerDict == null) {
            return false;
        }
        return trailerDict.get("ID") != null;
    }

    protected boolean extGStateOK(PdfDictionary gs) {
        if (gs == null) {
            return true;
        }
        try {
            PdfDictionary htd;
            PdfSimpleObject htType;
            int htTypeVal;
            PdfObject tr = gs.get("TR");
            PdfObject tr2 = gs.get("TR2");
            PdfObject htp = gs.get("HTP");
            if (tr != null || tr2 != null || htp != null) {
                return false;
            }
            PdfObject ht = gs.get("HT");
            if (ht instanceof PdfDictionary && (htTypeVal = (htType = (PdfSimpleObject)(htd = (PdfDictionary)ht).get("HalftoneType")).getIntValue()) != 1 && htTypeVal != 5) {
                return false;
            }
            if (gs.get("HalftoneName") != null) {
                return false;
            }
            if (this._xType == PDFX1A || this._xType == PDFX2) {
                double caVal;
                String bmVal;
                PdfSimpleObject smask = (PdfSimpleObject)gs.get("SMask");
                if (smask != null && !"None".equals(smask.getStringValue())) {
                    return false;
                }
                PdfSimpleObject blendMode = (PdfSimpleObject)gs.get("BM");
                if (blendMode != null && !"Normal".equals(bmVal = blendMode.getStringValue()) && !"Compatible".equals(bmVal)) {
                    return false;
                }
                PdfSimpleObject ca = (PdfSimpleObject)gs.get("CA");
                if (ca != null && (caVal = ca.getDoubleValue()) != 1.0) {
                    return false;
                }
                ca = (PdfSimpleObject)gs.get("ca");
                if (ca != null && (caVal = ca.getDoubleValue()) != 1.0) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean xObjectOK(PdfDictionary xo) {
        if (xo == null) {
            return true;
        }
        try {
            PdfSimpleObject subtype = (PdfSimpleObject)xo.get("Subtype");
            if (subtype != null) {
                String subtypeVal = subtype.getStringValue();
                if ("PS".equals(subtypeVal)) {
                    return false;
                }
                if ("Image".equals(subtypeVal) && !this.imageObjectOK(xo)) {
                    return false;
                }
                if ("Form".equals(subtypeVal) && !this.formObjectOK(xo)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean imageObjectOK(PdfDictionary xo) {
        try {
            PdfSimpleObject smask;
            PdfArray alternates = (PdfArray)xo.get("Alternates");
            if (alternates == null) {
                return true;
            }
            Vector<PdfObject> altVec = alternates.getContent();
            for (int i = 0; i < altVec.size(); ++i) {
                PdfDictionary alt = (PdfDictionary)altVec.elementAt(i);
                PdfSimpleObject dfp = (PdfSimpleObject)alt.get("DefaultForPrinting");
                if (!dfp.isTrue()) continue;
                return false;
            }
            if (this._xType == PDFX2 && xo.get("OPI") != null) {
                return false;
            }
            if (!(this._xType != PDFX1A && this._xType != PDFX2 || (smask = (PdfSimpleObject)xo.get("SMask")) == null || "None".equals(smask.getStringValue()))) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean formObjectOK(PdfDictionary fo) {
        return true;
    }

    protected boolean bboxOK(boolean requireMediaBox) {
        PageTreeNode pgtree = this._module.getDocumentTree();
        try {
            PageObject pageObject;
            pgtree.startWalk();
            while ((pageObject = pgtree.nextPageObject()) != null) {
                PdfArray mbox;
                if (requireMediaBox && (mbox = pageObject.getMediaBox()) == null) {
                    return false;
                }
                PdfArray tbox = pageObject.getTrimBox();
                PdfArray abox = pageObject.getArtBox();
                if (tbox == null && abox == null) {
                    return false;
                }
                if (tbox != null && abox != null) {
                    return false;
                }
                if (pageObject.getBleedBox() == null) continue;
                this._bleedBoxPresent = true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean checkPrefsAgainstBleedBox() {
        if (!this._bleedBoxPresent) {
            return true;
        }
        PdfDictionary viewPrefDict = this._module.getViewPrefDict();
        if (viewPrefDict == null) {
            return true;
        }
        try {
            PdfSimpleObject[] areas = new PdfSimpleObject[]{(PdfSimpleObject)viewPrefDict.get("ViewArea"), (PdfSimpleObject)viewPrefDict.get("ViewClip"), (PdfSimpleObject)viewPrefDict.get("PrintArea")};
            for (int i = 0; i < 3; ++i) {
                String s;
                if (areas[i] == null || "MediaBox".equals(s = areas[i].getStringValue()) || "BleedBox".equals(s)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean filterOK(PdfObject filters, boolean forbidLZW, boolean forbidJBIG2) {
        try {
            if (filters == null) {
                return true;
            }
            if (filters instanceof PdfSimpleObject) {
                String filterName = ((PdfSimpleObject)filters).getStringValue();
                if ("LZWDecode".equals(filterName)) {
                    return false;
                }
            } else {
                Vector<PdfObject> filterVec = ((PdfArray)filters).getContent();
                for (int i = 0; i < filterVec.size(); ++i) {
                    PdfSimpleObject filter = (PdfSimpleObject)filterVec.elementAt(i);
                    String filterName = filter.getStringValue();
                    if (forbidLZW && "LZWDecode".equals(filterName)) {
                        return false;
                    }
                    if (!forbidJBIG2 || !"JBIG2Decode".equals(filterName)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

