/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.xml;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.html.DTDMapper;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.xml.EntityInfo;
import edu.harvard.hul.ois.jhove.module.xml.ProcessingInstructionInfo;
import edu.harvard.hul.ois.jhove.module.xml.SchemaInfo;
import edu.harvard.hul.ois.jhove.module.xml.XhtmlProcessing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleHandler
extends DefaultHandler {
    private List<EntityInfo> _entities = new LinkedList<EntityInfo>();
    private Map<String, String> _namespaces = new HashMap<String, String>();
    private List<ProcessingInstructionInfo> _processingInsts = new LinkedList<ProcessingInstructionInfo>();
    private List<Message> _messages = new LinkedList<Message>();
    private boolean _valid = true;
    private String _root = null;
    private String _dtdURI = null;
    private List<SchemaInfo> _schemas;
    private List<String[]> _unparsedEntities;
    private int _nErrors = 0;
    private List<String[]> _notations;
    private Set<String> _attributeVals = new HashSet<String>();
    private static final int MAXERRORS = 2000;
    private boolean _xhtmlFlag = false;
    private HtmlMetadata _htmlMetadata = null;
    private boolean _sigFlag = false;
    private Map<String, File> _localSchemas;

    public XmlModuleHandler() {
        this._schemas = new LinkedList<SchemaInfo>();
        this._unparsedEntities = new LinkedList<String[]>();
        this._notations = new LinkedList<String[]>();
    }

    public void setXhtmlFlag(boolean flag) {
        this._xhtmlFlag = flag;
    }

    public void setLocalSchemas(Map<String, File> schemas) {
        this._localSchemas = schemas;
    }

    public HtmlMetadata getHtmlMetadata() {
        return this._htmlMetadata;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        if (this._root == null) {
            this._sigFlag = true;
            this._root = !"".equals(qualifiedName) ? qualifiedName : localName;
        }
        if (namespaceURI != null && namespaceURI.length() != 0) {
            SchemaInfo schi = new SchemaInfo();
            schi.namespaceURI = namespaceURI;
            schi.location = "";
            if (!this.hasSchemaURI(schi)) {
                this._schemas.add(schi);
            }
        }
        if (atts != null) {
            int natts = atts.getLength();
            for (int i = 0; i < natts; ++i) {
                String name = atts.getLocalName(i);
                String namespace = atts.getURI(i);
                String val = atts.getValue(i);
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
                    SchemaInfo schInfo = new SchemaInfo();
                    if ("schemaLocation".equals(name)) {
                        String[] toks = val.split("\\s", 2);
                        schInfo.namespaceURI = toks.length > 0 && toks[0] != null ? toks[0].trim() : "";
                        schInfo.location = toks.length > 1 && toks[1] != null ? toks[1].trim() : "";
                        if (!this.hasSchemaURI(schInfo)) {
                            this._schemas.add(schInfo);
                        }
                    }
                    if ("noNamespaceSchemaLocation".equals(name)) {
                        schInfo.location = "[None]";
                        schInfo.namespaceURI = val;
                        if (!this.hasSchemaURI(schInfo)) {
                            this._schemas.add(schInfo);
                        }
                    }
                }
                this._attributeVals.add(val);
            }
        }
        if (this._xhtmlFlag) {
            if (this._htmlMetadata == null) {
                this._htmlMetadata = new HtmlMetadata();
            }
            XhtmlProcessing.processElement(localName, qualifiedName, atts, this._htmlMetadata);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this._htmlMetadata != null) {
            this._htmlMetadata.finishPropUnderConstruction();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this._htmlMetadata != null && this._htmlMetadata.getPropUnderConstruction() != null) {
            this._htmlMetadata.addToPropUnderConstruction(ch, start, length);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._namespaces.put(prefix, uri);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this._sigFlag = true;
        if (data == null) {
            data = "";
        }
        ProcessingInstructionInfo pi = new ProcessingInstructionInfo();
        pi.target = target;
        pi.data = data;
        this._processingInsts.add(pi);
    }

    @Override
    public void notationDecl(String name, String publicID, String systemID) throws SAXException {
        String[] notArr = new String[]{name, publicID, systemID};
        this._notations.add(notArr);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource ent;
        File fil = this._localSchemas.get(systemId.toLowerCase());
        if (fil != null) {
            try {
                FileInputStream inStrm = new FileInputStream(fil);
                return new InputSource(inStrm);
            }
            catch (FileNotFoundException inStrm) {
                // empty catch block
            }
        }
        if (!this._xhtmlFlag && DTDMapper.isXHTMLDTD(publicId)) {
            this._xhtmlFlag = true;
        }
        if ((ent = DTDMapper.publicIDToFile(publicId)) == null) {
            try {
                ent = super.resolveEntity(publicId, systemId);
            }
            catch (SAXException ee) {
                throw ee;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        } else {
            ent.setSystemId("http://hul.harvard.edu/hul");
        }
        EntityInfo entArr = new EntityInfo();
        entArr.publicID = publicId;
        entArr.systemID = systemId;
        this._entities.add(entArr);
        if (systemId.endsWith(".dtd") && this._dtdURI == null) {
            this._dtdURI = systemId;
        }
        return ent;
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
        String[] info = new String[]{name == null ? "" : name, publicId == null ? "" : publicId, systemId == null ? "" : systemId, notationName == null ? "" : notationName};
        this._unparsedEntities.add(info);
    }

    @Override
    public void warning(SAXParseException e) {
        this._messages.add(new InfoMessage(e.getMessage()));
    }

    @Override
    public void error(SAXParseException e) {
        this._valid = false;
        if (this._nErrors == 2000) {
            this._messages.add(new InfoMessage("Error messages in excess of 2000 not reported"));
        } else if (this._nErrors < 2000) {
            int line = e.getLineNumber();
            int col = e.getColumnNumber();
            this._messages.add(new ErrorMessage(e.getMessage().toString(), "Line = " + line + ", Column = " + col));
        }
        ++this._nErrors;
    }

    public Set<String> getAttributeValues() {
        return this._attributeVals;
    }

    public List<SchemaInfo> getSchemas() {
        return this._schemas;
    }

    public List<String[]> getUnparsedEntities() {
        return this._unparsedEntities;
    }

    public Map<String, String> getNamespaces() {
        return this._namespaces;
    }

    public String getDTDURI() {
        return this._dtdURI;
    }

    public List<ProcessingInstructionInfo> getProcessingInstructions() {
        return this._processingInsts;
    }

    public List<String[]> getNotations() {
        return this._notations;
    }

    public String getRoot() {
        return this._root;
    }

    public List<Message> getMessages() {
        return this._messages;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean getSigFlag() {
        return this._sigFlag;
    }

    public boolean hasSchemaURI(SchemaInfo newinfo) {
        for (SchemaInfo schmi : this._schemas) {
            if (!newinfo.namespaceURI.equals(schmi.namespaceURI)) continue;
            if (schmi.location.isEmpty() && !newinfo.location.isEmpty()) {
                this._schemas.remove(schmi);
                return false;
            }
            return true;
        }
        return false;
    }
}

