/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;

public abstract class Signature {
    private int[] _value;
    private String _stringValue;
    private SignatureType _type;
    private SignatureUseType _use;
    private String _note;

    protected Signature(String value, SignatureType type, SignatureUseType use) {
        this(new int[value.length()], type, use);
        int len = value.length();
        this._stringValue = value;
        for (int i = 0; i < len; ++i) {
            this._value[i] = value.charAt(i);
        }
    }

    protected Signature(int[] value, SignatureType type, SignatureUseType use) {
        this._value = value;
        this._type = type;
        this._use = use;
        this._stringValue = null;
    }

    protected Signature(String value, SignatureType type, SignatureUseType use, String note) {
        this(new int[value.length()], type, use, note);
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            this._value[i] = value.charAt(i);
        }
        this._stringValue = value;
    }

    protected Signature(int[] value, SignatureType type, SignatureUseType use, String note) {
        this(value, type, use);
        this._note = note;
    }

    public SignatureType getType() {
        return this._type;
    }

    public SignatureUseType getUse() {
        return this._use;
    }

    public int[] getValue() {
        return this._value;
    }

    public String getNote() {
        return this._note;
    }

    public boolean isStringValue() {
        return this._stringValue != null;
    }

    public String getValueString() {
        return this._stringValue;
    }

    public String getValueHexString() {
        StringBuffer valBuf = new StringBuffer("0x");
        for (int i = 0; i < this._value.length; ++i) {
            int b = this._value[i];
            if (b < 16) {
                valBuf.append('0');
            }
            valBuf.append(Integer.toHexString(b));
        }
        return valBuf.toString();
    }
}

