/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RAFInputStream
extends InputStream {
    private RandomAccessFile _raf;
    private int fileBufSize;
    private byte[] fileBuf;
    private int fileBufPos;
    private int fileBufBytes;
    private long fileOffset;
    boolean eof;

    public RAFInputStream(RandomAccessFile raf) {
        this._raf = raf;
        this.fileBufSize = 65536;
        this.init();
    }

    public RAFInputStream(RandomAccessFile raf, int bufferSize) {
        this._raf = raf;
        this.fileBufSize = bufferSize <= 0 ? 65536 : bufferSize;
        this.init();
    }

    private void init() {
        this.fileBufBytes = 0;
        this.fileBufPos = 0;
        this.fileBuf = new byte[this.fileBufSize];
        try {
            this.fileOffset = this._raf.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eof = false;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.fileBufPos >= this.fileBufBytes) {
            this._raf.seek(this.fileOffset);
            this.fileBufBytes = this._raf.read(this.fileBuf);
            this.fileBufPos = 0;
            if (this.fileBufBytes <= 0) {
                this.eof = true;
                return -1;
            }
            this.fileOffset += (long)this.fileBufBytes;
        }
        return this.fileBuf[this.fileBufPos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesToRead = b.length;
        int bytesRead = 0;
        do {
            int fbAvail;
            if ((fbAvail = this.fileBufBytes - this.fileBufPos) <= 0) {
                this._raf.seek(this.fileOffset);
                this.fileBufBytes = this._raf.read(this.fileBuf);
                this.fileBufPos = 0;
                if (this.fileBufBytes <= 0) {
                    this.eof = true;
                    return bytesRead;
                }
                fbAvail = this.fileBufBytes;
                this.fileOffset += (long)this.fileBufBytes;
            }
            if (fbAvail > bytesToRead) {
                fbAvail = bytesToRead;
            }
            for (int i = 0; i < fbAvail; ++i) {
                b[bytesRead++] = this.fileBuf[this.fileBufPos++];
                --bytesToRead;
            }
        } while (bytesToRead != 0);
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesToRead = len;
        int bytesRead = 0;
        do {
            int fbAvail;
            if ((fbAvail = this.fileBufBytes - this.fileBufPos) <= 0) {
                this._raf.seek(this.fileOffset);
                this.fileBufBytes = this._raf.read(this.fileBuf);
                this.fileBufPos = 0;
                if (this.fileBufBytes <= 0) {
                    this.eof = true;
                    return bytesRead;
                }
                fbAvail = this.fileBufBytes;
                this.fileOffset += (long)this.fileBufBytes;
            }
            if (fbAvail > bytesToRead) {
                fbAvail = bytesToRead;
            }
            for (int i = 0; i < fbAvail; ++i) {
                b[off + bytesRead++] = this.fileBuf[this.fileBufPos++];
                --bytesToRead;
            }
        } while (bytesToRead != 0);
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        int bytesLeft = this.fileBufBytes - this.fileBufPos;
        if ((long)bytesLeft > n) {
            this.fileBufPos += (int)n;
        } else {
            this.fileOffset = this.fileOffset + n - (long)bytesLeft > this._raf.length() ? this._raf.length() : (this.fileOffset += n - (long)bytesLeft);
            this.fileBufBytes = 0;
        }
        return n;
    }

    public RandomAccessFile getRAF() {
        return this._raf;
    }

    public void seek(long offset) throws IOException {
        this._raf.seek(offset);
        this.fileBufBytes = 0;
        this.fileBufPos = 0;
        this.eof = false;
    }

    public long getFilePos() throws IOException {
        return this._raf.getFilePointer() - (long)(this.fileBufBytes - this.fileBufPos);
    }
}

