/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.Vector;

public class NameTreeNode {
    protected PdfModule _module;
    protected NameTreeNode _parent;
    protected PdfDictionary _dict;
    private Vector _kids;
    private Vector _names;
    private Vector _lowerLimit;
    private Vector _upperLimit;

    public NameTreeNode(PdfModule module, NameTreeNode parent, PdfDictionary dict) throws PdfException {
        String inval = "Invalid name tree";
        this._module = module;
        this._parent = parent;
        this._dict = dict;
        try {
            PdfArray limitsDict = (PdfArray)module.resolveIndirectObject(dict.get("Limits"));
            if (limitsDict == null) {
                this._lowerLimit = null;
                this._upperLimit = null;
            } else {
                Vector<PdfObject> vec = limitsDict.getContent();
                PdfSimpleObject limobj = (PdfSimpleObject)vec.elementAt(0);
                this._lowerLimit = limobj.getRawBytes();
                limobj = (PdfSimpleObject)vec.elementAt(1);
                this._upperLimit = limobj.getRawBytes();
            }
            PdfArray kidsVec = (PdfArray)module.resolveIndirectObject(dict.get("Kids"));
            this._kids = kidsVec != null ? kidsVec.getContent() : null;
            PdfArray namesVec = (PdfArray)module.resolveIndirectObject(dict.get("Names"));
            this._names = namesVec != null ? namesVec.getContent() : null;
        }
        catch (ClassCastException ce) {
            throw new PdfInvalidException("Invalid name tree");
        }
        catch (NullPointerException ce) {
            throw new PdfInvalidException("Invalid name tree");
        }
        catch (Exception e) {
            throw new PdfMalformedException("Invalid name tree");
        }
    }

    public boolean inBounds(Vector key) {
        if (this._lowerLimit == null) {
            return true;
        }
        if (this._upperLimit == null) {
            return true;
        }
        return this.compareKey(key, this._lowerLimit) >= 0 && this.compareKey(key, this._upperLimit) <= 0;
    }

    public PdfObject get(Vector key) throws PdfException {
        String invtree = "Invalid name tree";
        try {
            if (!this.inBounds(key)) {
                return null;
            }
            if (this._names != null) {
                for (int i = 0; i < this._names.size(); i += 2) {
                    PdfSimpleObject k1 = (PdfSimpleObject)this._names.elementAt(i);
                    int cmp = this.compareKey(key, k1.getRawBytes());
                    if (cmp == 0) {
                        return this._module.resolveIndirectObject((PdfObject)this._names.elementAt(i + 1));
                    }
                    if (cmp >= 0) continue;
                    return null;
                }
                return null;
            }
            if (this._kids != null) {
                for (int i = 0; i < this._kids.size(); ++i) {
                    PdfObject res;
                    PdfDictionary kid = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)this._kids.elementAt(i));
                    NameTreeNode kidnode = new NameTreeNode(this._module, this, kid);
                    if (!kidnode.inBounds(key) || (res = kidnode.get(key)) == null) continue;
                    return res;
                }
                return null;
            }
            throw new PdfMalformedException("Invalid name tree");
        }
        catch (PdfException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new PdfMalformedException("Invalid name tree");
        }
    }

    private int compareKey(Vector a, Vector b) {
        int lenb;
        int lena = a.size();
        int len = lena < (lenb = b.size()) ? lena : lenb;
        for (int i = 0; i < len; ++i) {
            int bi;
            int ai = (Integer)a.elementAt(i);
            if (ai < (bi = ((Integer)b.elementAt(i)).intValue())) {
                return -1;
            }
            if (ai <= bi) continue;
            return 1;
        }
        if (lena == lenb) {
            return 0;
        }
        if (lena < lenb) {
            return -1;
        }
        return 1;
    }

    private void dumpKey(Vector v, String label) {
        System.out.print(label);
        for (int i = 0; i < v.size(); ++i) {
            System.out.print(v.elementAt(i).toString() + " ");
        }
        System.out.println();
    }
}

