/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassF
extends TiffProfile {
    public TiffProfileClassF() {
        this._profileText = "Class F";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        long t4opt;
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getImageLength() == -1L || niso.getStripOffsets() == null || niso.getRowsPerStrip() == -1L || niso.getStripByteCounts() == null || tifd.getPageNumber() == null || niso.getScanningSoftware() == null) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{3, 4})) {
            return false;
        }
        int fo = tifd.getFillOrder();
        if (fo != 1 && fo != 2) {
            return false;
        }
        int cmpr = niso.getCompressionScheme();
        if (cmpr == 3) {
            t4opt = tifd.getT4Options();
            if (t4opt != 0L && t4opt != 1L && t4opt != 4L && t4opt != 5L) {
                return false;
            }
        } else if (cmpr == 4) {
            t4opt = tifd.getT4Options();
            long t6opt = tifd.getT6Options();
            if (t6opt != 2L) {
                return false;
            }
        }
        if (!this.satisfiesImageWidth(tifd, new int[]{1728, 2048, 2432, 2592, 3072, 3648, 3456, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesNewSubfileType(tifd, 2L)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesXResolution(tifd, new int[]{204, 200, 300, 400, 408})) {
            return false;
        }
        if (!this.satisfiesYResolution(tifd, new int[]{98, 196, 100, 200, 300, 391, 400})) {
            return false;
        }
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps[0] != 1) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 1)) {
            return false;
        }
        int wid = (int)niso.getImageWidth();
        int xres = (int)niso.getXSamplingFrequency().toLong();
        int yres = (int)niso.getYSamplingFrequency().toLong();
        switch (wid) {
            case 1728: 
            case 2048: 
            case 2432: {
                if (xres == 204 && yres == 391 && (xres != 200 || yres != 100) && (xres != 200 || yres != 200)) break;
                return false;
            }
            case 2592: 
            case 3072: 
            case 3648: {
                if (xres == 300 && yres == 300) break;
                return false;
            }
            case 3456: 
            case 4096: 
            case 4864: {
                if (xres == 408 && yres == 391 && (xres != 400 || yres != 400)) break;
                return false;
            }
        }
        return true;
    }
}

