/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.jpeg.ArithConditioning;
import edu.harvard.hul.ois.jhove.module.jpeg.JpegExif;
import edu.harvard.hul.ois.jhove.module.jpeg.JpegStrings;
import edu.harvard.hul.ois.jhove.module.jpeg.QuantizationTable;
import edu.harvard.hul.ois.jhove.module.jpeg.SRS;
import edu.harvard.hul.ois.jhove.module.jpeg.Spiff;
import edu.harvard.hul.ois.jhove.module.jpeg.SpiffDir;
import edu.harvard.hul.ois.jhove.module.jpeg.Tiling;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JpegModule
extends ModuleBase {
    private static final String NISO_IMAGE_MD = "NisoImageMetadata";
    private static final String NAME = "JPEG-hul";
    private static final String RELEASE = "1.2";
    private static final int[] DATE = new int[]{2007, 2, 13};
    private static final String[] FORMAT = new String[]{"JPEG", "ISO/IEC 10918-1:1994", "Joint Photographic Experts Group", "JFIF", "JPEG File Interchange Format", "SPIFF", "ISO/IEC 10918-3:1997", "Still Picture Interchange File Format", "JTIP", "ISO/IEC 10918-3:1997", "JPEG Tiled Image Pyramid", "JPEG-LS", "ISO/IEC 14495"};
    private static final String COVERAGE = "JPEG (ISO/IEC 10918-1:1994), JFIF 1.02, SPIFF (ISO/IEC 10918-3:1997), Exif 2.0, 2.1 (JEIDA-49-1998), and 2.2 (JEITA CP-3451), JTIP (ISO/IEC 10918-3:1997), JPEG-LS (ISO/IEC 14495)";
    private static final String[] MIMETYPE = new String[]{"image/jpeg"};
    private static final String WELLFORMED = "A JPEG file is well-formed if the first three bytes are 0xFFD8FF, it consists of one or more correctly formatted segments (using markers 0xC0 through 0xFE), and the data streams following RSTn and SOS markers are correctly terminated";
    private static final String VALIDITY = "A JPEG file is valid if well-formed; the first non-comment segment is APP0 (with identifier 0x4A46494600, indicating JFIF or JTIP), APP1 (with identifier (0x457869660000, indicating Exif), APP8 (with identifier 0x545049464600, indicating SPIFF), or JPG7 (or SOF55, indicating JPEG-LS); D8 marker occurs only at the beginning of the file; any DTT segments are preceded by DTI segments; and all DTI segment tiling type have a value of 0, 1, or 2";
    private static final String REPINFO = "Additional representation information includes: NISO Z39.87 Digital Still Image Technical Metadata and segment-specific metadata";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected String jfifProfileName = "JFIF";
    protected String spiffProfileName = "SPIFF";
    protected String exifProfileName = "Exif";
    protected String jpeglProfileName = "JPEG-L";
    protected NumberFormat minorFmt = NumberFormat.getInstance();
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    protected Property _imageProp;
    protected Property _exifProp;
    protected Property _xmpProp;
    protected NisoImageMetadata _niso;
    protected List<Property> _propList;
    protected List<Property> _imageList;
    protected Tiling _tiling;
    protected List<QuantizationTable> _quantTables;
    protected List<ArithConditioning> _arithCondTables;
    protected List<SRS> _srsList;
    protected List<Property> _primaryImageList;
    protected int _numSegments;
    protected int _numScans;
    protected int _restartInterval;
    protected boolean _seenJFIF;
    protected boolean _seenSPIFF;
    protected boolean _seenJPEGL;
    protected boolean _reportedSigMatch;
    protected SpiffDir _spiffDir;
    protected boolean _seenExif;
    protected boolean _exifProfileOK;
    protected boolean _reportedJFIF;
    protected boolean _seenSOF;
    protected List<String> _commentsList;
    protected List<String> _jpegExtsList;
    protected List<String> _appSegsList;
    protected List<boolean[]> _expList;
    protected Set _compressSet;
    protected int _capability0;
    protected int _capability1;
    private static final int[] sigByte = new int[]{255, 216, 255};
    protected int _units;
    protected int _xDensity;
    protected int _yDensity;

    public JpegModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this.minorFmt.setMinimumIntegerDigits(2);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("Eric Hamilton, JPEG File Interchange Format, Version 1.02, September 1, 1992", DocumentType.WEB);
        Agent agent = new Agent.Builder("C-Cube Microsystems", AgentType.COMMERCIAL).address("1778 McCarthy Boulevard, Milipitas, CA 95035").telephone("+1 (408) 944-6314").fax("+1 (408) 944-6314").build();
        doc.setPublisher(agent);
        doc.setDate("1992-09-01");
        doc.setIdentifier(new Identifier("http://www.w3.org/Graphics/JPEG/jfif3.pdf", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("ISO/IEC 10918-1:1994(E), Information technology -- Digital compression and coding of continuous-tone still images: Requirements and guidelines", DocumentType.STANDARD);
        Agent isoAgent = Agent.newIsoInstance();
        doc.setPublisher(isoAgent);
        doc.setIdentifier(new Identifier("CCITT REc. T.81 (1992 E)", IdentifierType.CCITT));
        this._specification.add(doc);
        doc = new Document("ISO/IEC 10918-3:1997(E), Digital compressionand coding of continuous-tone still-images: Extensions", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        doc.setIdentifier(new Identifier("ITU-T Rec. T.84 (1996 E)", IdentifierType.CCITT));
        this._specification.add(doc);
        doc = new Document("ISO/IEC 14495-1:1999(E), Information technology -- Lossless and near-lossless compression of continuous-tone still images: Baseline", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        this._specification.add(doc);
        doc = new Document("ISO/IEC 14495-2:2003(E), Information technology -- Lossless and near-lossless compression of continuous-tone still images: Extensions", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        this._specification.add(doc);
        doc = new Document("Exchangeable image file format for digital still cameras: Exif Version 2.2", DocumentType.STANDARD);
        Agent jeitaAgent = new Agent.Builder("Japan Electronics and Information Technology Industries Association", AgentType.STANDARD).web("http://www.jeita.or.jp/").address("Mitsui Sumitomo Kaijo Building Annex, 11, Kanda Surugadai 3-chome, Chiyoda-ku, Tokyo 101-0062, Japan").telephone("+81(03) 3518-6421").fax("+81(03) 3295-8721").build();
        doc.setPublisher(jeitaAgent);
        doc.setDate("2002-04");
        Identifier ident = new Identifier("JEITA CP-3451", IdentifierType.JEITA);
        doc.setIdentifier(ident);
        ident = new Identifier("http://www.exif.org/Exif2-2.PDF", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Digital Still Camera Image File Format Standard (Exchangeable image file format for Digital Still Camera:Exif)", DocumentType.STANDARD);
        doc.setPublisher(jeitaAgent);
        doc.setDate("1998-12");
        ident = new Identifier("JEITA JEIDA-49-1998", IdentifierType.JEITA);
        doc.setIdentifier(ident);
        ident = new Identifier("http://www.exif.org/dcf-exif.PDF", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        Signature sig = new InternalSignature(sigByte, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(sig);
        sig = new ExternalSignature(".jpg", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".jls", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "Generally used for JPEG-LS (ISO/IEC 14495)");
        this._signature.add(sig);
        sig = new ExternalSignature(".spf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "Generally used for SPIFF (ISO/IEC 10918-3:1997)");
        this._signature.add(sig);
        this._bigEndian = true;
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        this._dstream = JpegModule.getBufferedDataStream(stream, this._je != null ? this._je.getBufferSize() : 0);
        for (int i = 0; i < 3; ++i) {
            int ch;
            try {
                ch = JpegModule.readUnsignedByte(this._dstream, this);
            }
            catch (Exception e) {
                ch = -1;
            }
            if (ch == sigByte[i]) continue;
            info.setWellFormed(false);
            return;
        }
        info.setModule(this);
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setSigMatch(this._name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        Object qt;
        Property tp;
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, this._ckSummer);
            this._dstream = JpegModule.getBufferedDataStream(this._cstream, this._je != null ? this._je.getBufferSize() : 0);
        } else {
            this._dstream = JpegModule.getBufferedDataStream(stream, this._je != null ? this._je.getBufferSize() : 0);
        }
        this._propList = new LinkedList<Property>();
        this._metadata = new Property("JPEGMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        if (!this.readHeader(info)) {
            return 0;
        }
        this._niso = new NisoImageMetadata();
        Property nisoProp = new Property(NISO_IMAGE_MD, PropertyType.NISOIMAGEMETADATA, this._niso);
        this._primaryImageList.add(nisoProp);
        this.initNiso();
        boolean dataPlowing = false;
        try {
            block26: while (true) {
                int dbyt = 0;
                boolean sawFF = false;
                if (!dataPlowing) {
                    dbyt = JpegModule.readUnsignedByte(this._dstream, this);
                    if (dbyt != 255) {
                        info.setMessage(new ErrorMessage("Expected marker byte 255, got " + dbyt, this._nByte));
                        info.setWellFormed(false);
                        return 0;
                    }
                    while (dbyt == 255) {
                        dbyt = JpegModule.readUnsignedByte(this._dstream, this);
                    }
                } else {
                    while (true) {
                        if ((dbyt = JpegModule.readUnsignedByte(this._dstream, this)) == 255) {
                            sawFF = true;
                            continue;
                        }
                        if (!sawFF) continue;
                        if ((dbyt & 0x80) != 0) {
                            dataPlowing = false;
                            break;
                        }
                        sawFF = false;
                    }
                }
                ++this._numSegments;
                if (!(this._seenJFIF || this._seenSPIFF || this._seenExif || this._seenJPEGL || this._numSegments < 2 || this._reportedJFIF)) {
                    info.setMessage(new ErrorMessage("File does not begin with SPIFF, Exif or JFIF segment", this._nByte));
                    info.setValid(false);
                    this._reportedJFIF = true;
                }
                if (dbyt >= 208 && dbyt <= 215) {
                    dataPlowing = true;
                    continue;
                }
                if (dbyt >= 247 && dbyt <= 253) {
                    this.readJPEGExtension(dbyt, info);
                    continue;
                }
                switch (dbyt) {
                    case 0: {
                        continue block26;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 207: {
                        this.readSOF(dbyt, info);
                        continue block26;
                    }
                    case 196: {
                        this.skipSegment(info);
                        continue block26;
                    }
                    case 204: {
                        this.readDAC(info);
                        continue block26;
                    }
                    case 217: {
                        break block26;
                    }
                    case 218: {
                        this.skipSegment(info);
                        ++this._numScans;
                        dataPlowing = true;
                        continue block26;
                    }
                    case 219: {
                        this.readDQT(info);
                        continue block26;
                    }
                    case 220: {
                        this.skipSegment(info);
                        continue block26;
                    }
                    case 221: {
                        this.readDRI(info);
                        continue block26;
                    }
                    case 222: {
                        this.readDHP(info);
                        continue block26;
                    }
                    case 223: {
                        this.readEXP(info);
                        continue block26;
                    }
                    case 224: {
                        this.readAPP0(info);
                        continue block26;
                    }
                    case 232: {
                        this.readAPP8(info);
                        continue block26;
                    }
                    case 225: {
                        this.readAPP1(info);
                        continue block26;
                    }
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 238: 
                    case 239: {
                        this.reportAppExt(dbyt, info);
                        this.skipSegment(info);
                        continue block26;
                    }
                    case 240: {
                        this.readVer(info);
                        continue block26;
                    }
                    case 241: {
                        this.readDTI(info);
                        continue block26;
                    }
                    case 242: {
                        this.readDTT(info);
                        continue block26;
                    }
                    case 244: {
                        this.readSRS(info);
                        continue block26;
                    }
                    case 254: {
                        --this._numSegments;
                        this.readComment(info);
                        continue block26;
                    }
                    default: {
                        ErrorMessage msg = new ErrorMessage("Marker not valid in context", this._nByte);
                        info.setMessage(msg);
                        info.setValid(false);
                        break block26;
                    }
                }
                break;
            }
        }
        catch (EOFException e) {
            ErrorMessage msg = new ErrorMessage("Unexpected end of file", this._nByte);
            info.setMessage(msg);
            info.setWellFormed(false);
            return 0;
        }
        info.setProperty(this._metadata);
        if (this._units == 0) {
            ArrayList<Property> list = new ArrayList<Property>();
            list.add(new Property("PixelAspectRatioX", PropertyType.INTEGER, new Integer(this._xDensity)));
            list.add(new Property("PixelAspectRatioY", PropertyType.INTEGER, new Integer(this._yDensity)));
            this._primaryImageList.add(new Property("PixelAspectRatio", PropertyType.PROPERTY, PropertyArity.LIST, list));
        }
        if (this._tiling != null && (tp = this.buildTilingProp(info)) != null) {
            this._primaryImageList.add(tp);
        }
        if (this._restartInterval >= 0) {
            this._primaryImageList.add(new Property("RestartInterval", PropertyType.INTEGER, new Integer(this._restartInterval)));
        }
        this._primaryImageList.add(new Property("Scans", PropertyType.INTEGER, new Integer(this._numScans)));
        if (!this._quantTables.isEmpty()) {
            LinkedList<Property> qpl = new LinkedList<Property>();
            ListIterator<QuantizationTable> iter = this._quantTables.listIterator();
            while (iter.hasNext()) {
                qt = iter.next();
                qpl.add(((QuantizationTable)qt).makeProperty(this._je.getShowRawFlag()));
            }
            this._primaryImageList.add(new Property("QuantizationTables", PropertyType.PROPERTY, PropertyArity.LIST, qpl));
        }
        if (!this._arithCondTables.isEmpty()) {
            LinkedList<Property> qpl = new LinkedList<Property>();
            ListIterator<ArithConditioning> iter = this._arithCondTables.listIterator();
            while (iter.hasNext()) {
                qt = iter.next();
                qpl.add(((ArithConditioning)qt).makeProperty(this._je.getShowRawFlag()));
            }
            this._primaryImageList.add(new Property("ArithmeticConditioning", PropertyType.PROPERTY, PropertyArity.LIST, qpl));
        }
        if (!this._srsList.isEmpty()) {
            LinkedList<Property> srsl = new LinkedList<Property>();
            ListIterator<SRS> iter = this._srsList.listIterator();
            while (iter.hasNext()) {
                SRS s = iter.next();
                srsl.add(s.makeProperty());
            }
            this._primaryImageList.add(new Property("SelectivelyRefinedScans", PropertyType.PROPERTY, PropertyArity.LIST, srsl));
        }
        if (this._ckSummer != null) {
            try {
                long n;
                while ((n = this.skipBytes(this._dstream, 2048L, this)) != 0L) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            info.setSize(this._cstream.getNBytes());
            info.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = this._ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = this._ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
        this._imageList.add(new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, this._primaryImageList));
        if (this._seenJFIF) {
            info.setProfile(this.jfifProfileName);
        }
        if (this._seenExif && this._exifProfileOK) {
            info.setProfile(this.exifProfileName);
        }
        if (this._seenSPIFF) {
            info.setProfile(this.spiffProfileName);
            if (this._spiffDir != null) {
                this._spiffDir.appendThumbnailProps(this._imageList);
            }
        }
        if (this._seenJPEGL) {
            info.setProfile(this.jpeglProfileName);
        }
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(new Property("Number", PropertyType.INTEGER, PropertyArity.SCALAR, new Integer(this._imageList.size())));
        for (Property prop : this._imageList) {
            list.add(prop);
        }
        this._propList.add(new Property("Images", PropertyType.PROPERTY, PropertyArity.LIST, list));
        if (!this._commentsList.isEmpty()) {
            this._propList.add(new Property("Comments", PropertyType.STRING, PropertyArity.LIST, this._commentsList));
        }
        if (!this._jpegExtsList.isEmpty()) {
            this._propList.add(new Property("Extensions", PropertyType.STRING, PropertyArity.LIST, this._jpegExtsList));
        }
        if (!this._appSegsList.isEmpty()) {
            this._propList.add(new Property("ApplicationSegments", PropertyType.STRING, PropertyArity.LIST, this._appSegsList));
        }
        if (!this._expList.isEmpty()) {
            this._propList.add(this.buildExpandProp(info));
        }
        if (this._exifProp != null) {
            this._primaryImageList.add(this._exifProp);
        }
        if (this._xmpProp != null) {
            this._primaryImageList.add(this._xmpProp);
        }
        return 0;
    }

    public int readUnsignedShort(DataInputStream stream) throws IOException {
        return JpegModule.readUnsignedShort(stream, true, this);
    }

    public long readUnsignedInt(DataInputStream stream) throws IOException {
        return JpegModule.readUnsignedInt(stream, true, this);
    }

    @Override
    protected void initParse() {
        super.initParse();
        this._imageList = new LinkedList<Property>();
        this._tiling = null;
        this._restartInterval = -1;
        this._seenSOF = false;
        this._seenJFIF = false;
        this._seenSPIFF = false;
        this._seenJPEGL = false;
        this._spiffDir = null;
        this._seenExif = false;
        this._reportedSigMatch = false;
        this._exifProfileOK = false;
        this._reportedJFIF = false;
        this._numSegments = 0;
        this._numScans = 0;
        this._commentsList = new LinkedList<String>();
        this._jpegExtsList = new LinkedList<String>();
        this._appSegsList = new LinkedList<String>();
        this._primaryImageList = new LinkedList<Property>();
        this._quantTables = new LinkedList<QuantizationTable>();
        this._arithCondTables = new LinkedList<ArithConditioning>();
        this._srsList = new LinkedList<SRS>();
        this._compressSet = new HashSet();
        this._expList = new LinkedList<boolean[]>();
        this._exifProp = null;
        this._xmpProp = null;
        this._capability0 = -1;
        this._capability1 = -1;
    }

    protected void initNiso() {
        this._niso.setMimeType("image/jpeg");
        this._niso.setByteOrder("big-endian");
        this._niso.setCompressionScheme(6);
    }

    protected boolean readHeader(RepInfo info) {
        boolean valid = true;
        try {
            for (int i = 0; i < 2; ++i) {
                int ch = JpegModule.readUnsignedByte(this._dstream, this);
                if (ch == sigByte[i]) continue;
                valid = false;
                break;
            }
        }
        catch (IOException e) {
            valid = false;
        }
        if (!valid) {
            info.setMessage(new ErrorMessage("Invalid JPEG header", 0L));
            info.setWellFormed(false);
            return false;
        }
        return true;
    }

    protected void readAPP0(RepInfo info) throws IOException {
        int[] jfxxByte = new int[]{74, 70, 88, 88, 0};
        int[] jfifByte = new int[]{74, 70, 73, 70, 0};
        if (!this._reportedSigMatch) {
            info.setSigMatch(this._name);
            this._reportedSigMatch = true;
        }
        this.reportAppExt(224, info);
        int[] ident = new int[5];
        int length = this.readUnsignedShort(this._dstream);
        if (this._seenSPIFF) {
            this.skipBytes(this._dstream, length - 2, this);
            return;
        }
        for (int i = 0; i < 5; ++i) {
            ident[i] = JpegModule.readUnsignedByte(this._dstream, this);
        }
        if (JpegModule.equalArray(ident, jfifByte)) {
            if (this._numSegments > 1) {
                info.setMessage(new ErrorMessage("JFIF APP0 marker not at beginning of file", this._nByte));
                info.setValid(false);
                this.skipBytes(this._dstream, length - 7, this);
            }
            this._seenJFIF = true;
            int majorVersion = JpegModule.readUnsignedByte(this._dstream, this);
            int minorVersion = JpegModule.readUnsignedByte(this._dstream, this);
            String vsn = Integer.toString(majorVersion) + "." + this.minorFmt.format(minorVersion);
            info.setVersion(vsn);
            this._units = JpegModule.readUnsignedByte(this._dstream, this);
            if (this._units >= 0 && this._units <= 2) {
                this._niso.setSamplingFrequencyUnit(this._units + 1);
            }
            this._xDensity = this.readUnsignedShort(this._dstream);
            this._yDensity = this.readUnsignedShort(this._dstream);
            if (this._units != 0) {
                this._niso.setXSamplingFrequency(new Rational(this._xDensity, 1));
                this._niso.setYSamplingFrequency(new Rational(this._yDensity, 1));
            }
            int xThumbPix = JpegModule.readUnsignedByte(this._dstream, this);
            int yThumbPix = JpegModule.readUnsignedByte(this._dstream, this);
            if (xThumbPix > 0 && yThumbPix > 0) {
                NisoImageMetadata thumbNiso = new NisoImageMetadata();
                thumbNiso.setImageWidth(xThumbPix);
                thumbNiso.setImageLength(yThumbPix);
                thumbNiso.setColorSpace(2);
                thumbNiso.setCompressionScheme(1);
                thumbNiso.setPixelSize(8.0);
                LinkedList<Property> thumbPropList = new LinkedList<Property>();
                thumbPropList.add(new Property(NISO_IMAGE_MD, PropertyType.NISOIMAGEMETADATA, thumbNiso));
                Property thumbProp = new Property("ThumbImage", PropertyType.PROPERTY, PropertyArity.LIST, thumbPropList);
                this._imageList.add(thumbProp);
            }
            this._niso.setColorSpace(6);
            this.skipBytes(this._dstream, 3 * xThumbPix * yThumbPix, this);
        } else if (JpegModule.equalArray(ident, jfxxByte)) {
            int extCode = JpegModule.readUnsignedByte(this._dstream, this);
            switch (extCode) {
                case 17: 
                case 19: {
                    int xThumbPix = JpegModule.readUnsignedByte(this._dstream, this);
                    int yThumbPix = JpegModule.readUnsignedByte(this._dstream, this);
                    this.skipBytes(this._dstream, length - 4, this);
                    NisoImageMetadata thumbNiso = new NisoImageMetadata();
                    thumbNiso.setImageWidth(xThumbPix);
                    thumbNiso.setImageLength(yThumbPix);
                    thumbNiso.setColorSpace(extCode == 19 ? 2 : 3);
                    thumbNiso.setCompressionScheme(1);
                    thumbNiso.setPixelSize(8.0);
                    LinkedList<Property> thumbPropList = new LinkedList<Property>();
                    thumbPropList.add(new Property(NISO_IMAGE_MD, PropertyType.NISOIMAGEMETADATA, thumbNiso));
                    Property thumbProp = new Property("ThumbImage", PropertyType.PROPERTY, PropertyArity.LIST, thumbPropList);
                    this._imageList.add(thumbProp);
                }
            }
            this.skipBytes(this._dstream, length - 2, this);
        } else {
            this.skipBytes(this._dstream, length - 2, this);
        }
    }

    protected void readAPP1(RepInfo info) throws IOException {
        int[] exifByte = new int[]{69, 120, 105, 102, 0, 0};
        int[] xmpByte = new int[]{104, 116, 116, 112, 58, 47};
        String xmpStr = "http://ns.adobe.com/xap/1.0/";
        this.reportAppExt(225, info);
        int[] ident = new int[6];
        int length = this.readUnsignedShort(this._dstream);
        if (length < 8) {
            this.skipBytes(this._dstream, length - 2, this);
            return;
        }
        for (int i = 0; i < 6; ++i) {
            ident[i] = JpegModule.readUnsignedByte(this._dstream, this);
        }
        if (JpegModule.equalArray(ident, exifByte)) {
            if (!this._reportedSigMatch) {
                info.setSigMatch(this._name);
                this._reportedSigMatch = true;
            }
            this._seenExif = true;
            if (!JpegExif.isTiffAvailable()) {
                info.setMessage(new InfoMessage("TIFF-HUL module required to report Exif data", this._nByte));
                this.skipBytes(this._dstream, length - 8, this);
                return;
            }
            JpegExif je = new JpegExif();
            RepInfo exifInfo = je.readExifData(this._dstream, this._je, length);
            if (exifInfo != null) {
                List<Message> list = exifInfo.getMessage();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    info.setMessage(list.get(i));
                }
                this._exifProp = exifInfo.getProperty("Exif");
                Property nisoProp = exifInfo.getProperty(NISO_IMAGE_MD);
                if (nisoProp != null) {
                    this.extractExifNisoData((NisoImageMetadata)nisoProp.getValue());
                }
            }
            this._exifProfileOK = je.isExifProfileOK();
        } else if (JpegModule.equalArray(ident, xmpByte) && length >= 32) {
            boolean match = true;
            for (int i = 6; i < 28; ++i) {
                int ch = JpegModule.readUnsignedByte(this._dstream, this);
                --length;
                if (ch == "http://ns.adobe.com/xap/1.0/".charAt(i)) continue;
                match = false;
                break;
            }
            if (!match) {
                this.skipBytes(this._dstream, length - 8, this);
                return;
            }
            JpegModule.readUnsignedByte(this._dstream, this);
            byte[] xmpBuf = new byte[--length - 8];
            JpegModule.readByteBuf(this._dstream, xmpBuf, this);
            this._xmpProp = this.readXMP(xmpBuf);
        } else {
            this.skipBytes(this._dstream, length - 8, this);
        }
    }

    protected void readAPP8(RepInfo info) throws IOException {
        int[] spiffByte = new int[]{83, 80, 73, 70, 70, 0};
        if (!this._reportedSigMatch) {
            info.setSigMatch(this._name);
            this._reportedSigMatch = true;
        }
        this.reportAppExt(232, info);
        int length = this.readUnsignedShort(this._dstream);
        int[] ident = new int[6];
        if (this._spiffDir != null) {
            this._spiffDir.readDirEntry(this._dstream, length);
            return;
        }
        for (int i = 0; i < 6; ++i) {
            ident[i] = JpegModule.readUnsignedByte(this._dstream, this);
        }
        if (JpegModule.equalArray(ident, spiffByte)) {
            int units;
            if (this._numSegments > 1) {
                info.setMessage(new ErrorMessage("SPIFF marker not at beginning of file", this._nByte));
                info.setValid(false);
            }
            this._seenSPIFF = true;
            this._spiffDir = new SpiffDir(this);
            int majorVersion = JpegModule.readUnsignedByte(this._dstream, this);
            int minorVersion = JpegModule.readUnsignedByte(this._dstream, this);
            String vsn = Integer.toString(majorVersion) + "." + this.minorFmt.format(minorVersion);
            info.setVersion(vsn);
            JpegModule.readUnsignedByte(this._dstream, this);
            JpegModule.readUnsignedByte(this._dstream, this);
            long height = this.readUnsignedInt(this._dstream);
            this._niso.setImageLength(height);
            long width = this.readUnsignedInt(this._dstream);
            this._niso.setImageWidth(width);
            int colorSpace = JpegModule.readUnsignedByte(this._dstream, this);
            int nisoCS = Spiff.colorSpaceToNiso(colorSpace);
            if (nisoCS >= 0) {
                this._niso.setColorSpace(nisoCS);
            }
            int bps = JpegModule.readUnsignedByte(this._dstream, this);
            int compType = JpegModule.readUnsignedByte(this._dstream, this);
            int nisoCT = Spiff.compressionTypeToNiso(compType);
            if (nisoCT >= 0) {
                this._niso.setCompressionScheme(nisoCT);
            }
            if ((units = JpegModule.readUnsignedByte(this._dstream, this)) > 0 && units <= 2) {
                this._niso.setSamplingFrequencyUnit(units + 1);
            }
            long vRes = this.readUnsignedInt(this._dstream);
            long l = this.readUnsignedInt(this._dstream);
        } else {
            this.skipBytes(this._dstream, length - 8, this);
        }
    }

    protected void readVer(RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        int majVersion = JpegModule.readUnsignedByte(this._dstream, this);
        int minVersion = JpegModule.readUnsignedByte(this._dstream, this);
        String vsn = Integer.toString(majVersion) + "." + this.minorFmt.format(minVersion);
        info.setVersion(vsn);
        int skip = length - 4;
        if (majVersion <= 1) {
            this._capability0 = JpegModule.readUnsignedByte(this._dstream, this);
            --skip;
            if (majVersion == 1) {
                this._capability1 = JpegModule.readUnsignedByte(this._dstream, this);
                --skip;
            }
        }
        this.skipBytes(this._dstream, skip, this);
        this._seenJPEGL = false;
    }

    protected void readDTI(RepInfo info) throws IOException {
        this.readUnsignedShort(this._dstream);
        this._tiling = new Tiling();
        this._tiling.setTilingType(JpegModule.readUnsignedByte(this._dstream, this));
        this._tiling.setVertScale(this.readUnsignedShort(this._dstream));
        this._tiling.setHorScale(this.readUnsignedShort(this._dstream));
        this._tiling.setRefGridHeight(this.readUnsignedInt(this._dstream));
        this._tiling.setRefGridWidth(this.readUnsignedInt(this._dstream));
        this._seenJPEGL = false;
    }

    protected void readDTT(RepInfo info) throws IOException {
        this.readUnsignedShort(this._dstream);
        if (this._tiling == null) {
            info.setMessage(new ErrorMessage("DTT segment without previous DTI", this._nByte));
            info.setValid(false);
            return;
        }
        long vertScale = this.readUnsignedInt(this._dstream);
        long horScale = this.readUnsignedInt(this._dstream);
        long vertOffset = this.readUnsignedInt(this._dstream);
        long horOffset = this.readUnsignedInt(this._dstream);
        this._tiling.addTile(vertScale, horScale, vertOffset, horOffset);
        this._seenJPEGL = false;
    }

    protected void readSRS(RepInfo info) throws IOException {
        this.readUnsignedShort(this._dstream);
        int vertOffset = this.readUnsignedShort(this._dstream);
        int horOffset = this.readUnsignedShort(this._dstream);
        int vertSize = this.readUnsignedShort(this._dstream);
        int horSize = this.readUnsignedShort(this._dstream);
        this._srsList.add(new SRS(vertOffset, horOffset, vertSize, horSize));
    }

    protected void reportAppExt(int dbyt, RepInfo info) {
        String appStr = "APP";
        appStr = dbyt <= 233 ? appStr + (char)(dbyt - 224 + 48) : appStr + "1" + (char)(dbyt - 234 + 48);
        this._appSegsList.add(appStr);
    }

    protected void readSOF(int dbyt, RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        int precision = JpegModule.readUnsignedByte(this._dstream, this);
        int nLines = this.readUnsignedShort(this._dstream);
        int samPerLine = this.readUnsignedShort(this._dstream);
        int numComps = JpegModule.readUnsignedByte(this._dstream, this);
        this.skipBytes(this._dstream, length - 8, this);
        if (!this._seenSOF) {
            this._niso.setImageLength(nLines);
            this._niso.setImageWidth(samPerLine);
            int[] bps = new int[numComps];
            for (int i = 0; i < numComps; ++i) {
                bps[i] = precision;
            }
            this._niso.setBitsPerSample(bps);
            this._niso.setSamplesPerPixel(numComps);
            this._propList.add(new Property("CompressionType", PropertyType.STRING, JpegStrings.COMPRESSION_TYPE[dbyt - 192]));
            this._seenSOF = true;
        }
    }

    protected void readDHP(RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        int precision = JpegModule.readUnsignedByte(this._dstream, this);
        int nLines = this.readUnsignedShort(this._dstream);
        int samPerLine = this.readUnsignedShort(this._dstream);
        int numComps = JpegModule.readUnsignedByte(this._dstream, this);
        this.skipBytes(this._dstream, length - 8, this);
        if (!this._seenSOF) {
            this._niso.setImageLength(nLines);
            this._niso.setImageWidth(samPerLine);
            int[] bps = new int[numComps];
            for (int i = 0; i < numComps; ++i) {
                bps[i] = precision;
            }
            this._niso.setBitsPerSample(bps);
            this._niso.setSamplesPerPixel(numComps);
            this._seenSOF = true;
        }
    }

    protected void readEXP(RepInfo info) throws IOException {
        this.readUnsignedShort(this._dstream);
        int lhlv = JpegModule.readUnsignedByte(this._dstream, this);
        boolean[] arr = new boolean[]{(lhlv & 0xF0) != 0, (lhlv & 0xF) != 0};
        this._expList.add(arr);
    }

    protected void readDRI(RepInfo info) throws IOException {
        this.readUnsignedShort(this._dstream);
        this._restartInterval = this.readUnsignedShort(this._dstream);
    }

    protected void readDQT(RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        int pqtq = JpegModule.readUnsignedByte(this._dstream, this);
        int pq = pqtq >> 4;
        int tq = pqtq & 0xF;
        this._quantTables.add(new QuantizationTable(pq, tq));
        this.skipBytes(this._dstream, length - 3, this);
        this._seenJPEGL = false;
    }

    protected void readDAC(RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        int pqtq = JpegModule.readUnsignedByte(this._dstream, this);
        int pq = pqtq >> 4;
        int tq = pqtq & 0xF;
        this._arithCondTables.add(new ArithConditioning(pq, tq));
        this.skipBytes(this._dstream, length - 3, this);
        this._seenJPEGL = false;
    }

    protected void readJPEGExtension(int dbyt, RepInfo info) throws IOException {
        String ext = dbyt <= 249 ? "JPG" + (char)(dbyt - 240 + 48) : "JPG1" + (char)(dbyt - 250 + 48);
        this._jpegExtsList.add(ext);
        if (dbyt != 247 && dbyt != 248) {
            this._seenJPEGL = false;
        }
        if (!(dbyt != 247 || this._seenSPIFF || this._seenJFIF || this._seenExif || this._seenJPEGL)) {
            if (!this._reportedSigMatch) {
                info.setSigMatch(this._name);
                this._reportedSigMatch = true;
            }
            int length = this.readUnsignedShort(this._dstream);
            int precision = JpegModule.readUnsignedByte(this._dstream, this);
            int nLines = this.readUnsignedShort(this._dstream);
            int samPerLine = this.readUnsignedShort(this._dstream);
            int numComps = JpegModule.readUnsignedByte(this._dstream, this);
            this.skipBytes(this._dstream, length - 8, this);
            this._seenJPEGL = true;
            this._niso.setImageLength(nLines);
            this._niso.setImageWidth(samPerLine);
            int[] bps = new int[numComps];
            for (int i = 0; i < numComps; ++i) {
                bps[i] = precision;
            }
            this._niso.setBitsPerSample(bps);
            this._niso.setSamplesPerPixel(numComps);
            this._seenSOF = true;
            return;
        }
        int length = this.readUnsignedShort(this._dstream);
        this.skipBytes(this._dstream, length - 2, this);
    }

    protected void readComment(RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        StringBuffer buf = new StringBuffer();
        boolean getChars = true;
        for (int i = 0; i < length - 2; ++i) {
            int ch = JpegModule.readUnsignedByte(this._dstream, this);
            if (ch == 0) {
                getChars = false;
            }
            if (!getChars) continue;
            buf.append((char)ch);
        }
        if (buf.length() > 0) {
            this._commentsList.add(buf.toString());
        }
    }

    protected Property buildCapProp(RepInfo info) {
        if (this._capability0 < 0) {
            return null;
        }
        try {
            ArrayList<Property> capList = new ArrayList<Property>(3);
            Property cap0Prop = this._je.getShowRawFlag() ? new Property("Version0", PropertyType.INTEGER, new Integer(this._capability0)) : new Property("Version0", PropertyType.STRING, JpegStrings.CAPABILITY_V0[this._capability0]);
            capList.add(cap0Prop);
            if (this._capability1 >= 0) {
                if (this._je.getShowRawFlag()) {
                    Property cap1Prop = new Property("Version1", PropertyType.INTEGER, new Integer(this._capability1));
                    capList.add(cap1Prop);
                } else {
                    String[] cap1Str = new String[]{JpegStrings.CAPABILITY_V1[this._capability1 & 0x1F], JpegStrings.TILING_CAPABILITY_V1[this._capability1 >> 5]};
                    Property cap1Prop = new Property("Version1", PropertyType.STRING, PropertyArity.ARRAY, cap1Str);
                    capList.add(cap1Prop);
                }
            }
            return new Property("CapabilityIndicator", PropertyType.PROPERTY, PropertyArity.LIST, capList);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Property buildTilingProp(RepInfo info) {
        if (this._tiling == null) {
            return null;
        }
        try {
            Property[] propArr = new Property[6];
            int tilingType = this._tiling.getTilingType();
            propArr[0] = this._je.getShowRawFlag() ? new Property("TilingType", PropertyType.INTEGER, new Integer(tilingType)) : new Property("TilingType", PropertyType.STRING, JpegStrings.TILING_TYPE[tilingType]);
            propArr[1] = new Property("VerticalScale", PropertyType.INTEGER, new Integer(this._tiling.getVertScale()));
            propArr[2] = new Property("HorizontalScale", PropertyType.INTEGER, new Integer(this._tiling.getHorScale()));
            propArr[3] = new Property("RefGridHeight", PropertyType.LONG, new Long(this._tiling.getRefGridHeight()));
            propArr[4] = new Property("RefGridWidth", PropertyType.LONG, new Long(this._tiling.getRefGridWidth()));
            propArr[5] = this._tiling.buildTileListProp();
            return new Property("Tiling", PropertyType.PROPERTY, PropertyArity.ARRAY, propArr);
        }
        catch (Exception e) {
            info.setMessage(new ErrorMessage("Unrecognized tiling data"));
            info.setValid(false);
            return null;
        }
    }

    protected Property buildExpandProp(RepInfo info) {
        LinkedList<Property> plist = new LinkedList<Property>();
        Property prop = new Property("ExpansionSegments", PropertyType.PROPERTY, PropertyArity.LIST, plist);
        ListIterator<boolean[]> iter = this._expList.listIterator();
        while (iter.hasNext()) {
            boolean[] lhlv = iter.next();
            Property[] lhlvProp = new Property[]{new Property("Horizontal", PropertyType.BOOLEAN, new Boolean(lhlv[0])), new Property("Vertical", PropertyType.BOOLEAN, new Boolean(lhlv[1]))};
            plist.add(new Property("Expansion", PropertyType.PROPERTY, PropertyArity.ARRAY, lhlvProp));
        }
        return prop;
    }

    protected Property readXMP(byte[] buf) {
        Property xmpProp = null;
        try {
            ByteArrayInputStream strm = new ByteArrayInputStream(buf);
            ByteArrayXMPSource src = new ByteArrayXMPSource(strm);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            XMPHandler handler = new XMPHandler();
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                parser.parse(src);
                xmpProp = src.makeProperty();
                return xmpProp;
            }
            catch (SAXException se) {
                String msg = se.getMessage();
                if (msg != null && msg.startsWith("ENC=")) {
                    String encoding = msg.substring(5);
                    try {
                        src = new ByteArrayXMPSource(strm, encoding);
                        parser.parse(src);
                    }
                    catch (UnsupportedEncodingException uee) {
                        return null;
                    }
                }
                xmpProp = src.makeProperty();
                return xmpProp;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void extractExifNisoData(NisoImageMetadata exifData) {
        int NULL = -1;
        if (exifData.getAutoFocus() != NULL) {
            this._niso.setAutoFocus(exifData.getAutoFocus());
        }
        if (exifData.getBackLight() != NULL) {
            this._niso.setBackLight(exifData.getBackLight());
        }
        if (exifData.getBrightness() != (double)NULL) {
            this._niso.setBrightness(exifData.getBrightness());
        }
        if (exifData.getColorTemp() != (double)NULL) {
            this._niso.setColorTemp(exifData.getColorTemp());
        }
        if (exifData.getDeviceSource() != null) {
            this._niso.setDeviceSource(exifData.getDeviceSource());
        }
        if (exifData.getDigitalCameraManufacturer() != null) {
            this._niso.setDigitalCameraManufacturer(exifData.getDigitalCameraManufacturer());
        }
        if (exifData.getDigitalCameraModel() != null) {
            this._niso.setDigitalCameraModel(exifData.getDigitalCameraModel());
        }
        if (exifData.getExposureBias() != (double)NULL) {
            this._niso.setExposureBias(exifData.getExposureBias());
        }
        if (exifData.getExposureIndex() != (double)NULL) {
            this._niso.setExposureIndex(exifData.getExposureIndex());
        }
        if (exifData.getExposureTime() != (double)NULL) {
            this._niso.setExposureTime(exifData.getExposureTime());
        }
        if (exifData.getFlash() != NULL) {
            this._niso.setFlash(exifData.getFlash());
        }
        if (exifData.getFlashEnergy() != (double)NULL) {
            this._niso.setFlashEnergy(exifData.getFlashEnergy());
        }
        if (exifData.getFlashReturn() != NULL) {
            this._niso.setFlashReturn(exifData.getFlashReturn());
        }
        if (exifData.getFNumber() != (double)NULL) {
            this._niso.setFNumber(exifData.getFNumber());
        }
        if (exifData.getHostComputer() != null) {
            this._niso.setHostComputer(exifData.getHostComputer());
        }
        if (exifData.getImageIdentifier() != null) {
            this._niso.setImageIdentifier(exifData.getImageIdentifier());
        }
        if (exifData.getImageProducer() != null) {
            this._niso.setImageProducer(exifData.getImageProducer());
        }
        if (exifData.getMeteringMode() != NULL) {
            this._niso.setMeteringMode(exifData.getMeteringMode());
        }
        if (exifData.getOS() != null) {
            this._niso.setOS(exifData.getOS());
        }
        if (exifData.getOSVersion() != null) {
            this._niso.setOSVersion(exifData.getOSVersion());
        }
        if (exifData.getPerformanceData() != null) {
            this._niso.setPerformanceData(exifData.getPerformanceData());
        }
        if (exifData.getProcessingAgency() != null) {
            this._niso.setProcessingAgency(exifData.getProcessingAgency());
        }
        if (exifData.getProcessingSoftwareName() != null) {
            this._niso.setProcessingSoftwareName(exifData.getProcessingSoftwareName());
        }
        if (exifData.getProcessingSoftwareVersion() != null) {
            this._niso.setProcessingSoftwareVersion(exifData.getProcessingSoftwareVersion());
        }
        if (exifData.getScannerManufacturer() != null) {
            this._niso.setScannerManufacturer(exifData.getScannerManufacturer());
        }
        if (exifData.getScannerModelName() != null) {
            this._niso.setScannerModelName(exifData.getScannerModelName());
        }
        if (exifData.getScannerModelNumber() != null) {
            this._niso.setScannerModelNumber(exifData.getScannerModelNumber());
        }
        if (exifData.getScannerModelSerialNo() != null) {
            this._niso.setScannerModelSerialNo(exifData.getScannerModelSerialNo());
        }
        if (exifData.getSceneIlluminant() != NULL) {
            this._niso.setSceneIlluminant(exifData.getSceneIlluminant());
        }
        if (exifData.getSubjectDistance() != null) {
            this._niso.setSubjectDistance(exifData.getSubjectDistance());
        }
    }

    protected boolean skipSegment(RepInfo info) throws IOException {
        int length = this.readUnsignedShort(this._dstream);
        this.skipBytes(this._dstream, length - 2, this);
        return true;
    }

    protected static boolean equalArray(int[] a, int[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

