/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.pdf.AProfile;
import edu.harvard.hul.ois.jhove.module.pdf.AProfileLevelA;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.CrossRefStream;
import edu.harvard.hul.ois.jhove.module.pdf.Destination;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.FileTokenizer;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.LinearizedProfile;
import edu.harvard.hul.ois.jhove.module.pdf.Literal;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.NameTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.ObjectStream;
import edu.harvard.hul.ois.jhove.module.pdf.PageLabelNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStrings;
import edu.harvard.hul.ois.jhove.module.pdf.PdfXMPSource;
import edu.harvard.hul.ois.jhove.module.pdf.StringValuedToken;
import edu.harvard.hul.ois.jhove.module.pdf.TaggedProfile;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import edu.harvard.hul.ois.jhove.module.pdf.X1Profile;
import edu.harvard.hul.ois.jhove.module.pdf.X1aProfile;
import edu.harvard.hul.ois.jhove.module.pdf.X2Profile;
import edu.harvard.hul.ois.jhove.module.pdf.X3Profile;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PdfModule
extends ModuleBase {
    private static final String NAME = "PDF-hul";
    private static final String RELEASE = "1.8";
    private static final int[] DATE = new int[]{2017, 3, 14};
    private static final String[] FORMAT = new String[]{"PDF", "Portable Document Format"};
    private static final String COVERAGE = "PDF 1.0-1.6; PDF/X-1 (ISO 15930-1:2001), X-1a (ISO 15930-4:2003), X-2 (ISO 15930-5:2003), and X-3 (ISO 15930-6:2003); Tagged PDF; Linearized PDF; PDF/A (ISO/CD 19005-1)";
    private static final String[] MIMETYPE = new String[]{"application/pdf"};
    private static final String WELLFORMED = "A PDF file is well-formed if it meets the criteria defined in Chapter 3 of the PDF Reference 1.6 (5th edition, 2004)";
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "This module does *not* validate data within content streams (including operators) or encrypted data";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final String ENCRYPTED = "<May be encrypted>";
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");
    public static final int F_TYPE0 = 1;
    public static final int F_TYPE1 = 2;
    public static final int F_TT = 3;
    public static final int F_TYPE3 = 4;
    public static final int F_MM1 = 5;
    public static final int F_CID0 = 6;
    public static final int F_CID2 = 7;
    protected int DEFAULT_MAX_FONTS = 1000;
    private static final int EOFSCANSIZE = 1024;
    private static final int XREFSCANSIZE = 128;
    protected RandomAccessFile _raf;
    protected Parser _parser;
    protected String _version;
    protected Property _metadata;
    protected Property _xmpProp;
    protected long _eof;
    protected long _startxref;
    protected long _prevxref;
    protected int _numFreeObjects;
    protected Property _idProperty;
    protected int _objCount;
    protected int _numObjects;
    protected int _numTrailers;
    protected Map _objects;
    protected long[] _xref;
    protected int[][] _xref2;
    protected boolean _xrefIsStream;
    protected boolean _encrypted;
    protected List<Property> _docCatalogList;
    protected List<Property> _encryptList;
    protected List<Property> _docInfoList;
    protected List<Property> _extStreamsList;
    protected List<Property> _imagesList;
    protected List<Property> _filtersList;
    protected List<Property> _pagesList;
    protected Map<Integer, PdfObject> _type0FontsMap;
    protected Map<Integer, PdfObject> _type1FontsMap;
    protected Map<Integer, PdfObject> _mmFontsMap;
    protected Map<Integer, PdfObject> _type3FontsMap;
    protected Map<Integer, PdfObject> _trueTypeFontsMap;
    protected Map<Integer, PdfObject> _cid0FontsMap;
    protected Map<Integer, PdfObject> _cid2FontsMap;
    protected Map<Integer, Integer> _pageSeqMap;
    protected PdfIndirectObj _docCatDictRef;
    protected PdfIndirectObj _encryptDictRef;
    protected PdfIndirectObj _docInfoDictRef;
    protected PdfIndirectObj _pagesDictRef;
    protected PdfDictionary _docCatDict;
    protected PdfDictionary _docInfoDict;
    protected PageTreeNode _docTreeRoot;
    protected PdfDictionary _pageLabelDict;
    protected PageLabelNode _pageLabelRoot;
    protected NameTreeNode _embeddedFiles;
    protected NameTreeNode _destNames;
    protected PdfDictionary _encryptDict;
    protected PdfDictionary _trailerDict;
    protected PdfDictionary _viewPrefDict;
    protected PdfDictionary _outlineDict;
    protected PdfDictionary _destsDict;
    protected boolean _showFonts;
    protected boolean _showOutlines;
    protected boolean _showAnnotations;
    protected boolean _showPages;
    protected boolean _actionsExist;
    protected boolean _pdfACompliant;
    protected boolean _recursionWarned;
    protected boolean _skippedFontsReported;
    protected boolean _skippedOutlinesReported;
    protected boolean _skippedAnnotationsReported;
    protected boolean _skippedPagesReported;
    protected List<PdfProfile> _profile;
    protected ObjectStream _cachedObjectStream;
    protected int _cachedStreamIndex;
    protected Set<Integer> _visitedOutlineNodes;
    protected int maxFonts;
    protected int _nFonts;
    private static final String fontsSkippedString = "Fonts exist, but are not displayed; to display remove param value of f from the config file";
    private static final String outlinesSkippedString = "Outlines exist, but are not displayed; to display remove param value of o from the config file";
    private static final String annotationsSkippedString = "Annotations exist, but are not displayed; to display remove param value of a from the config file";
    private static final String pagesSkippedString = "Page information is not displayed; to display remove param value of p from the config file";
    protected static final String outlinesRecursiveString = "Outlines contain recursive references.";
    private static final String[] compressionStrings = new String[]{"LZWDecode", "RunLengthDecode", "DCTDecode", "CCITTFaxDecode"};
    private static final int[] compressionValues = new int[]{5, 32773, 6, 2};
    private static final String[] colorSpaceStrings = new String[]{"Lab", "DeviceRGB", "DeviceCMYK", "DeviceGray", "Indexed"};
    private static final int[] colorSpaceValues = new int[]{8, 2, 5, 1, 3};

    public PdfModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, true);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("PDF Reference: Adobe Portable Document Format, Version 1.4", DocumentType.BOOK);
        Agent agent = Agent.newAdobeInstance();
        doc.setPublisher(agent);
        doc.setDate("2001-12");
        doc.setEdition("3rd edition");
        doc.setIdentifier(new Identifier("0-201-75839-3", IdentifierType.ISBN));
        doc.setIdentifier(new Identifier("http://partners.adobe.com/asn/acrobat/docs/File_Format_Specifications/PDFReference.pdf", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("PDF Reference: Adobe Portable Document Format, Version 1.5", DocumentType.BOOK);
        doc.setPublisher(agent);
        doc.setDate("2003");
        doc.setEdition("4th edition");
        doc.setIdentifier(new Identifier("http://partners.adobe.com/public/developer/en/pdf/PDFReference15_v6.pdf", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("PDF Reference: Adobe Portable Document Format, Version 1.6", DocumentType.BOOK);
        doc.setPublisher(agent);
        doc.setDate("2004-11");
        doc.setEdition("5th edition");
        doc.setIdentifier(new Identifier("http://partners.adobe.com/public/developer/en/pdf/PDFReference16.pdf", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 1: Complete exchange using CMYK data (PDF/X-1 and PDF/X-1a)", DocumentType.STANDARD);
        Agent isoAgent = Agent.newIsoInstance();
        doc.setPublisher(isoAgent);
        doc.setDate("2001-12-06");
        doc.setIdentifier(new Identifier("ISO 15930-1:2001", IdentifierType.ISO));
        this._specification.add(doc);
        doc = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 4: Complete exchange using CMYK and spot colour printing data using PDF 1.4 (PDF/X-1a)", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        doc.setDate("2003-08-04");
        doc.setIdentifier(new Identifier("ISO 15930-4:2003", IdentifierType.ISO));
        this._specification.add(doc);
        doc = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 5: Partial exchange of printing data using PDF 1.4 (PDF/X-2)", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        doc.setDate("2003-08-05");
        doc.setIdentifier(new Identifier("ISO 15930-5:2003", IdentifierType.ISO));
        this._specification.add(doc);
        doc = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 6: Complete exchange suitable for colour-managed workflows using PDF 1.4 (PDF/X-3)", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        doc.setDate("2003-08-06");
        doc.setIdentifier(new Identifier("ISO 15930-6:2003", IdentifierType.ISO));
        this._specification.add(doc);
        this._signature.add(new ExternalSignature(".pdf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL));
        this._signature.add(new InternalSignature("%PDF-1.", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0));
        doc = new Document("Document management -- Electronic document file format for long-term preservation -- Part 1: Use of PDF (PDF/A)", DocumentType.RFC);
        doc.setPublisher(isoAgent);
        doc.setDate("2003-11-30");
        doc.setIdentifier(new Identifier("ISO/CD 19005-1", IdentifierType.ISO));
        doc.setIdentifier(new Identifier("http://www.aiim.org/documents/standards/ISO_19005-1_(E).doc", IdentifierType.URL));
        this._specification.add(doc);
        this._profile = new ArrayList<PdfProfile>(6);
        this._profile.add(new LinearizedProfile(this));
        TaggedProfile tpr = new TaggedProfile(this);
        this._profile.add(tpr);
        AProfile apr = new AProfile(this);
        this._profile.add(apr);
        apr.setTaggedProfile(tpr);
        AProfileLevelA apra = new AProfileLevelA(this);
        this._profile.add(apra);
        apra.setAProfile(apr);
        X1Profile x1 = new X1Profile(this);
        this._profile.add(x1);
        X1aProfile x1a = new X1aProfile(this);
        this._profile.add(x1a);
        x1a.setX1Profile(x1);
        this._profile.add(new X2Profile(this));
        this._profile.add(new X3Profile(this));
        this._showAnnotations = false;
        this._showFonts = false;
        this._showOutlines = false;
        this._showPages = false;
        this.maxFonts = this.DEFAULT_MAX_FONTS;
    }

    @Override
    public void resetParams() throws Exception {
        this._showAnnotations = true;
        this._showFonts = true;
        this._showOutlines = true;
        this._showPages = true;
        this.maxFonts = this.DEFAULT_MAX_FONTS;
    }

    @Override
    public void param(String param) {
        if (param != null) {
            if ((param = param.toLowerCase()).indexOf(97) >= 0) {
                this._showAnnotations = false;
            }
            if (param.indexOf(102) >= 0) {
                this._showFonts = false;
            }
            if (param.indexOf(111) >= 0) {
                this._showOutlines = false;
            }
            if (param.indexOf(112) >= 0) {
                this._showPages = false;
            }
            if (param.indexOf(110) >= 0) {
                char ch;
                int n = param.indexOf(110);
                StringBuffer b = new StringBuffer();
                for (int i = n + 1; i < param.length() && Character.isDigit(ch = param.charAt(i)); ++i) {
                    b.append(ch);
                }
                try {
                    int mx = Integer.parseInt(b.toString());
                    if (mx > 0) {
                        this.maxFonts = mx;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final void parse(RandomAccessFile raf, RepInfo info) throws IOException {
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        this._objects = new HashMap();
        this._raf = raf;
        FileTokenizer tok = new FileTokenizer(this._raf);
        this._parser = new Parser(tok);
        this._parser.setObjectMap(this._objects);
        ArrayList<Property> metadataList = new ArrayList<Property>(11);
        this._metadata = new Property("PDFMetadata", PropertyType.PROPERTY, PropertyArity.LIST, metadataList);
        if (this._raf.length() > 10000000000L) {
            this._pdfACompliant = false;
        }
        if (!this.parseHeader(info)) {
            return;
        }
        if (!this.findLastTrailer(info)) {
            return;
        }
        this._prevxref = -1L;
        boolean lastTrailer = true;
        while (this._startxref > 0L) {
            if (!this.parseTrailer(info, !lastTrailer)) {
                return;
            }
            if (!this.readXRefInfo(info)) {
                return;
            }
            ++this._numTrailers;
            if (this._xrefIsStream) break;
            if (this._startxref == this._prevxref) {
                info.setMessage(new ErrorMessage("Cross reference tables are broken", this._parser.getOffset()));
                info.setWellFormed(false);
                return;
            }
            this._startxref = this._prevxref;
            lastTrailer = false;
        }
        if (!this.readDocCatalogDict(info)) {
            return;
        }
        if (!this.readEncryptDict(info)) {
            return;
        }
        if (!this.readDocInfoDict(info)) {
            return;
        }
        if (!this.readDocumentTree(info)) {
            return;
        }
        if (!this.readPageLabelTree(info)) {
            return;
        }
        if (!this.readXMPData(info)) {
            return;
        }
        this.findExternalStreams(info);
        if (!this.findFilters(info)) {
            return;
        }
        this.findImages(info);
        this.findFonts(info);
        Checksummer ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            ckSummer = new Checksummer();
            this.calcRAChecksum(ckSummer, raf);
            this.setChecksums(ckSummer, info);
        }
        info.setVersion(this._version);
        metadataList.add(new Property("Objects", PropertyType.INTEGER, new Integer(this._numObjects)));
        metadataList.add(new Property("FreeObjects", PropertyType.INTEGER, new Integer(this._numFreeObjects)));
        metadataList.add(new Property("IncrementalUpdates", PropertyType.INTEGER, new Integer(this._numTrailers)));
        if (this._docCatalogList != null) {
            metadataList.add(new Property("DocumentCatalog", PropertyType.PROPERTY, PropertyArity.LIST, this._docCatalogList));
        }
        if (this._encryptList != null) {
            metadataList.add(new Property("Encryption", PropertyType.PROPERTY, PropertyArity.LIST, this._encryptList));
        }
        if (this._docInfoList != null) {
            metadataList.add(new Property("Info", PropertyType.PROPERTY, PropertyArity.LIST, this._docInfoList));
        }
        if (this._idProperty != null) {
            metadataList.add(this._idProperty);
        }
        if (this._extStreamsList != null && !this._extStreamsList.isEmpty()) {
            metadataList.add(new Property("ExternalStreams", PropertyType.PROPERTY, PropertyArity.LIST, this._extStreamsList));
        }
        if (this._filtersList != null && !this._filtersList.isEmpty()) {
            metadataList.add(new Property("Filters", PropertyType.PROPERTY, PropertyArity.LIST, this._filtersList));
        }
        if (this._imagesList != null && !this._imagesList.isEmpty()) {
            metadataList.add(new Property("Images", PropertyType.PROPERTY, PropertyArity.LIST, this._imagesList));
        }
        if (this._showFonts || this._verbosity == 1) {
            try {
                this.addFontsProperty(metadataList);
            }
            catch (NullPointerException e) {
                info.setMessage(new ErrorMessage("unexpected error in parsing font property", e.toString()));
            }
        }
        if (this._nFonts > this.maxFonts) {
            info.setMessage(new InfoMessage("Too many fonts to report; some fonts omitted.", "Total fonts = " + this._nFonts));
        }
        if (this._xmpProp != null) {
            metadataList.add(this._xmpProp);
        }
        this.addPagesProperty(metadataList, info);
        if (!this.doOutlineStuff(info)) {
            return;
        }
        info.setProperty(this._metadata);
        if (!this._parser.getPDFACompliant()) {
            this._pdfACompliant = false;
        }
        if (info.getWellFormed() == 1) {
            ListIterator<PdfProfile> pter = this._profile.listIterator();
            while (pter.hasNext()) {
                PdfProfile prof = pter.next();
                if (!prof.satisfiesProfile(this._raf, this._parser)) continue;
                info.setProfile(prof.getText());
            }
        }
    }

    public boolean mayBePDFACompliant() {
        return this._pdfACompliant;
    }

    public PageTreeNode getDocumentTree() {
        return this._docTreeRoot;
    }

    public PdfDictionary getDocInfo() {
        return this._docInfoDict;
    }

    public PdfDictionary getEncryptionDict() {
        return this._encryptDict;
    }

    public boolean getActionsExist() {
        return this._actionsExist;
    }

    @Override
    protected final void initParse() {
        super.initParse();
        this._xref = null;
        this._xref2 = null;
        this._version = "";
        this._objects = null;
        this._numFreeObjects = 0;
        this._objCount = 0;
        this._docInfoList = null;
        this._extStreamsList = null;
        this._docCatalogList = null;
        this._encryptList = null;
        this._imagesList = null;
        this._filtersList = null;
        this._pagesList = null;
        this._type0FontsMap = null;
        this._type1FontsMap = null;
        this._mmFontsMap = null;
        this._type3FontsMap = null;
        this._trueTypeFontsMap = null;
        this._cid0FontsMap = null;
        this._cid2FontsMap = null;
        this._docCatDictRef = null;
        this._encryptDictRef = null;
        this._docInfoDictRef = null;
        this._pagesDictRef = null;
        this._docCatDict = null;
        this._docInfoDict = null;
        this._docTreeRoot = null;
        this._pageLabelDict = null;
        this._encryptDict = null;
        this._trailerDict = null;
        this._viewPrefDict = null;
        this._outlineDict = null;
        this._destsDict = null;
        this._pageSeqMap = null;
        this._pageLabelRoot = null;
        this._embeddedFiles = null;
        this._destNames = null;
        this._skippedFontsReported = false;
        this._skippedOutlinesReported = false;
        this._skippedAnnotationsReported = false;
        this._skippedPagesReported = false;
        this._idProperty = null;
        this._actionsExist = false;
        this._numObjects = 0;
        this._numTrailers = -1;
        this._pdfACompliant = true;
        this._xmpProp = null;
        this._cachedStreamIndex = -1;
        this._nFonts = 0;
    }

    protected boolean parseHeader(RepInfo info) throws IOException {
        Token token = null;
        String value = null;
        String nohdr = "No PDF header";
        boolean foundSig = false;
        while (this._parser.getOffset() <= 1024L) {
            try {
                token = null;
                token = this._parser.getNext(1024L);
            }
            catch (IOException ee) {
                break;
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (token == null) break;
            if (token instanceof Comment) {
                int n;
                value = ((Comment)token).getValue();
                if (value.indexOf("PDF-1.") == 0) {
                    foundSig = true;
                    this._version = value.substring(4, 7);
                    info.setSigMatch(this._name);
                    break;
                }
                if (value.indexOf("!PS-Adobe-") == 0 && (n = value.indexOf("PDF-1.")) >= 11) {
                    foundSig = true;
                    this._version = value.substring(n + 4);
                    this._pdfACompliant = false;
                    info.setSigMatch(this._name);
                    break;
                }
            }
            this._pdfACompliant = false;
        }
        if (!foundSig) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("No PDF header", 0L));
            return false;
        }
        try {
            token = this._parser.getNext();
            String cmt = ((Comment)token).getValue();
            char[] cmtArray = cmt.toCharArray();
            int ctlcnt = 0;
            for (int i = 0; i < 4; ++i) {
                if (cmtArray[i] <= '\u007f') continue;
                ++ctlcnt;
            }
            if (ctlcnt < 4) {
                this._pdfACompliant = false;
            }
        }
        catch (Exception e) {
            this._pdfACompliant = false;
        }
        return true;
    }

    private long lastEOFOffset(RandomAccessFile raf) throws IOException {
        long offset = 0L;
        long flen = 0L;
        byte[] buf = null;
        long savepos = raf.getFilePointer();
        flen = raf.length();
        buf = new byte[(int)Math.min(1024L, flen)];
        offset = flen - (long)buf.length;
        raf.seek(offset);
        raf.read(buf);
        raf.seek(savepos);
        long eofpos = -1L;
        for (int i = buf.length - 4; i >= 1; --i) {
            if (buf[i] != 37 || buf[i - 1] != 37 || buf[i + 1] != 69 || buf[i + 2] != 79 || buf[i + 3] != 70) continue;
            eofpos = offset + (long)i - 1L;
            break;
        }
        return eofpos;
    }

    private long lastStartXrefOffset(RandomAccessFile raf, long eofOffset) throws IOException {
        long offset = 0L;
        long flen = 0L;
        byte[] buf = null;
        long savepos = raf.getFilePointer();
        flen = raf.length();
        if (eofOffset <= 0L) {
            eofOffset = flen;
        }
        if (eofOffset >= flen) {
            eofOffset = flen;
        }
        buf = new byte[(int)Math.min(128L, eofOffset)];
        offset = eofOffset - (long)buf.length;
        raf.seek(offset);
        raf.read(buf);
        raf.seek(savepos);
        long xrefpos = -1L;
        for (int i = buf.length - 9; i >= 0; --i) {
            if (buf[i] != 115 || buf[i + 1] != 116 || buf[i + 2] != 97 || buf[i + 3] != 114 || buf[i + 4] != 116 || buf[i + 5] != 120 || buf[i + 6] != 114 || buf[i + 7] != 101 || buf[i + 8] != 102) continue;
            xrefpos = offset + (long)i;
            break;
        }
        return xrefpos;
    }

    protected boolean findLastTrailer(RepInfo info) throws IOException {
        Token token = null;
        String value = null;
        this._eof = this.lastEOFOffset(this._raf);
        if (this._eof < 0L) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("No PDF trailer", this._raf.length()));
            return false;
        }
        if (this._raf.length() - this._eof > 7L) {
            this._pdfACompliant = false;
        }
        long startxrefoffset = this.lastStartXrefOffset(this._raf, this._eof);
        this._startxref = -1L;
        if (startxrefoffset >= 0L) {
            try {
                this._parser.seek(startxrefoffset);
            }
            catch (PdfException pdfException) {
                // empty catch block
            }
            while (true) {
                try {
                    token = this._parser.getNext();
                }
                catch (Exception e) {
                    continue;
                }
                if (token == null) break;
                if (!(token instanceof Keyword) || !"startxref".equals(value = ((Keyword)token).getValue())) continue;
                try {
                    token = this._parser.getNext();
                }
                catch (Exception e) {
                    break;
                }
                if (token == null || !(token instanceof Numeric)) continue;
                this._startxref = ((Numeric)token).getLongValue();
            }
        }
        if (this._startxref < 0L) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Missing startxref keyword or value", this._parser.getOffset()));
            return false;
        }
        return true;
    }

    protected boolean parseTrailer(RepInfo info, boolean prevOnly) throws IOException {
        Token token = null;
        String value = null;
        String invalidMsg = "Invalid cross-reference table";
        try {
            this._parser.seek(this._startxref);
            Token xref = this._parser.getNext();
            if (xref instanceof Keyword) {
                this._xrefIsStream = false;
                this._parser.getNext(Numeric.class, invalidMsg);
                this._objCount = ((Numeric)this._parser.getNext(Numeric.class, invalidMsg)).getIntegerValue();
                this._parser.seek(this._parser.getOffset() + (long)(this._objCount * 20));
            } else if (xref instanceof Numeric) {
                this._xrefIsStream = true;
                this._prevxref = -1L;
                PdfStream str = (PdfStream)this._parser.readObjectDef((Numeric)xref);
                PdfDictionary dict = str.getDict();
                this._docCatDictRef = (PdfIndirectObj)dict.get("Root");
                if (this._docCatDictRef == null) {
                    throw new PdfInvalidException("Root entry missing in cross-ref stream dictionary", this._parser.getOffset());
                }
                return true;
            }
            long trailer = -1L;
            while ((token = this._parser.getNext()) != null) {
                if (!(token instanceof Keyword) || !"trailer".equals(value = ((Keyword)token).getValue()) || !((token = this._parser.getNext()) instanceof DictionaryStart)) continue;
                trailer = this._parser.getOffset() - 7L;
                break;
            }
            if (trailer < 0L) {
                info.setWellFormed(false);
                info.setMessage(new ErrorMessage("No file trailer", this._parser.getOffset()));
                return false;
            }
            this._trailerDict = this._parser.readDictionary();
            this._prevxref = -1L;
            PdfObject obj = this._trailerDict.get("Prev");
            if (obj != null) {
                if (obj instanceof PdfSimpleObject && (token = ((PdfSimpleObject)obj).getToken()) instanceof Numeric) {
                    this._prevxref = ((Numeric)token).getLongValue();
                }
                if (this._prevxref < 0L) {
                    throw new PdfInvalidException("Invalid Prev offset in trailer dictionary", this._parser.getOffset());
                }
            }
            if (prevOnly) {
                return true;
            }
            obj = this._trailerDict.get("Size");
            if (obj != null) {
                this._numObjects = -1;
                if (obj instanceof PdfSimpleObject) {
                    token = ((PdfSimpleObject)obj).getToken();
                    if (token instanceof Numeric) {
                        this._numObjects = ((Numeric)token).getIntegerValue();
                    }
                    this._xref = new long[this._numObjects];
                }
                if (this._numObjects < 0) {
                    throw new PdfInvalidException("Invalid Size entry in trailer dictionary", this._parser.getOffset());
                }
                if (this._numObjects > 0x7FFFFF) {
                    this._pdfACompliant = false;
                }
            } else {
                throw new PdfInvalidException("Size entry missing in trailer dictionary", this._parser.getOffset());
            }
            this._docCatDictRef = (PdfIndirectObj)this._trailerDict.get("Root");
            if (this._docCatDictRef == null) {
                throw new PdfInvalidException("Root entry missing in trailer dictionary", this._parser.getOffset());
            }
            this._encryptDictRef = (PdfIndirectObj)this._trailerDict.get("Encrypt");
            this._encrypted = this._encryptDictRef != null;
            this._parser.setEncrypted(this._encrypted);
            PdfObject infoObj = this._trailerDict.get("Info");
            if (infoObj != null && !(infoObj instanceof PdfIndirectObj)) {
                throw new PdfInvalidException("Trailer dictionary Info key is not an indirect reference", this._parser.getOffset());
            }
            this._docInfoDictRef = (PdfIndirectObj)infoObj;
            obj = this._trailerDict.get("ID");
            if (obj != null) {
                String badID = "Invalid ID in trailer";
                if (obj instanceof PdfArray) {
                    String[] id = new String[2];
                    try {
                        PdfArray idArray = (PdfArray)obj;
                        Vector<PdfObject> idVec = idArray.getContent();
                        if (idVec.size() != 2) {
                            throw new PdfInvalidException(badID);
                        }
                        PdfSimpleObject idobj = (PdfSimpleObject)idVec.get(0);
                        id[0] = PdfModule.toHex(((StringValuedToken)idobj.getToken()).getRawBytes());
                        idobj = (PdfSimpleObject)idVec.get(1);
                        id[1] = PdfModule.toHex(((StringValuedToken)idobj.getToken()).getRawBytes());
                        this._idProperty = new Property("ID", PropertyType.STRING, PropertyArity.ARRAY, id);
                    }
                    catch (Exception e) {
                        throw new PdfInvalidException(badID);
                    }
                } else {
                    throw new PdfInvalidException(badID, this._parser.getOffset());
                }
            }
            if ((obj = this._trailerDict.get("XRefStm")) != null) {
                this._logger.warning("Hybrid cross-reference not yet implemented");
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        return true;
    }

    protected boolean readXRefInfo(RepInfo info) throws IOException {
        if (this._xrefIsStream) {
            return this.readXRefStreams(info);
        }
        return this.readXRefTables(info);
    }

    protected boolean readXRefStreams(RepInfo info) throws IOException {
        this._pdfACompliant = false;
        while (this._startxref > 0L) {
            try {
                this._parser.seek(this._startxref);
                PdfStream pstream = (PdfStream)this._parser.readObjectDef();
                int sObjNum = pstream.getObjNumber();
                CrossRefStream xstream = new CrossRefStream(pstream);
                if (!xstream.isValid()) {
                    return false;
                }
                xstream.initRead(this._raf);
                int xrefSize = xstream.getCrossRefTableSize();
                if (this._xref == null) {
                    this._xref = new long[xrefSize];
                    this._xref2 = new int[xrefSize][];
                }
                if (sObjNum < 0 || sObjNum >= xrefSize) {
                    throw new PdfMalformedException("Invalid object number in cross-reference stream", this._parser.getOffset());
                }
                this._xref[sObjNum] = this._startxref;
                this._startxref = xstream.getPrevXref();
                try {
                    while (xstream.readNextObject()) {
                        int objNum = xstream.getObjNum();
                        if (xstream.isObjCompressed()) {
                            this._xref[objNum] = -1L;
                            this._xref2[objNum] = new int[]{xstream.getContentStreamObjNum(), xstream.getContentStreamIndex()};
                            continue;
                        }
                        if (this._xref[objNum] != 0L) continue;
                        this._xref[objNum] = xstream.getOffset();
                    }
                    this._numFreeObjects += xstream.getFreeCount();
                }
                catch (IOException e) {
                    info.setWellFormed(false);
                    info.setMessage(new ErrorMessage("Malformed cross reference stream", this._parser.getOffset()));
                    return false;
                }
            }
            catch (PdfException e) {
                e.disparage(info);
                info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
                return e instanceof PdfInvalidException;
            }
        }
        return true;
    }

    protected boolean readXRefTables(RepInfo info) throws IOException {
        block10: {
            Token token = null;
            String badXref = "Malformed cross-reference table";
            try {
                this._parser.seek(this._startxref);
                token = this._parser.getNext();
                if (!(token instanceof Keyword)) break block10;
                while ((token = this._parser.getNext()) != null) {
                    int firstObj = 0;
                    if (token instanceof Numeric) {
                        firstObj = ((Numeric)token).getIntegerValue();
                        this._objCount = ((Numeric)this._parser.getNext()).getIntegerValue();
                        for (int i = 0; i < this._objCount; ++i) {
                            String keyval;
                            long offset = ((Numeric)this._parser.getNext(Numeric.class, badXref)).getLongValue();
                            this._parser.getNext();
                            if (this._parser.getWSString().length() > 1) {
                                this._pdfACompliant = false;
                            }
                            token = this._parser.getNext(Keyword.class, badXref);
                            if (this._parser.getWSString().length() > 1) {
                                this._pdfACompliant = false;
                            }
                            if ("n".equals(keyval = ((Keyword)token).getValue())) {
                                if (this._xref[firstObj + i] != 0L) continue;
                                this._xref[firstObj + i] = offset;
                                continue;
                            }
                            if ("f".equals(keyval)) {
                                ++this._numFreeObjects;
                                continue;
                            }
                            throw new PdfMalformedException("Illegal operator in xref table", this._parser.getOffset());
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (PdfException e) {
                e.disparage(info);
                info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
                return false;
            }
            catch (Exception e) {
                info.setValid(false);
                info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            }
        }
        return true;
    }

    protected boolean readDocCatalogDict(RepInfo info) throws IOException {
        String nocat = "No document catalog dictionary";
        Property p = null;
        this._docCatDict = null;
        this._docCatalogList = new ArrayList<Property>(2);
        if (this._docCatDictRef == null) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("No document catalog dictionary", 0L));
            return false;
        }
        try {
            this._docCatDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDictRef);
        }
        catch (Exception e) {
            this._logger.warning("Tried to cast non-dictionary to PdfDictionary");
            e.printStackTrace();
        }
        if (this._docCatDict == null) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("No document catalog dictionary", 0L));
            return false;
        }
        try {
            PdfObject lang;
            PdfObject viewPref = this._docCatDict.get("ViewerPreferences");
            viewPref = this.resolveIndirectObject(viewPref);
            if (viewPref instanceof PdfDictionary) {
                this._viewPrefDict = (PdfDictionary)viewPref;
                p = this.buildViewPrefProperty(this._viewPrefDict);
                this._docCatalogList.add(p);
            }
            String pLayoutText = "SinglePage";
            PdfObject pLayout = this.resolveIndirectObject(this._docCatDict.get("PageLayout"));
            if (pLayout instanceof PdfSimpleObject) {
                pLayoutText = ((PdfSimpleObject)pLayout).getStringValue();
            }
            p = new Property("PageLayout", PropertyType.STRING, pLayoutText);
            this._docCatalogList.add(p);
            String pModeText = "UseNone";
            PdfObject pMode = this.resolveIndirectObject(this._docCatDict.get("PageMode"));
            if (pMode instanceof PdfSimpleObject) {
                pModeText = ((PdfSimpleObject)pMode).getStringValue();
            }
            p = new Property("PageMode", PropertyType.STRING, pModeText);
            this._docCatalogList.add(p);
            PdfObject outlines = this.resolveIndirectObject(this._docCatDict.get("Outlines"));
            if (outlines instanceof PdfDictionary) {
                this._outlineDict = (PdfDictionary)outlines;
            }
            if ((lang = this.resolveIndirectObject(this._docCatDict.get("Lang"))) != null && lang instanceof PdfSimpleObject) {
                String langText = ((PdfSimpleObject)lang).getStringValue();
                p = new Property("Language", PropertyType.STRING, this._encrypted ? ENCRYPTED : langText);
                this._docCatalogList.add(p);
            }
            this._pagesDictRef = (PdfIndirectObj)this._docCatDict.get("Pages");
            this._pageLabelDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDict.get("PageLabels"));
            PdfObject vers = this.resolveIndirectObject(this._docCatDict.get("Version"));
            if (vers instanceof PdfSimpleObject) {
                String versString = ((PdfSimpleObject)vers).getStringValue();
                String infoVersString = this._version;
                try {
                    double ver = Double.parseDouble(versString);
                    double infoVer = Double.parseDouble(infoVersString);
                    if (ver != infoVer) {
                        info.setMessage(new InfoMessage("File header gives version as " + versString + ", but catalog dictionary gives version as " + infoVersString));
                    }
                    if (ver > infoVer) {
                        this._version = versString;
                    }
                }
                catch (NumberFormatException e) {
                    throw new PdfInvalidException("Invalid Version in document catalog");
                }
            }
            String badname = "Invalid Names dictionary";
            try {
                PdfDictionary namesDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDict.get("Names"));
                if (namesDict != null) {
                    PdfDictionary dDict;
                    PdfDictionary embeddedDict = (PdfDictionary)this.resolveIndirectObject(namesDict.get("EmbeddedFiles"));
                    if (embeddedDict != null) {
                        this._embeddedFiles = new NameTreeNode(this, null, embeddedDict);
                    }
                    if ((dDict = (PdfDictionary)this.resolveIndirectObject(namesDict.get("Dests"))) != null) {
                        this._destNames = new NameTreeNode(this, null, dDict);
                    }
                }
            }
            catch (ClassCastException ce) {
                this._logger.info("ClassCastException on names dictionary");
                throw new PdfInvalidException("Invalid Names dictionary");
            }
            catch (Exception e) {
                this._logger.info("Exception on names dictionary: " + e.getClass().getName());
                throw new PdfMalformedException("Invalid Names dictionary");
            }
            try {
                this._destsDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDict.get("Dests"));
            }
            catch (ClassCastException ce) {
                this._logger.info("ClassCastException on dests dictionary");
                throw new PdfInvalidException("Invalid Dests dictionary");
            }
            catch (Exception e) {
                this._logger.info("Exception on dests dictionary: " + e.getClass().getName());
                throw new PdfMalformedException("Invalid Dests dictionary");
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        catch (Exception e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage(e.toString(), this._parser.getOffset()));
            return false;
        }
        return true;
    }

    protected boolean readEncryptDict(RepInfo info) throws IOException {
        String filterText = "";
        String effText = null;
        if (this._encryptDictRef == null) {
            return true;
        }
        try {
            Token tok;
            Token tok2;
            Token tok3;
            PdfDictionary dict;
            this._encryptList = new ArrayList<Property>(6);
            this._encryptDict = dict = (PdfDictionary)this.resolveIndirectObject(this._encryptDictRef);
            PdfObject filter = dict.get("Filter");
            if (filter instanceof PdfSimpleObject && (tok3 = ((PdfSimpleObject)filter).getToken()) instanceof Name) {
                filterText = ((Name)tok3).getValue();
            }
            Property p = new Property("SecurityHandler", PropertyType.STRING, filterText);
            this._encryptList.add(p);
            if (filter instanceof PdfSimpleObject && (tok2 = ((PdfSimpleObject)filter).getToken()) instanceof Name) {
                effText = ((Name)tok2).getValue();
            }
            if (effText != null) {
                p = new Property("EFF", PropertyType.STRING, effText);
                this._encryptList.add(p);
            }
            int algValue = 0;
            PdfObject algorithm = dict.get("V");
            if (algorithm instanceof PdfSimpleObject && (tok = ((PdfSimpleObject)algorithm).getToken()) instanceof Numeric) {
                algValue = ((Numeric)tok).getIntegerValue();
                if (this._je != null && this._je.getShowRawFlag()) {
                    p = new Property("Algorithm", PropertyType.INTEGER, new Integer(algValue));
                } else {
                    try {
                        p = new Property("Algorithm", PropertyType.STRING, PdfStrings.ALGORITHM[algValue]);
                    }
                    catch (Exception e) {
                        throw new PdfInvalidException("Invalid algorithm value in encryption dictionary", this._parser.getOffset());
                    }
                }
                if (p != null) {
                    this._encryptList.add(p);
                }
            }
            int keyLen = 40;
            PdfObject length = dict.get("Length");
            if (length instanceof PdfSimpleObject) {
                Token tok4 = ((PdfSimpleObject)length).getToken();
                if (tok4 instanceof Numeric) {
                    keyLen = ((Numeric)tok4).getIntegerValue();
                }
                if (this._je != null) {
                    p = new Property("KeyLength", PropertyType.INTEGER, new Integer(keyLen));
                    this._encryptList.add(p);
                }
            }
            if ("Standard".equals(filterText)) {
                PdfObject uObj;
                PdfObject oObj;
                ArrayList<Property> stdList = new ArrayList<Property>(4);
                PdfObject flagObj = dict.get("P");
                PdfObject revObj = dict.get("R");
                int rev = 2;
                if (revObj instanceof PdfSimpleObject) {
                    rev = ((PdfSimpleObject)revObj).getIntValue();
                }
                if (flagObj instanceof PdfSimpleObject) {
                    int flags = ((PdfSimpleObject)flagObj).getIntValue();
                    String[] flagStrs = rev == 2 ? PdfStrings.USERPERMFLAGS2 : PdfStrings.USERPERMFLAGS3;
                    p = this.buildUserPermProperty(flags, flagStrs);
                    stdList.add(p);
                    stdList.add(new Property("Revision", PropertyType.INTEGER, new Integer(rev)));
                }
                if ((oObj = dict.get("O")) != null && oObj instanceof PdfSimpleObject) {
                    stdList.add(new Property("OwnerString", PropertyType.STRING, PdfModule.toHex(((PdfSimpleObject)oObj).getRawBytes())));
                }
                if ((uObj = dict.get("U")) != null && uObj instanceof PdfSimpleObject) {
                    stdList.add(new Property("UserString", PropertyType.STRING, PdfModule.toHex(((PdfSimpleObject)uObj).getRawBytes())));
                }
                this._encryptList.add(new Property("StandardSecurityHandler", PropertyType.PROPERTY, PropertyArity.LIST, stdList));
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        return true;
    }

    protected boolean readDocInfoDict(RepInfo info) throws IOException {
        if (this._docInfoDictRef == null) {
            return true;
        }
        this._docInfoList = new ArrayList<Property>(9);
        try {
            this._docInfoDict = (PdfDictionary)this.resolveIndirectObject(this._docInfoDictRef);
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Title", "Title");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Author", "Author");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Subject", "Subject");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Keywords", "Keywords");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Creator", "Creator");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Producer", "Producer");
            this.addDateProperty(this._docInfoDict, this._docInfoList, "CreationDate", "CreationDate");
            this.addDateProperty(this._docInfoDict, this._docInfoList, "ModDate", "ModDate");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Trapped", "Trapped");
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        catch (Exception e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Unexpected exception " + e.getClass().getName()));
        }
        return true;
    }

    protected boolean readDocumentTree(RepInfo info) throws IOException {
        try {
            if (this._pagesDictRef == null) {
                throw new PdfInvalidException("Document page tree not found");
            }
            PdfObject pagesObj = this.resolveIndirectObject(this._pagesDictRef);
            if (!(pagesObj instanceof PdfDictionary)) {
                throw new PdfMalformedException("Invalid page dictionary object");
            }
            PdfDictionary pagesDict = (PdfDictionary)pagesObj;
            this._docTreeRoot = new PageTreeNode(this, null, pagesDict);
            this._docTreeRoot.buildSubtree(true, 100);
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        catch (Exception e) {
            info.setMessage(new ErrorMessage(e.getClass().getName(), this._parser.getOffset()));
            info.setWellFormed(false);
            return false;
        }
        return true;
    }

    protected boolean readPageLabelTree(RepInfo info) {
        try {
            if (this._pageLabelDict != null) {
                this._pageLabelRoot = new PageLabelNode(this, null, this._pageLabelDict);
                this._pageLabelRoot.buildSubtree();
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        catch (Exception e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Unexpected exception " + e.getClass().getName()));
            return false;
        }
        return true;
    }

    protected boolean readXMPData(RepInfo info) {
        block8: {
            String badMetadata = "Invalid or ill-formed XMP metadata";
            try {
                PdfStream metadata = (PdfStream)this.resolveIndirectObject(this._docCatDict.get("Metadata"));
                if (metadata == null) {
                    return true;
                }
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XMLReader parser = factory.newSAXParser().getXMLReader();
                PdfXMPSource src = new PdfXMPSource(metadata, this.getFile());
                XMPHandler handler = new XMPHandler();
                parser.setContentHandler(handler);
                parser.setErrorHandler(handler);
                try {
                    parser.parse(src);
                    this._xmpProp = src.makeProperty();
                }
                catch (SAXException se) {
                    String msg = se.getMessage();
                    if (msg == null || !msg.startsWith("ENC=")) break block8;
                    String encoding = msg.substring(5);
                    try {
                        src = new PdfXMPSource(metadata, this.getFile(), encoding);
                        parser.parse(src);
                        this._xmpProp = src.makeProperty();
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new PdfInvalidException("Invalid or ill-formed XMP metadata");
                    }
                }
            }
            catch (PdfException e) {
                e.disparage(info);
                info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
                return e instanceof PdfInvalidException;
            }
            catch (Exception e) {
                info.setMessage(new ErrorMessage("Invalid or ill-formed XMP metadata", this._parser.getOffset()));
                info.setValid(false);
                return false;
            }
        }
        return true;
    }

    protected void findExternalStreams(RepInfo info) throws IOException {
        this._extStreamsList = new LinkedList<Property>();
        if (this._docTreeRoot == null) {
            return;
        }
        this._docTreeRoot.startWalk();
        try {
            PageObject page;
            while ((page = this._docTreeRoot.nextPageObject()) != null) {
                List streams = page.getContentStreams();
                if (streams == null) continue;
                ListIterator streamIter = streams.listIterator();
                while (streamIter.hasNext()) {
                    PdfStream stream = (PdfStream)streamIter.next();
                    String specStr = stream.getFileSpecification();
                    if (specStr == null) continue;
                    Property prop = new Property("File", PropertyType.STRING, specStr);
                    this._extStreamsList.add(prop);
                }
            }
        }
        catch (PdfMalformedException e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage(e.getMessage()));
        }
        catch (Exception e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Unexpected exception " + e.getClass().getName()));
        }
    }

    protected boolean findFilters(RepInfo info) throws IOException {
        this._filtersList = new LinkedList<Property>();
        if (this._docTreeRoot == null) {
            return false;
        }
        this._docTreeRoot.startWalk();
        try {
            PageObject page;
            while ((page = this._docTreeRoot.nextPageObject()) != null) {
                List streams = page.getContentStreams();
                if (streams == null) continue;
                ListIterator streamIter = streams.listIterator();
                while (streamIter.hasNext()) {
                    PdfStream stream = (PdfStream)streamIter.next();
                    Filter[] filters = stream.getFilters();
                    this.extractFilters(filters, stream);
                }
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return e instanceof PdfInvalidException;
        }
        return true;
    }

    protected String extractFilters(Filter[] filters, PdfStream stream) {
        int len = filters.length;
        if (len == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String cname;
            Filter filt = filters[i];
            String fname = filt.getFilterName();
            buf.append(fname);
            if ("Crypt".equals(fname) && (cname = filt.getNameParam()) != null) {
                buf.append(":" + cname);
            }
            if (i >= len - 1) continue;
            buf.append(' ');
        }
        String filterStr = buf.toString();
        boolean unique = true;
        for (Property p : this._filtersList) {
            String s = (String)p.getValue();
            if (!s.equals(filterStr)) continue;
            unique = false;
            break;
        }
        if (filterStr != null && unique) {
            Property prop = new Property("FilterPipeline", PropertyType.STRING, filterStr);
            this._filtersList.add(prop);
        }
        return filterStr;
    }

    protected void findImages(RepInfo info) throws IOException {
        this._imagesList = new LinkedList<Property>();
        this._docTreeRoot.startWalk();
        try {
            PageObject page;
            while ((page = this._docTreeRoot.nextPageObject()) != null) {
                PdfDictionary xo;
                PdfDictionary rsrc = page.getResources();
                if (rsrc == null || (xo = (PdfDictionary)this.resolveIndirectObject(rsrc.get("XObject"))) == null) continue;
                Iterator iter = xo.iterator();
                while (iter.hasNext()) {
                    PdfSimpleObject id;
                    PdfSimpleObject nam;
                    PdfSimpleObject intrp;
                    PdfArray dcd;
                    PdfSimpleObject imgmsk;
                    PdfSimpleObject intent;
                    PdfSimpleObject bpc;
                    PdfSimpleObject subtype;
                    this._logger.info("Getting image");
                    PdfDictionary xobdict = null;
                    PdfObject xob = this.resolveIndirectObject((PdfObject)iter.next());
                    if (xob instanceof PdfStream) {
                        xobdict = ((PdfStream)xob).getDict();
                    }
                    if (xobdict == null || !"Image".equals((subtype = (PdfSimpleObject)xobdict.get("Subtype")).getStringValue())) continue;
                    this._logger.info("Image XObject");
                    ArrayList<Property> imgList = new ArrayList<Property>(10);
                    Property prop = new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, imgList);
                    NisoImageMetadata niso = new NisoImageMetadata();
                    imgList.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, niso));
                    niso.setMimeType("application/pdf");
                    PdfObject widthBase = xobdict.get("Width");
                    PdfSimpleObject widObj = (PdfSimpleObject)this.resolveIndirectObject(widthBase);
                    niso.setImageWidth(widObj.getIntValue());
                    PdfObject heightBase = xobdict.get("Height");
                    PdfSimpleObject htObj = (PdfSimpleObject)this.resolveIndirectObject(heightBase);
                    niso.setImageLength(htObj.getIntValue());
                    Filter[] filters = ((PdfStream)xob).getFilters();
                    String filt = this.extractFilters(filters, (PdfStream)xob);
                    if (filt != null) {
                        int nisoFilt = this.nameToNiso(filt, compressionStrings, compressionValues);
                        if (nisoFilt >= 0) {
                            PdfObject parms = xobdict.get("DecodeParms");
                            if (parms != null) {
                                PdfSimpleObject kobj = null;
                                if (parms instanceof PdfDictionary) {
                                    kobj = (PdfSimpleObject)((PdfDictionary)parms).get("K");
                                }
                                if (kobj != null) {
                                    int k = kobj.getIntValue();
                                    if (k < 0) {
                                        nisoFilt = 4;
                                    } else if (k > 0) {
                                        nisoFilt = 3;
                                    }
                                }
                            }
                            niso.setCompressionScheme(nisoFilt);
                        } else {
                            imgList.add(new Property("Filter", PropertyType.STRING, filt));
                        }
                    } else {
                        niso.setCompressionScheme(1);
                    }
                    PdfObject colorSpc = xobdict.get("ColorSpace");
                    if (colorSpc != null) {
                        String colorName = null;
                        if (colorSpc instanceof PdfSimpleObject) {
                            colorName = ((PdfSimpleObject)colorSpc).getStringValue();
                        } else if (colorSpc instanceof PdfArray) {
                            Vector<PdfObject> vec = ((PdfArray)colorSpc).getContent();
                            PdfSimpleObject fam = (PdfSimpleObject)vec.elementAt(0);
                            colorName = fam.getStringValue();
                        }
                        if (colorName != null) {
                            int nisoSpace = this.nameToNiso(colorName, colorSpaceStrings, colorSpaceValues);
                            if (nisoSpace >= 0) {
                                niso.setColorSpace(nisoSpace);
                            } else {
                                imgList.add(new Property("ColorSpace", PropertyType.STRING, colorName));
                            }
                        }
                    }
                    if ((bpc = (PdfSimpleObject)xobdict.get("BitsPerComponent")) != null) {
                        niso.setBitsPerSample(new int[]{bpc.getIntValue()});
                    }
                    if ((intent = (PdfSimpleObject)xobdict.get("Intent")) != null) {
                        imgList.add(new Property("Intent", PropertyType.STRING, intent.getStringValue()));
                    }
                    if ((imgmsk = (PdfSimpleObject)xobdict.get("ImageMask")) != null) {
                        boolean b = imgmsk.isTrue();
                        imgList.add(new Property("ImageMask", PropertyType.BOOLEAN, new Boolean(b)));
                    }
                    if ((dcd = (PdfArray)xobdict.get("Decode")) != null) {
                        Vector<PdfObject> dcdvec = dcd.getContent();
                        ArrayList<Integer> dcdlst = new ArrayList<Integer>(dcdvec.size());
                        for (PdfSimpleObject pdfSimpleObject : dcdvec) {
                            dcdlst.add(new Integer(pdfSimpleObject.getIntValue()));
                        }
                        imgList.add(new Property("Decode", PropertyType.INTEGER, PropertyArity.LIST, dcdlst));
                    }
                    if ((intrp = (PdfSimpleObject)xobdict.get("Interpolate")) != null) {
                        boolean b = intrp.isTrue();
                        imgList.add(new Property("Interpolate", PropertyType.BOOLEAN, new Boolean(b)));
                    }
                    if ((nam = (PdfSimpleObject)xobdict.get("Name")) != null) {
                        imgList.add(new Property("Name", PropertyType.STRING, nam.getStringValue()));
                    }
                    if ((id = (PdfSimpleObject)this.resolveIndirectObject(xobdict.get("ID"))) != null) {
                        String string = PdfModule.toHex(id.getStringValue());
                        imgList.add(new Property("ID", PropertyType.STRING, string));
                    }
                    this._imagesList.add(prop);
                }
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
        }
        catch (Exception e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Unexpected exception " + e.getClass().getName()));
        }
    }

    protected int nameToNiso(String name, String[] nameArray, int[] valArray) {
        for (int i = 0; i < nameArray.length; ++i) {
            if (!nameArray[i].equals(name)) continue;
            return valArray[i];
        }
        return -1;
    }

    protected void findFonts(RepInfo info) throws IOException {
        this._type0FontsMap = new HashMap<Integer, PdfObject>();
        this._type1FontsMap = new HashMap<Integer, PdfObject>();
        this._trueTypeFontsMap = new HashMap<Integer, PdfObject>();
        this._mmFontsMap = new HashMap<Integer, PdfObject>();
        this._type3FontsMap = new HashMap<Integer, PdfObject>();
        this._cid0FontsMap = new HashMap<Integer, PdfObject>();
        this._cid2FontsMap = new HashMap<Integer, PdfObject>();
        try {
            DocNode node;
            this._docTreeRoot.startWalk();
            while ((node = this._docTreeRoot.nextDocNode()) != null) {
                PdfDictionary fonts = null;
                fonts = node.getFontResources();
                if (fonts == null) continue;
                Iterator fontIter = fonts.iterator();
                while (fontIter.hasNext()) {
                    PdfObject fontRef = (PdfObject)fontIter.next();
                    PdfObject font = this.resolveIndirectObject(fontRef);
                    if (!(font instanceof PdfDictionary)) {
                        info.setWellFormed(false);
                        info.setMessage(new ErrorMessage("Expected dictionary for font entry in page resource", this._parser.getOffset()));
                        return;
                    }
                    this.addFontToMap((PdfDictionary)font);
                    if (this._skippedFontsReported || this._showFonts || this._verbosity == 1) continue;
                    info.setMessage(new InfoMessage(fontsSkippedString));
                    this._skippedFontsReported = true;
                }
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return;
        }
        catch (Exception e) {
            this._logger.warning("PdfModule.findFonts: " + e.toString());
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Unexpected error in findFonts", e.toString(), this._parser.getOffset()));
            return;
        }
    }

    protected String addFontToMap(PdfDictionary font) {
        if (++this._nFonts > this.maxFonts) {
            return null;
        }
        String subtypeStr = null;
        try {
            PdfSimpleObject subtype = (PdfSimpleObject)font.get("Subtype");
            subtypeStr = subtype.getStringValue();
            if ("Type0".equals(subtypeStr)) {
                this._type0FontsMap.put(new Integer(font.getObjNumber()), font);
                PdfObject desc0 = font.get("DescendantFonts");
                PdfArray descendants = (PdfArray)this.resolveIndirectObject(desc0);
                Vector<PdfObject> subfonts = descendants.getContent();
                for (PdfObject subfont : subfonts) {
                    subfont = this.resolveIndirectObject(subfont);
                    this.addFontToMap((PdfDictionary)subfont);
                }
            } else if ("Type1".equals(subtypeStr)) {
                this._type1FontsMap.put(new Integer(font.getObjNumber()), font);
            } else if ("MMType1".equals(subtypeStr)) {
                this._mmFontsMap.put(new Integer(font.getObjNumber()), font);
            } else if ("Type3".equals(subtypeStr)) {
                this._type3FontsMap.put(new Integer(font.getObjNumber()), font);
            } else if ("TrueType".equals(subtypeStr)) {
                this._trueTypeFontsMap.put(new Integer(font.getObjNumber()), font);
            } else if ("CIDFontType0".equals(subtypeStr)) {
                this._cid0FontsMap.put(new Integer(font.getObjNumber()), font);
            } else if ("CIDFontType2".equals(subtypeStr)) {
                this._cid2FontsMap.put(new Integer(font.getObjNumber()), font);
            }
            return subtypeStr;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String toHex(String s) {
        StringBuffer buffer = new StringBuffer("0x");
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String h = Integer.toHexString(s.charAt(i));
            if (h.length() < 2) {
                buffer.append("0");
            }
            buffer.append(h);
        }
        return buffer.toString();
    }

    protected static String toHex(Vector<Integer> v) {
        StringBuffer buffer = new StringBuffer("0x");
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            int hdigit = v.elementAt(i);
            String h = Integer.toHexString(hdigit);
            if (h.length() < 2) {
                buffer.append("0");
            }
            buffer.append(h);
        }
        return buffer.toString();
    }

    public PdfObject resolveIndirectObject(PdfObject obj) throws PdfException, IOException {
        if (obj instanceof PdfIndirectObj) {
            int objIndex = ((PdfIndirectObj)obj).getObjNumber();
            return this.getObject(objIndex, 30);
        }
        return obj;
    }

    protected PdfObject getObject(int objIndex, int recGuard) throws PdfException, IOException {
        if (recGuard <= 0) {
            throw new PdfMalformedException("Improper nesting of object streams");
        }
        String nogood = "Invalid object number or object stream";
        long offset = this._xref[objIndex];
        if (offset == 0L) {
            return null;
        }
        if (offset < 0L) {
            try {
                int objStreamIndex = this._xref2[objIndex][0];
                ObjectStream ostrm = null;
                if (objStreamIndex == this._cachedStreamIndex) {
                    ostrm = this._cachedObjectStream;
                    if (ostrm.isValid()) {
                        ostrm.readIndex();
                    }
                } else {
                    PdfObject streamObj = this.resolveIndirectObject(this.getObject(objStreamIndex, recGuard - 1));
                    if (streamObj instanceof PdfStream) {
                        ostrm = new ObjectStream((PdfStream)streamObj, this._raf);
                        if (ostrm.isValid()) {
                            ostrm.readIndex();
                            this._cachedObjectStream = ostrm;
                            this._cachedStreamIndex = objStreamIndex;
                        } else {
                            throw new PdfMalformedException("Invalid object number or object stream");
                        }
                    }
                }
                return ostrm.getObject(objIndex);
            }
            catch (Exception e) {
                this._logger.info(e.getMessage());
                if (e instanceof ZipException) {
                    throw new PdfMalformedException("Compression method is invalid or unknown to JHOVE");
                }
                throw new PdfMalformedException("Invalid object number or object stream");
            }
        }
        this._parser.seek(offset);
        PdfObject obj = this._parser.readObjectDef();
        obj.setObjNumber(objIndex);
        return obj;
    }

    public RandomAccessFile getFile() {
        return this._raf;
    }

    public PdfDictionary getCatalogDict() {
        return this._docCatDict;
    }

    public PdfDictionary getTrailerDict() {
        return this._trailerDict;
    }

    public PdfDictionary getViewPrefDict() {
        return this._viewPrefDict;
    }

    public PdfDictionary getOutlineDict() {
        return this._outlineDict;
    }

    public Map<Integer, PdfObject> getFontMap(int selector) {
        switch (selector) {
            case 1: {
                return this._type0FontsMap;
            }
            case 2: {
                return this._type1FontsMap;
            }
            case 3: {
                return this._mmFontsMap;
            }
            case 4: {
                return this._type3FontsMap;
            }
            case 5: {
                return this._mmFontsMap;
            }
            case 6: {
                return this._cid0FontsMap;
            }
            case 7: {
                return this._cid2FontsMap;
            }
        }
        return null;
    }

    public List<Map<Integer, PdfObject>> getFontMaps() {
        ArrayList<Map<Integer, PdfObject>> lst = new ArrayList<Map<Integer, PdfObject>>(7);
        lst.add(this._type0FontsMap);
        lst.add(this._type1FontsMap);
        lst.add(this._mmFontsMap);
        lst.add(this._type3FontsMap);
        lst.add(this._trueTypeFontsMap);
        lst.add(this._cid0FontsMap);
        lst.add(this._cid2FontsMap);
        return lst;
    }

    public NameTreeNode getEmbeddedFiles() {
        return this._embeddedFiles;
    }

    protected void addFontsProperty(List<Property> metadataList) {
        LinkedList<Property> fontTypesList = new LinkedList<Property>();
        Property fontp = null;
        if (this._type0FontsMap != null && !this._type0FontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("Type0", this._type0FontsMap, 1);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._type1FontsMap != null && !this._type1FontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("Type1", this._type1FontsMap, 2);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._trueTypeFontsMap != null && !this._trueTypeFontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("TrueType", this._trueTypeFontsMap, 3);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._type3FontsMap != null && !this._type3FontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("Type3", this._type3FontsMap, 4);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._mmFontsMap != null && !this._mmFontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("MMType1", this._mmFontsMap, 5);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._cid0FontsMap != null && !this._cid0FontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("CIDFontType0", this._cid0FontsMap, 6);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._cid2FontsMap != null && !this._cid2FontsMap.isEmpty()) {
            try {
                fontp = this.buildFontProperty("CIDFontType2", this._cid2FontsMap, 7);
                fontTypesList.add(fontp);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (fontTypesList.size() > 0) {
            metadataList.add(new Property("Fonts", PropertyType.PROPERTY, PropertyArity.LIST, fontTypesList));
        }
    }

    protected void addPagesProperty(List<Property> metadataList, RepInfo info) {
        this._pagesList = new LinkedList<Property>();
        this._pageSeqMap = new HashMap<Integer, Integer>(500);
        try {
            PageObject page;
            this._docTreeRoot.startWalk();
            int pageIndex = 0;
            if (this._pageLabelRoot != null) {
                if (!this._pageLabelRoot.findNextKeyValue()) {
                    throw new PdfMalformedException("Bad page labels");
                }
                this._pageLabelRoot.findNextKeyValue();
            }
            while ((page = this._docTreeRoot.nextPageObject()) != null) {
                this._pageSeqMap.put(new Integer(page.getDict().getObjNumber()), new Integer(pageIndex + 1));
            }
            this._docTreeRoot.startWalk();
            while ((page = this._docTreeRoot.nextPageObject()) != null) {
                Property p = this.buildPageProperty(page, pageIndex++, info);
                this._pagesList.add(p);
            }
            if (this._showPages || this._verbosity == 1) {
                Property prop = new Property("Pages", PropertyType.PROPERTY, PropertyArity.LIST, this._pagesList);
                metadataList.add(prop);
            } else {
                if (!this._skippedPagesReported) {
                    info.setMessage(new InfoMessage(pagesSkippedString));
                }
                this._skippedPagesReported = true;
            }
        }
        catch (PdfException e) {
            e.disparage(info);
            info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
            return;
        }
    }

    protected Property buildPageProperty(PageObject page, int idx, RepInfo info) throws PdfException {
        ArrayList<Property> pagePropList = new ArrayList<Property>(4);
        try {
            int[] nominalNum = new int[1];
            Property plProp = this.buildPageLabelProperty(page, idx, nominalNum);
            if (plProp != null) {
                pagePropList.add(plProp);
            }
            if (plProp == null || nominalNum[0] != idx + 1) {
                pagePropList.add(new Property("Sequence", PropertyType.INTEGER, new Integer(idx + 1)));
            }
        }
        catch (PdfException e) {
            throw e;
        }
        catch (Exception f) {
            throw new PdfMalformedException("Invalid page label info");
        }
        try {
            LinkedList<Property> annotsList = new LinkedList<Property>();
            PdfArray annots = page.getAnnotations();
            if (annots != null) {
                Vector<PdfObject> contents = annots.getContent();
                for (int i = 0; i < contents.size(); ++i) {
                    PdfObject annot = this.resolveIndirectObject(contents.elementAt(i));
                    if (!(annot instanceof PdfDictionary)) {
                        throw new PdfInvalidException("Annotation object is not a dictionary");
                    }
                    annotsList.add(this.buildAnnotProperty((PdfDictionary)annot, info));
                }
                if (!annotsList.isEmpty()) {
                    if (this._showAnnotations || this._verbosity == 1) {
                        Property annotProp = new Property("Annotations", PropertyType.PROPERTY, PropertyArity.LIST, annotsList);
                        pagePropList.add(annotProp);
                    } else if (!this._skippedAnnotationsReported) {
                        info.setMessage(new InfoMessage(annotationsSkippedString));
                        this._skippedAnnotationsReported = true;
                    }
                }
            }
        }
        catch (PdfException e) {
            throw e;
        }
        catch (Exception f) {
            throw new PdfMalformedException("Invalid Annotation list");
        }
        try {
            PdfObject thumb;
            PdfArray vp;
            PdfSimpleObject uu;
            PdfSimpleObject rot = (PdfSimpleObject)page.get("Rotate", true);
            if (rot != null && rot.getIntValue() != 0) {
                pagePropList.add(new Property("Rotate", PropertyType.INTEGER, new Integer(rot.getIntValue())));
            }
            if ((uu = (PdfSimpleObject)page.get("UserUnit", false)) != null) {
                pagePropList.add(new Property("UserUnit", PropertyType.DOUBLE, new Double(rot.getDoubleValue())));
            }
            if ((vp = (PdfArray)page.get("VP", false)) != null) {
                Vector<PdfObject> vpv = vp.getContent();
                Iterator<PdfObject> iter = vpv.iterator();
                ArrayList<Property> vplist = new ArrayList<Property>(vpv.size());
                while (iter.hasNext()) {
                    PdfDictionary vpd = (PdfDictionary)this.resolveIndirectObject(iter.next());
                    PdfObject vpdbb = vpd.get("BBox");
                    ArrayList<Property> vpPropList = new ArrayList<Property>();
                    vpPropList.add(this.makeRectProperty((PdfArray)this.resolveIndirectObject(vpdbb), "BBox"));
                    PdfObject meas = vpd.get("Measure");
                    if (meas instanceof PdfDictionary) {
                        vpPropList.add(this.buildMeasureProperty((PdfDictionary)meas));
                    }
                    vplist.add(new Property("Viewport", PropertyType.PROPERTY, PropertyArity.LIST, vpPropList));
                }
                pagePropList.add(new Property("Viewports", PropertyType.PROPERTY, PropertyArity.LIST, vplist));
            }
            if ((thumb = page.get("Thumb", false)) != null) {
                pagePropList.add(new Property("Thumb", PropertyType.BOOLEAN, Boolean.TRUE));
            }
            return new Property("Page", PropertyType.PROPERTY, PropertyArity.LIST, pagePropList);
        }
        catch (Exception f) {
            throw new PdfMalformedException("Invalid page dictionary");
        }
    }

    protected Property buildPageLabelProperty(PageObject page, int pageIndex, int[] nomNumRef) throws PdfException {
        if (this._pageLabelRoot == null) {
            return null;
        }
        int curFirstPage = this._pageLabelRoot.getPrevKey();
        int nextFirstPage = this._pageLabelRoot.getCurrentKey();
        try {
            PdfSimpleObject firstPageObj;
            int nominalPage;
            if (pageIndex >= nextFirstPage) {
                this._pageLabelRoot.findNextKeyValue();
                curFirstPage = nextFirstPage;
            }
            PdfDictionary pageLabelDict = (PdfDictionary)this.resolveIndirectObject(this._pageLabelRoot.getPrevValue());
            StringBuffer labelText = new StringBuffer();
            PdfSimpleObject prefixObj = (PdfSimpleObject)pageLabelDict.get("P");
            if (prefixObj != null) {
                labelText.append(prefixObj.getStringValue());
            }
            if ((nominalPage = (firstPageObj = (PdfSimpleObject)pageLabelDict.get("St")) != null ? pageIndex - curFirstPage + firstPageObj.getIntValue() : pageIndex - curFirstPage + 1) <= 0) {
                throw new PdfInvalidException("Invalid page label sequence");
            }
            nomNumRef[0] = nominalPage;
            PdfSimpleObject numStyleObj = (PdfSimpleObject)pageLabelDict.get("S");
            String numStyle = numStyleObj == null ? null : numStyleObj.getStringValue();
            if ("D".equals(numStyle)) {
                labelText.append(nominalPage);
            } else if ("R".equals(numStyle)) {
                labelText.append(PageLabelNode.intToRoman(nominalPage, true));
            } else if ("r".equals(numStyle)) {
                labelText.append(PageLabelNode.intToRoman(nominalPage, false));
            } else if ("A".equals(numStyle)) {
                labelText.append(PageLabelNode.intToBase26(nominalPage, true));
            } else if ("a".equals(numStyle)) {
                labelText.append(PageLabelNode.intToBase26(nominalPage, false));
            }
            if (labelText.length() == 0) {
                labelText.append("[empty]");
            }
            return new Property("Label", PropertyType.STRING, labelText.toString());
        }
        catch (Exception e) {
            throw new PdfMalformedException("Problem with page label structure");
        }
    }

    protected Property buildMeasureProperty(PdfDictionary meas) {
        PdfSimpleObject xobj;
        int i;
        double[] x;
        Vector<PdfObject> v;
        ArrayList<Property> plist = new ArrayList<Property>();
        PdfObject itemObj = meas.get("Subtype");
        if (itemObj instanceof PdfSimpleObject) {
            plist.add(new Property("Subtype", PropertyType.STRING, ((PdfSimpleObject)itemObj).getStringValue()));
        }
        if ((itemObj = meas.get("R")) instanceof PdfSimpleObject) {
            plist.add(new Property("Ratio", PropertyType.STRING, ((PdfSimpleObject)itemObj).getStringValue()));
        }
        if ((itemObj = meas.get("X")) instanceof PdfArray) {
            v = ((PdfArray)itemObj).getContent();
            x = new double[v.size()];
            for (i = 0; i < v.size(); ++i) {
                xobj = (PdfSimpleObject)v.elementAt(i);
                x[i] = xobj.getDoubleValue();
            }
            plist.add(new Property("X", PropertyType.DOUBLE, PropertyArity.ARRAY, x));
        }
        if ((itemObj = meas.get("Y")) instanceof PdfArray) {
            v = ((PdfArray)itemObj).getContent();
            x = new double[v.size()];
            for (i = 0; i < v.size(); ++i) {
                xobj = (PdfSimpleObject)v.elementAt(i);
                x[i] = xobj.getDoubleValue();
            }
            plist.add(new Property("Y", PropertyType.DOUBLE, PropertyArity.ARRAY, x));
        }
        if ((itemObj = meas.get("D")) instanceof PdfArray) {
            v = ((PdfArray)itemObj).getContent();
            x = new double[v.size()];
            for (i = 0; i < v.size(); ++i) {
                xobj = (PdfSimpleObject)v.elementAt(i);
                x[i] = xobj.getDoubleValue();
            }
            plist.add(new Property("Distance", PropertyType.DOUBLE, PropertyArity.ARRAY, x));
        }
        if ((itemObj = meas.get("A")) instanceof PdfArray) {
            v = ((PdfArray)itemObj).getContent();
            x = new double[v.size()];
            for (i = 0; i < v.size(); ++i) {
                xobj = (PdfSimpleObject)v.elementAt(i);
                x[i] = xobj.getDoubleValue();
            }
            plist.add(new Property("Area", PropertyType.DOUBLE, PropertyArity.ARRAY, x));
        }
        return new Property("Measure", PropertyType.PROPERTY, PropertyArity.LIST, plist);
    }

    protected Property buildAnnotProperty(PdfDictionary annot, RepInfo info) throws PdfException {
        ArrayList<Property> propList = new ArrayList<Property>(7);
        try {
            String type;
            int flagValue;
            Property flagProp;
            PdfObject itemObj = annot.get("Subtype");
            propList.add(new Property("Subtype", PropertyType.STRING, ((PdfSimpleObject)itemObj).getStringValue()));
            itemObj = annot.get("Contents");
            if (itemObj != null) {
                propList.add(new Property("Contents", PropertyType.STRING, this._encrypted ? ENCRYPTED : ((PdfSimpleObject)itemObj).getStringValue()));
            }
            itemObj = annot.get("Rect");
            propList.add(this.makeRectProperty((PdfArray)this.resolveIndirectObject(itemObj), "Rect"));
            itemObj = annot.get("NM");
            if (itemObj != null) {
                propList.add(new Property("Name", PropertyType.STRING, ((PdfSimpleObject)itemObj).getStringValue()));
            }
            if ((itemObj = annot.get("M")) != null) {
                Literal lastModLit = (Literal)((PdfSimpleObject)itemObj).getToken();
                Property dateProp = new Property("LastModified", PropertyType.STRING, lastModLit.getValue());
                propList.add(dateProp);
            }
            if ((itemObj = annot.get("F")) != null && (flagProp = this.buildBitmaskProperty(flagValue = ((PdfSimpleObject)itemObj).getIntValue(), "Flags", PdfStrings.ANNOTATIONFLAGS, "No flags set")) != null) {
                propList.add(flagProp);
            }
            if ((itemObj = annot.get("AP")) != null) {
                propList.add(new Property("AppearanceDictionary", PropertyType.BOOLEAN, Boolean.TRUE));
            }
            if ((itemObj = annot.get("A")) != null) {
                PdfObject destObj;
                this._actionsExist = true;
                PdfSimpleObject actionSubtype = (PdfSimpleObject)((PdfDictionary)(itemObj = this.resolveIndirectObject(itemObj))).get("S");
                if (actionSubtype == null) {
                    throw new PdfMalformedException("Annotation dictionary missing required type (S) entry");
                }
                if ("GoTo".equals(actionSubtype.getStringValue()) && (destObj = ((PdfDictionary)itemObj).get("D")) != null) {
                    this.addDestination(destObj, "ActionDest", propList, info);
                }
            }
            if ((itemObj = annot.get("Dest")) != null) {
                this.addDestination(itemObj, "Destination", propList, info);
            }
            if ((itemObj = annot.get("RT")) instanceof PdfSimpleObject) {
                type = ((PdfSimpleObject)itemObj).getStringValue();
                propList.add(new Property("ReplyType", PropertyType.STRING, type));
            }
            if ((itemObj = annot.get("IT")) instanceof PdfSimpleObject) {
                type = ((PdfSimpleObject)itemObj).getStringValue();
                propList.add(new Property("Intent", PropertyType.STRING, type));
            }
            if ((itemObj = annot.get("CL")) instanceof PdfArray) {
                Vector<PdfObject> clData = ((PdfArray)itemObj).getContent();
                Iterator<PdfObject> iter = clData.iterator();
                ArrayList<Double> clList = new ArrayList<Double>(6);
                while (iter.hasNext()) {
                    PdfSimpleObject clItem = (PdfSimpleObject)iter.next();
                    clList.add(new Double(clItem.getDoubleValue()));
                }
                propList.add(new Property("CalloutLine", PropertyType.DOUBLE, PropertyArity.LIST, clList));
            }
            return new Property("Annotation", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        }
        catch (PdfMalformedException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new PdfMalformedException("Invalid Annotation property");
        }
    }

    protected void addDestination(PdfObject itemObj, String propName, List<Property> propList, RepInfo info) {
        try {
            Destination dest = new Destination(itemObj, this, false);
            if (dest.isIndirect()) {
                if (!this._encrypted) {
                    int pageObjNum = this.resolveIndirectDest(dest.getIndirectDest());
                    if (pageObjNum == -1) {
                        propList.add(new Property(propName, PropertyType.STRING, "External"));
                    } else {
                        propList.add(new Property(propName, PropertyType.INTEGER, new Integer(pageObjNum)));
                    }
                }
            } else {
                if (dest.getPageDest() == null) {
                    return;
                }
                int pageObjNum = dest.getPageDestObjNumber();
                Integer destPg = this._pageSeqMap.get(new Integer(pageObjNum));
                if (destPg != null) {
                    propList.add(new Property(propName, PropertyType.INTEGER, destPg));
                }
            }
        }
        catch (Exception e) {
            String msg = e.getClass().getName();
            String msg1 = e.getMessage();
            if (msg1 != null) {
                msg = msg + ": " + msg1;
            }
            propList.add(new Property(propName, PropertyType.STRING, "null"));
            info.setMessage(new ErrorMessage(msg, this._parser.getOffset()));
            info.setValid(false);
        }
    }

    protected Property buildFontProperty(String name, Map map, int fontType) {
        LinkedList<Property> fontList = new LinkedList<Property>();
        for (PdfDictionary dict : map.values()) {
            List<Property> fontPropList = this.oneFontPropList(dict, fontType);
            Property fProp = new Property("Font", PropertyType.PROPERTY, PropertyArity.LIST, fontPropList);
            fontList.add(fProp);
        }
        return new Property(name, PropertyType.PROPERTY, PropertyArity.LIST, fontList);
    }

    protected List<Property> oneFontPropList(PdfDictionary dict, int fontType) {
        PdfObject toUniObj;
        PdfObject rsrc;
        Property prop;
        LinkedList<Property> fontPropList = new LinkedList<Property>();
        if (fontType == 2 || fontType == 4 || fontType == 5 || fontType == 3) {
            PdfObject tempObj = dict.get("Name");
            PdfSimpleObject nameObj = null;
            if (tempObj instanceof PdfSimpleObject) {
                nameObj = (PdfSimpleObject)tempObj;
            } else if (tempObj instanceof PdfIndirectObj) {
                nameObj = (PdfSimpleObject)((PdfIndirectObj)tempObj).getObject();
            }
            if (nameObj != null) {
                String nameStr = nameObj.getStringValue();
                prop = new Property("Name", PropertyType.STRING, nameStr);
                fontPropList.add(prop);
            }
        }
        String baseStr = null;
        if (fontType != 4) {
            PdfObject tempObj = dict.get("BaseFont");
            PdfSimpleObject baseFontObj = null;
            if (tempObj instanceof PdfSimpleObject) {
                baseFontObj = (PdfSimpleObject)tempObj;
            } else if (tempObj instanceof PdfIndirectObj) {
                baseFontObj = (PdfSimpleObject)((PdfIndirectObj)tempObj).getObject();
            }
            if (baseFontObj != null) {
                baseStr = baseFontObj.getStringValue();
                prop = new Property("BaseFont", PropertyType.STRING, baseStr);
                fontPropList.add(prop);
            }
        }
        if (fontType == 6 || fontType == 7) {
            PdfObject elCid = dict.get("CIDSystemInfo");
            try {
                elCid = this.resolveIndirectObject(elCid);
            }
            catch (Exception baseFontObj) {
                // empty catch block
            }
            if (elCid instanceof PdfDictionary) {
                prop = this.buildCIDInfoProperty((PdfDictionary)elCid);
                fontPropList.add(prop);
            }
        }
        if ((fontType == 2 || fontType == 3 || fontType == 5) && this.isFontSubset(baseStr)) {
            prop = new Property("FontSubset", PropertyType.BOOLEAN, Boolean.TRUE);
            fontPropList.add(prop);
        }
        if (fontType == 2 || fontType == 3 || fontType == 5 || fontType == 4) {
            PdfObject firstCharObj = dict.get("FirstChar");
            if (firstCharObj instanceof PdfIndirectObj) {
                firstCharObj = ((PdfIndirectObj)firstCharObj).getObject();
            }
            try {
                int firstChar = ((PdfSimpleObject)firstCharObj).getIntValue();
                prop = new Property("FirstChar", PropertyType.INTEGER, new Integer(firstChar));
                fontPropList.add(prop);
            }
            catch (Exception firstChar) {
                // empty catch block
            }
            PdfObject lastCharObj = dict.get("LastChar");
            if (lastCharObj instanceof PdfIndirectObj) {
                lastCharObj = ((PdfIndirectObj)lastCharObj).getObject();
            }
            try {
                int lastChar = ((PdfSimpleObject)lastCharObj).getIntValue();
                prop = new Property("LastChar", PropertyType.INTEGER, new Integer(lastChar));
                fontPropList.add(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fontType == 4) {
            PdfObject bboxObj = dict.get("FontBBox");
            try {
                if (bboxObj instanceof PdfArray) {
                    fontPropList.add(this.makeRectProperty((PdfArray)bboxObj, "FontBBox"));
                }
            }
            catch (Exception lastCharObj) {
                // empty catch block
            }
        }
        if (fontType == 2 || fontType == 3 || fontType == 5 || fontType == 6 || fontType == 7) {
            PdfObject descriptorObj = dict.get("FontDescriptor");
            try {
                descriptorObj = this.resolveIndirectObject(descriptorObj);
            }
            catch (Exception lastCharObj) {
                // empty catch block
            }
            if (descriptorObj instanceof PdfDictionary) {
                prop = this.buildFontDescriptorProperty((PdfDictionary)descriptorObj);
                fontPropList.add(prop);
            }
        }
        PdfObject encodingObj = dict.get("Encoding");
        try {
            encodingObj = this.resolveIndirectObject(encodingObj);
        }
        catch (Exception lastCharObj) {
            // empty catch block
        }
        if ((fontType == 1 || fontType == 2 || fontType == 3 || fontType == 5 || fontType == 4) && encodingObj instanceof PdfSimpleObject) {
            prop = new Property("Encoding", PropertyType.STRING, ((PdfSimpleObject)encodingObj).getStringValue());
            fontPropList.add(prop);
        }
        if ((fontType == 2 || fontType == 3 || fontType == 5 || fontType == 4) && encodingObj != null && encodingObj instanceof PdfDictionary) {
            prop = this.buildEncodingDictProperty((PdfDictionary)encodingObj);
            fontPropList.add(prop);
        }
        if (fontType == 1 && encodingObj != null && encodingObj instanceof PdfStream) {
            prop = this.buildCMapDictProperty((PdfStream)encodingObj);
            fontPropList.add(prop);
        }
        if (fontType == 4 && (rsrc = dict.get("Resources")) != null) {
            prop = new Property("Resources", PropertyType.BOOLEAN, Boolean.TRUE);
            fontPropList.add(prop);
        }
        if ((fontType == 1 || fontType == 2 || fontType == 3 || fontType == 5 || fontType == 4) && (toUniObj = dict.get("ToUnicode")) != null) {
            prop = new Property("ToUnicode", PropertyType.BOOLEAN, Boolean.TRUE);
            fontPropList.add(prop);
        }
        return fontPropList;
    }

    protected Property buildCMapDictProperty(PdfStream encoding) {
        Property subprop;
        PdfDictionary dict = encoding.getDict();
        ArrayList<Property> propList = new ArrayList<Property>(4);
        Property prop = new Property("CMapDictionary", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        PdfObject cidSysInfo = dict.get("CIDSystemInfo");
        LinkedList<Property> cidList = new LinkedList<Property>();
        try {
            if (cidSysInfo instanceof PdfDictionary) {
                PdfDictionary cidDict = (PdfDictionary)cidSysInfo;
                subprop = this.buildCIDInfoProperty(cidDict);
                cidList.add(subprop);
            } else if (cidSysInfo instanceof PdfArray) {
                Vector<PdfObject> v = ((PdfArray)cidSysInfo).getContent();
                for (int i = 0; i < v.size(); ++i) {
                    PdfDictionary cidDict = (PdfDictionary)v.elementAt(i);
                    Property subsubprop = this.buildCIDInfoProperty(cidDict);
                    cidList.add(subsubprop);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cidList.isEmpty()) {
            subprop = new Property("CIDSystemInfos", PropertyType.PROPERTY, PropertyArity.LIST, cidList);
            propList.add(subprop);
        }
        return prop;
    }

    protected Property buildCIDInfoProperty(PdfDictionary dict) {
        PdfObject supp;
        Property subprop;
        ArrayList<Property> propList = new ArrayList<Property>(3);
        Property prop = new Property("CIDSystemInfo", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        PdfObject reg = dict.get("Registry");
        if (reg instanceof PdfSimpleObject) {
            try {
                String regText = ((PdfSimpleObject)reg).getStringValue();
                subprop = new Property("Registry", PropertyType.STRING, this._encrypted ? ENCRYPTED : regText);
                propList.add(subprop);
            }
            catch (Exception regText) {
                // empty catch block
            }
        }
        PdfObject order = dict.get("Ordering");
        if (reg instanceof PdfSimpleObject) {
            try {
                String ordText = ((PdfSimpleObject)order).getStringValue();
                subprop = new Property("Registry", PropertyType.STRING, ordText);
                propList.add(subprop);
            }
            catch (Exception ordText) {
                // empty catch block
            }
        }
        if ((supp = dict.get("Supplement")) instanceof PdfSimpleObject) {
            try {
                int suppvalue = ((PdfSimpleObject)supp).getIntValue();
                subprop = new Property("Supplement", PropertyType.INTEGER, new Integer(suppvalue));
                propList.add(subprop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return prop;
    }

    protected Property buildEncodingDictProperty(PdfDictionary encodingDict) {
        PdfObject diffs;
        String baseEncString;
        ArrayList<Property> propList = new ArrayList<Property>(2);
        Property prop = new Property("EncodingDictionary", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        PdfObject baseEnc = encodingDict.get("BaseEncoding");
        if (baseEnc instanceof PdfSimpleObject && (baseEncString = ((PdfSimpleObject)baseEnc).getStringValue()) != null) {
            Property baseEncProp = new Property("BaseEncoding", PropertyType.STRING, baseEncString);
            propList.add(baseEncProp);
        }
        Property diffsProp = new Property("Differences", PropertyType.BOOLEAN, new Boolean((diffs = encodingDict.get("Differences")) != null));
        propList.add(diffsProp);
        return prop;
    }

    protected Property buildFontDescriptorProperty(PdfDictionary encodingDict) {
        Property subprop;
        ArrayList<Property> propList = new ArrayList<Property>(6);
        Property prop = new Property("FontDescriptor", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        try {
            PdfSimpleObject fName = (PdfSimpleObject)encodingDict.get("FontName");
            String fNameStr = fName.getStringValue();
            subprop = new Property("FontName", PropertyType.STRING, fNameStr);
            propList.add(subprop);
        }
        catch (Exception fName) {
            // empty catch block
        }
        try {
            PdfSimpleObject flags = (PdfSimpleObject)encodingDict.get("Flags");
            int flagValue = flags.getIntValue();
            subprop = this.buildBitmaskProperty(flagValue, "Flags", PdfStrings.FONTDESCFLAGS, "No flags set");
            if (subprop != null) {
                propList.add(subprop);
            }
        }
        catch (Exception flags) {
            // empty catch block
        }
        try {
            PdfArray bboxObj = (PdfArray)encodingDict.get("FontBBox");
            double[] bbox = bboxObj.toRectangle();
            if (bbox != null) {
                int[] ibbox = new int[4];
                for (int i = 0; i < 4; ++i) {
                    ibbox[i] = (int)bbox[i];
                }
                subprop = new Property("FontBBox", PropertyType.INTEGER, PropertyArity.ARRAY, ibbox);
                propList.add(subprop);
            }
        }
        catch (Exception bboxObj) {
            // empty catch block
        }
        PdfObject fontFile = encodingDict.get("FontFile");
        if (fontFile != null) {
            subprop = new Property("FontFile", PropertyType.BOOLEAN, Boolean.TRUE);
            propList.add(subprop);
        }
        if ((fontFile = encodingDict.get("FontFile2")) != null) {
            subprop = new Property("FontFile2", PropertyType.BOOLEAN, Boolean.TRUE);
            propList.add(subprop);
        }
        if ((fontFile = encodingDict.get("FontFile3")) != null) {
            subprop = new Property("FontFile3", PropertyType.BOOLEAN, Boolean.TRUE);
            propList.add(subprop);
        }
        return prop;
    }

    protected Property buildViewPrefProperty(PdfDictionary prefDict) {
        ArrayList<Property> propList = new ArrayList<Property>(12);
        Property prop = new Property("ViewerPreferences", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        PdfObject ob = prefDict.get("HideToolbar");
        boolean b = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).isTrue() : false;
        Property p = new Property("HideToolbar", PropertyType.BOOLEAN, new Boolean(b));
        propList.add(p);
        ob = prefDict.get("HideMenubar");
        b = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).isTrue() : false;
        p = new Property("HideMenubar", PropertyType.BOOLEAN, new Boolean(b));
        propList.add(p);
        ob = prefDict.get("HideWindowUI");
        b = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).isTrue() : false;
        p = new Property("HideWindowUI", PropertyType.BOOLEAN, new Boolean(b));
        propList.add(p);
        ob = prefDict.get("FitWindow");
        b = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).isTrue() : false;
        p = new Property("FitWindow", PropertyType.BOOLEAN, new Boolean(b));
        propList.add(p);
        ob = prefDict.get("CenterWindow");
        b = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).isTrue() : false;
        p = new Property("CenterWindow", PropertyType.BOOLEAN, new Boolean(b));
        propList.add(p);
        ob = prefDict.get("DisplayDocTitle");
        b = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).isTrue() : false;
        p = new Property("DisplayDocTitle", PropertyType.BOOLEAN, new Boolean(b));
        propList.add(p);
        ob = prefDict.get("NonFullScreenPageMode");
        String s = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).getStringValue() : "UseNone";
        p = new Property("NonFullScreenPageMode", PropertyType.STRING, s);
        propList.add(p);
        ob = prefDict.get("Direction");
        s = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).getStringValue() : "L2R";
        p = new Property("Direction", PropertyType.STRING, s);
        propList.add(p);
        ob = prefDict.get("ViewArea");
        s = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).getStringValue() : "CropBox";
        p = new Property("ViewArea", PropertyType.STRING, s);
        propList.add(p);
        ob = prefDict.get("ViewClip");
        s = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).getStringValue() : "CropBox";
        p = new Property("ViewClip", PropertyType.STRING, s);
        propList.add(p);
        ob = prefDict.get("PrintArea");
        s = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).getStringValue() : "CropBox";
        p = new Property("PrintArea", PropertyType.STRING, s);
        propList.add(p);
        ob = prefDict.get("PageClip");
        s = ob instanceof PdfSimpleObject ? ((PdfSimpleObject)ob).getStringValue() : "CropBox";
        p = new Property("PageClip", PropertyType.STRING, s);
        propList.add(p);
        return prop;
    }

    protected boolean isFontSubset(String baseStr) {
        if (baseStr == null || baseStr.length() < 7) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            char ch = baseStr.charAt(i);
            if (Character.isUpperCase(ch)) continue;
            return false;
        }
        return baseStr.charAt(6) == '+';
    }

    protected Property buildOutlinesProperty(PdfDictionary dict, RepInfo info) throws PdfException {
        this._recursionWarned = false;
        this._visitedOutlineNodes = new HashSet<Integer>();
        String malformed = "Malformed outline dictionary";
        LinkedList<Property> itemList = new LinkedList<Property>();
        Property prop = new Property("Outlines", PropertyType.PROPERTY, PropertyArity.LIST, itemList);
        try {
            PdfObject item = this.resolveIndirectObject(dict.get("First"));
            int listCount = 0;
            while (item != null) {
                Integer onum = new Integer(item.getObjNumber());
                Property p = this.buildOutlineItemProperty((PdfDictionary)item, info);
                itemList.add(p);
                item = this.resolveIndirectObject(((PdfDictionary)item).get("Next"));
                if (item != null) {
                    if (item.getObjNumber() == onum.intValue()) {
                        if (!this._recursionWarned) {
                            info.setMessage(new InfoMessage(outlinesRecursiveString));
                            this._recursionWarned = true;
                        }
                    } else if (++listCount <= 2000) continue;
                }
                break;
            }
        }
        catch (PdfException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new PdfMalformedException(malformed);
        }
        if (itemList.isEmpty()) {
            return null;
        }
        return prop;
    }

    protected Property buildOutlineItemProperty(PdfDictionary dict, RepInfo info) throws PdfException {
        String invalid = "Invalid outline dictionary item";
        ArrayList<Property> itemList = new ArrayList<Property>(3);
        try {
            PdfDictionary child;
            PdfObject destObj;
            Property prop = new Property("Item", PropertyType.PROPERTY, PropertyArity.LIST, itemList);
            PdfSimpleObject title = (PdfSimpleObject)this.resolveIndirectObject(dict.get("Title"));
            if (title == null) {
                throw new PdfInvalidException(invalid);
            }
            itemList.add(new Property("Title", PropertyType.STRING, this._encrypted ? ENCRYPTED : title.getStringValue()));
            if (dict.get("Parent") == null) {
                throw new PdfInvalidException(invalid);
            }
            PdfObject cnt = dict.get("Count");
            if (!(cnt == null || cnt instanceof PdfSimpleObject && ((PdfSimpleObject)cnt).getToken() instanceof Numeric)) {
                throw new PdfInvalidException(invalid);
            }
            PdfIndirectObj ob = (PdfIndirectObj)dict.get("Prev");
            ob = (PdfIndirectObj)dict.get("Next");
            ob = (PdfIndirectObj)dict.get("First");
            ob = (PdfIndirectObj)dict.get("Last");
            if (dict.get("A") != null) {
                this._actionsExist = true;
            }
            if ((destObj = dict.get("Dest")) != null) {
                Destination dest = new Destination(destObj = this.resolveIndirectObject(destObj), this, false);
                if (dest.isIndirect()) {
                    itemList.add(new Property("Destination", PropertyType.STRING, dest.getIndirectDest()));
                } else {
                    int pageObjNum = dest.getPageDestObjNumber();
                    Integer destPg = this._pageSeqMap.get(new Integer(pageObjNum));
                    if (destPg != null) {
                        itemList.add(new Property("Destination", PropertyType.INTEGER, destPg));
                    }
                }
            }
            if ((child = (PdfDictionary)this.resolveIndirectObject(dict.get("First"))) != null) {
                LinkedList<Property> childList = new LinkedList<Property>();
                Property childProp = new Property("Children", PropertyType.PROPERTY, PropertyArity.LIST, childList);
                int listCount = 0;
                while (child != null) {
                    Integer onum = new Integer(child.getObjNumber());
                    if (this._visitedOutlineNodes.contains(onum)) {
                        if (!this._recursionWarned) {
                            info.setMessage(new InfoMessage(outlinesRecursiveString));
                            this._recursionWarned = true;
                        }
                    } else {
                        this._visitedOutlineNodes.add(onum);
                        Property p = this.buildOutlineItemProperty(child, info);
                        childList.add(p);
                    }
                    if ((child = (PdfDictionary)this.resolveIndirectObject(child.get("Next"))) == null) break;
                    if (child.getObjNumber() == onum.intValue()) {
                        if (this._recursionWarned) break;
                        info.setMessage(new InfoMessage(outlinesRecursiveString));
                        this._recursionWarned = true;
                        break;
                    }
                    if (++listCount <= 2000) continue;
                    break;
                }
                itemList.add(childProp);
            }
            return prop;
        }
        catch (PdfException pe) {
            throw pe;
        }
        catch (ClassCastException ce) {
            throw new PdfInvalidException(invalid);
        }
        catch (Exception e) {
            throw new PdfInvalidException(invalid);
        }
    }

    protected boolean doOutlineStuff(RepInfo info) {
        if (this._outlineDict != null) {
            try {
                Property oprop = this.buildOutlinesProperty(this._outlineDict, info);
                if (this._showOutlines || this._verbosity == 1) {
                    if (oprop != null) {
                        this._docCatalogList.add(oprop);
                    }
                } else if (!this._skippedOutlinesReported) {
                    info.setMessage(new InfoMessage(outlinesSkippedString));
                    this._skippedOutlinesReported = true;
                }
            }
            catch (PdfException e) {
                info.setMessage(new ErrorMessage(e.getMessage(), this._parser.getOffset()));
                e.disparage(info);
                return e instanceof PdfInvalidException;
            }
        }
        return true;
    }

    protected int resolveIndirectDest(PdfSimpleObject key) throws PdfException {
        if (this._destNames != null) {
            Destination dest = new Destination(this._destNames.get(key.getRawBytes()), this, true);
            return dest.getPageDestObjNumber();
        }
        return -1;
    }

    protected Property buildUserPermProperty(int flags, String[] flagStrs) {
        return this.buildBitmaskProperty(flags, "UserAccess", flagStrs, "No permissions");
    }

    protected void addStringProperty(PdfDictionary dict, List<Property> propList, String key, String propName) {
        Token tok;
        String propText = null;
        PdfObject propObject = dict.get(key);
        if (propObject instanceof PdfSimpleObject && (tok = ((PdfSimpleObject)propObject).getToken()) instanceof Literal) {
            propText = this._encrypted ? ENCRYPTED : ((Literal)tok).getValue();
            propList.add(new Property(propName, PropertyType.STRING, propText));
        }
    }

    protected void addDateProperty(PdfDictionary dict, List<Property> propList, String key, String propName) throws PdfException {
        Token tok;
        if (this._encrypted) {
            return;
        }
        PdfObject propObject = dict.get(key);
        if (propObject instanceof PdfSimpleObject && (tok = ((PdfSimpleObject)propObject).getToken()) instanceof Literal) {
            Date propDate = ((Literal)tok).parseDate();
            if (propDate != null) {
                propList.add(new Property(propName, PropertyType.DATE, propDate));
            } else {
                throw new PdfInvalidException("Improperly formed date", 0L);
            }
        }
    }

    protected Property buildBitmaskProperty(int val, String name, String[] valueNames, String defaultStr) {
        if (this._je != null && this._je.getShowRawFlag()) {
            return new Property(name, PropertyType.INTEGER, new Integer(val));
        }
        LinkedList<String> slist = new LinkedList<String>();
        try {
            for (int i = 0; i < valueNames.length; ++i) {
                if ((val & 1 << i) == 0 || valueNames[i].length() <= 0) continue;
                slist.add(valueNames[i]);
            }
            if (slist.isEmpty() && defaultStr != null) {
                slist.add(defaultStr);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Property(name, PropertyType.STRING, PropertyArity.LIST, slist);
    }

    protected Property makeRectProperty(PdfArray arrObj, String name) {
        int[] iarr = new int[4];
        double[] arr = arrObj.toRectangle();
        for (int i = 0; i < 4; ++i) {
            iarr[i] = (int)arr[i];
        }
        return new Property(name, PropertyType.INTEGER, PropertyArity.ARRAY, iarr);
    }
}

