/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;

public class COCMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int compIdxBytes = this.nCompBytes();
        if (compIdxBytes == 0) {
            this._repInfo.setMessage(new ErrorMessage("COC marker segment at wrong position in codestream"));
            return false;
        }
        int compIdx = compIdxBytes < 257 ? ModuleBase.readUnsignedByte(this._dstream, this._module) : this._module.readUnsignedShort(this._dstream);
        int codeStyle = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int nDecomp = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int codeBlockWid = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int codeBlockHt = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int codeBlockStyle = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int xform = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int[] precSize = null;
        if ((codeStyle & 1) != 0) {
            precSize = new int[nDecomp + 1];
            for (int i = 0; i < nDecomp + 1; ++i) {
                precSize[i] = ModuleBase.readUnsignedByte(this._dstream, this._module);
            }
        }
        MainOrTile cs = this.getMainOrTile();
        ArrayList<Property> propList = new ArrayList<Property>(10);
        propList.add(new Property("CodingStyle", PropertyType.INTEGER, new Integer(codeStyle)));
        propList.add(new Property("NumberDecompositionLevels", PropertyType.INTEGER, new Integer(nDecomp)));
        propList.add(new Property("CodeBlockWidth", PropertyType.INTEGER, new Integer(codeBlockWid)));
        propList.add(new Property("CodeBlockHeight", PropertyType.INTEGER, new Integer(codeBlockHt)));
        propList.add(new Property("CodeBlockStyle", PropertyType.INTEGER, new Integer(codeBlockStyle)));
        propList.add(new Property("Transformation", PropertyType.INTEGER, new Integer(xform)));
        propList.add(new Property("PrecinctSize", PropertyType.INTEGER, PropertyArity.ARRAY, precSize));
        cs.setCompProperty(compIdx, new Property("COC", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }
}

