/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UUIDBox
extends JP2Box {
    public UUIDBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        Property[] parray = new Property[2];
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        if (this._boxHeader.getLength() != 0L && len < 16) {
            this.wrongBoxSize();
            return false;
        }
        byte[] uuid = new byte[16];
        ModuleBase.readByteBuf(this._dstrm, uuid, this._module);
        parray[0] = new Property("UUID", PropertyType.BYTE, PropertyArity.ARRAY, uuid);
        int dataLen = len - 16;
        if (dataLen > 0) {
            byte[] dataBytes = new byte[dataLen];
            ModuleBase.readByteBuf(this._dstrm, dataBytes, this._module);
            parray[1] = new Property("Data", PropertyType.BYTE, PropertyArity.ARRAY, dataBytes);
        } else {
            parray[1] = new Property("Data", PropertyType.BOOLEAN, Boolean.FALSE);
        }
        this._module.addUUID(new Property("UUIDBox", PropertyType.PROPERTY, PropertyArity.ARRAY, parray));
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "UUID Box";
    }
}

