/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class GPSInfoIFD
extends IFD {
    private static final int GPSVERSIONID = 0;
    private static final int GPSLATITUDEREF = 1;
    private static final int GPSLATITUDE = 2;
    private static final int GPSLONGITUDEREF = 3;
    private static final int GPSLONGITUDE = 4;
    private static final int GPSALTITUDEREF = 5;
    private static final int GPSALTITUDE = 6;
    private static final int GPSTIMESTAMP = 7;
    private static final int GPSSATELLITES = 8;
    private static final int GPSSTATUS = 9;
    private static final int GPSMEASUREMODE = 10;
    private static final int GPSDOP = 11;
    private static final int GPSSPEEDREF = 12;
    private static final int GPSSPEED = 13;
    private static final int GPSTRACKREF = 14;
    private static final int GPSTRACK = 15;
    private static final int GPSIMGDIRECTIONREF = 16;
    private static final int GPSIMGDIRECTION = 17;
    private static final int GPSMAPDATUM = 18;
    private static final int GPSDESTLATITUDEREF = 19;
    private static final int GPSDESTLATITUDE = 20;
    private static final int GPSDESTLONGITUDEREF = 21;
    private static final int GPSDESTLONGITUDE = 22;
    private static final int GPSDESTBEARINGREF = 23;
    private static final int GPSDESTBEARING = 24;
    private static final int GPSDESTDISTANCEREF = 25;
    private static final int GPSDESTDISTANCE = 26;
    private static final int GPSPROCESSINGMETHOD = 27;
    private static final int GPSAREAINFORMATION = 28;
    private static final int GPSDATESTAMP = 29;
    private static final int GPSDIFFERENTIAL = 30;
    private int[] _gpsVersionID = new int[]{2, 2, 0, 0};
    private String _gpsLatitudeRef;
    private Rational[] _gpsLatitude;
    private String _gpsLongitudeRef;
    private Rational[] _gpsLongitude;
    private int _gpsAltitudeRef = 0;
    private Rational _gpsAltitude;
    private Rational[] _gpsTimeStamp;
    private String _gpsSatellites;
    private String _gpsStatus;
    private String _gpsMeasureMode;
    private Rational _gpsDOP;
    private String _gpsSpeedRef = "K";
    private Rational _gpsSpeed;
    private String _gpsTrackRef = "T";
    private Rational _gpsTrack;
    private String _gpsImgDirectionRef = "T";
    private Rational _gpsImgDirection;
    private String _gpsMapDatum;
    private String _gpsDestLatitudeRef;
    private Rational[] _gpsDestLatitude;
    private String _gpsDestLongitudeRef;
    private Rational[] _gpsDestLongitude;
    private String _gpsDestBearingRef = "T";
    private Rational _gpsDestBearing;
    private String _gpsDestDistanceRef = "K";
    private Rational _gpsDestDistance;
    private int[] _gpsProcessingMethod;
    private int[] _gpsAreaInformation;
    private String _gpsDateStamp;
    private int _gpsDifferential = -1;

    public GPSInfoIFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        super(offset, info, raf, bigEndian);
    }

    public Rational getGPSAltitude() {
        return this._gpsAltitude;
    }

    public int getGPSAltitudeRef() {
        return this._gpsAltitudeRef;
    }

    public String getGPSDateStamp() {
        return this._gpsDateStamp;
    }

    public Rational getGPSDestBearing() {
        return this._gpsDestBearing;
    }

    public String getGPSDestBearingRef() {
        return this._gpsDestBearingRef;
    }

    public Rational getGPSDestDistance() {
        return this._gpsDestDistance;
    }

    public String getGPSDestDistanceRef() {
        return this._gpsDestDistanceRef;
    }

    public Rational[] getGPSDestLatitude() {
        return this._gpsDestLatitude;
    }

    public String getGPSDestLatitudeRef() {
        return this._gpsDestLatitudeRef;
    }

    public Rational[] getGPSDestLongitude() {
        return this._gpsDestLongitude;
    }

    public String getGPSDestLongitudeRef() {
        return this._gpsDestLongitudeRef;
    }

    public int getGPSDifferential() {
        return this._gpsDifferential;
    }

    public Rational getGPSDOP() {
        return this._gpsDOP;
    }

    public Rational getGPSImgDirection() {
        return this._gpsImgDirection;
    }

    public String getGPSImgDirectionRef() {
        return this._gpsImgDirectionRef;
    }

    public Rational[] getGPSLatitude() {
        return this._gpsLatitude;
    }

    public String getGPSLatitudeRef() {
        return this._gpsLatitudeRef;
    }

    public Rational[] getGPSLongitude() {
        return this._gpsLongitude;
    }

    public String getGPSLongitudeRef() {
        return this._gpsLongitudeRef;
    }

    public String getGPSMapDatum() {
        return this._gpsMapDatum;
    }

    public String getGPSMeasureMode() {
        return this._gpsMeasureMode;
    }

    public int[] getGPSProcessingMethod() {
        return this._gpsProcessingMethod;
    }

    public String getGPSSatellites() {
        return this._gpsSatellites;
    }

    public Rational getGPSSpeed() {
        return this._gpsSpeed;
    }

    public String getGPSSpeedRef() {
        return this._gpsSpeedRef;
    }

    public String getGPStatus() {
        return this._gpsStatus;
    }

    public Rational[] getGPTimeStamp() {
        return this._gpsTimeStamp;
    }

    public Rational getGPSTrack() {
        return this._gpsTrack;
    }

    public String getGPSTrackRef() {
        return this._gpsTrackRef;
    }

    public int[] getGPSVersionID() {
        return this._gpsVersionID;
    }

    @Override
    public Property getProperty(boolean rawOutput) {
        LinkedList<Property> entries = new LinkedList<Property>();
        entries.add(new Property("GPSVersionID", PropertyType.STRING, Integer.toString(this._gpsVersionID[0]) + "." + Integer.toString(this._gpsVersionID[1]) + "." + Integer.toString(this._gpsVersionID[2]) + "." + Integer.toString(this._gpsVersionID[3])));
        if (this._gpsLatitudeRef != null) {
            entries.add(new Property("GPSLatitudeRef", PropertyType.STRING, this._gpsLatitudeRef));
        }
        if (this._gpsLatitude != null) {
            entries.add(new Property("GPSLatitude", PropertyType.RATIONAL, PropertyArity.ARRAY, this._gpsLatitude));
        }
        if (this._gpsLongitudeRef != null) {
            entries.add(new Property("GPSLongitudeRef", PropertyType.STRING, this._gpsLongitudeRef));
        }
        if (this._gpsLongitude != null) {
            entries.add(new Property("GPSLongitude", PropertyType.RATIONAL, PropertyArity.ARRAY, this._gpsLongitude));
        }
        entries.add(new Property("GPSAltitudeRef", PropertyType.INTEGER, new Integer(this._gpsAltitudeRef)));
        if (this._gpsAltitude != null) {
            entries.add(new Property("GPSAltitude", PropertyType.RATIONAL, this._gpsAltitude));
        }
        if (this._gpsTimeStamp != null) {
            entries.add(new Property("GPSTimeStamp", PropertyType.RATIONAL, PropertyArity.ARRAY, this._gpsTimeStamp));
        }
        if (this._gpsSatellites != null) {
            entries.add(new Property("GPSSatellites", PropertyType.STRING, this._gpsSatellites));
        }
        if (this._gpsStatus != null) {
            entries.add(new Property("GPSStatus", PropertyType.STRING, this._gpsStatus));
        }
        if (this._gpsMeasureMode != null) {
            entries.add(new Property("GPSMeasureMode", PropertyType.STRING, this._gpsMeasureMode));
        }
        if (this._gpsDOP != null) {
            entries.add(new Property("GPSDOP", PropertyType.RATIONAL, this._gpsDOP));
        }
        entries.add(new Property("GPSSpeedRef", PropertyType.STRING, this._gpsSpeedRef));
        if (this._gpsSpeed != null) {
            entries.add(new Property("GPSSpeed", PropertyType.RATIONAL, this._gpsSpeed));
        }
        entries.add(new Property("GPSTrackRef", PropertyType.STRING, this._gpsTrackRef));
        if (this._gpsTrack != null) {
            entries.add(new Property("GPSTrack", PropertyType.RATIONAL, this._gpsTrack));
        }
        entries.add(new Property("GPSImgDirectionRef", PropertyType.STRING, this._gpsImgDirectionRef));
        if (this._gpsImgDirection != null) {
            entries.add(new Property("GPSImgDirection", PropertyType.RATIONAL, this._gpsImgDirection));
        }
        if (this._gpsMapDatum != null) {
            entries.add(new Property("GPSMapDatum", PropertyType.STRING, this._gpsMapDatum));
        }
        if (this._gpsDestLatitudeRef != null) {
            entries.add(new Property("GPSDestLatitudeRef", PropertyType.STRING, this._gpsDestLatitudeRef));
        }
        if (this._gpsDestLatitude != null) {
            entries.add(new Property("GPSDestLatitude", PropertyType.RATIONAL, PropertyArity.ARRAY, this._gpsDestLatitude));
        }
        if (this._gpsDestLongitudeRef != null) {
            entries.add(new Property("GPSDestLongitudeRef", PropertyType.STRING, this._gpsDestLongitudeRef));
        }
        if (this._gpsDestLongitude != null) {
            entries.add(new Property("GPSDestLongitude", PropertyType.RATIONAL, PropertyArity.ARRAY, this._gpsDestLongitude));
        }
        entries.add(new Property("GPSDestBearingRef", PropertyType.STRING, this._gpsDestBearingRef));
        if (this._gpsDestBearing != null) {
            entries.add(new Property("GPSDestBearing", PropertyType.RATIONAL, this._gpsDestBearing));
        }
        entries.add(new Property("GPSDestDistanceRef", PropertyType.STRING, this._gpsDestDistanceRef));
        if (this._gpsDestDistance != null) {
            entries.add(new Property("GPSDestDistance", PropertyType.RATIONAL, this._gpsDestDistance));
        }
        if (this._gpsDestDistanceRef != null) {
            entries.add(new Property("GPSDestDistanceRef", PropertyType.STRING, this._gpsDestDistanceRef));
        }
        if (this._gpsProcessingMethod != null) {
            entries.add(new Property("GPSProcessingMethod", PropertyType.INTEGER, PropertyArity.ARRAY, this._gpsProcessingMethod));
        }
        if (this._gpsAreaInformation != null) {
            entries.add(new Property("GPSAreaInformation", PropertyType.INTEGER, PropertyArity.ARRAY, this._gpsAreaInformation));
        }
        if (this._gpsDateStamp != null) {
            entries.add(new Property("GPSDateStamp", PropertyType.STRING, this._gpsDateStamp));
        }
        entries.add(new Property("GPSDifferential", PropertyType.INTEGER, new Integer(this._gpsDifferential)));
        return this.propertyHeader("GPSInfo", entries);
    }

    @Override
    public void lookupTag(int tag, int type, long count, long value) throws TiffException {
        try {
            if (tag == 6) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsAltitude = this.readRational(count, value);
            } else if (tag == 5) {
                GPSInfoIFD.checkType(tag, type, 1);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsAltitudeRef = this.readByte(type, count, value);
            } else if (tag == 29) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 11);
                this._gpsDateStamp = this.readASCII(count, value);
            } else if (tag == 24) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsDestBearing = this.readRational(count, value);
            } else if (tag == 23) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsDestBearingRef = this.readASCII(count, value);
            } else if (tag == 26) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsDestDistance = this.readRational(count, value);
            } else if (tag == 25) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsDestDistanceRef = this.readASCII(count, value);
            } else if (tag == 20) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 3);
                this._gpsDestLatitude = this.readRationalArray(count, value);
            } else if (tag == 19) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsDestLatitudeRef = this.readASCII(count, value);
            } else if (tag == 22) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 3);
                this._gpsDestLongitude = this.readRationalArray(count, value);
            } else if (tag == 21) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsDestLongitudeRef = this.readASCII(count, value);
            } else if (tag == 30) {
                GPSInfoIFD.checkType(tag, type, 3);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsDifferential = this.readShort(type, count, value);
            } else if (tag == 11) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsDOP = this.readRational(count, value);
            } else if (tag == 17) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsImgDirection = this.readRational(count, value);
            } else if (tag == 16) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsImgDirectionRef = this.readASCII(count, value);
            } else if (tag == 2) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 3);
                this._gpsLatitude = this.readRationalArray(count, value);
            } else if (tag == 1) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsLatitudeRef = this.readASCII(count, value);
            } else if (tag == 4) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 3);
                this._gpsLongitude = this.readRationalArray(count, value);
            } else if (tag == 3) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsLongitudeRef = this.readASCII(count, value);
            } else if (tag == 18) {
                GPSInfoIFD.checkType(tag, type, 2);
                this._gpsMapDatum = this.readASCII(count, value);
            } else if (tag == 10) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsMeasureMode = this.readASCII(count, value);
            } else if (tag == 27) {
                GPSInfoIFD.checkType(tag, type, 7);
                this._gpsProcessingMethod = this.readByteArray(type, count, value);
            } else if (tag == 8) {
                GPSInfoIFD.checkType(tag, type, 2);
                this._gpsSatellites = this.readASCII(count, value);
            } else if (tag == 13) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsSpeed = this.readRational(count, value);
            } else if (tag == 12) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsSpeedRef = this.readASCII(count, value);
            } else if (tag == 9) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsStatus = this.readASCII(count, value);
            } else if (tag == 7) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 3);
                this._gpsTimeStamp = this.readRationalArray(count, value);
            } else if (tag == 15) {
                GPSInfoIFD.checkType(tag, type, 5);
                GPSInfoIFD.checkCount(tag, count, 1);
                this._gpsTrack = this.readRational(count, value);
            } else if (tag == 14) {
                GPSInfoIFD.checkType(tag, type, 2);
                GPSInfoIFD.checkCount(tag, count, 2);
                this._gpsTrackRef = this.readASCII(count, value);
            } else if (tag == 0) {
                GPSInfoIFD.checkType(tag, type, 1);
                GPSInfoIFD.checkCount(tag, count, 4);
                this._gpsVersionID = this.readByteArray(type, count, value);
            } else {
                this._info.setMessage(new ErrorMessage("Unknown GPSInfo IFD tag", "Tag = " + tag, value));
            }
        }
        catch (IOException e) {
            throw new TiffException("Read error for tag" + tag, value);
        }
    }
}

