/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class IFD {
    private static final boolean debug_allowoutofsequence = false;
    public static final int TIFF = 0;
    public static final int EXIF = 1;
    public static final int INTEROPERABILITY = 2;
    public static final int GPSINFO = 3;
    public static final int GLOBALPARAMETERS = 4;
    public static final int NULL = -1;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int IFD = 13;
    public static final String[] TYPE = new String[]{"", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE", "IFD"};
    protected boolean _bigEndian;
    private List<String> _errors;
    private boolean _first;
    private boolean _thumbnail;
    private NumberFormat _format;
    protected RepInfo _info;
    protected long _next;
    protected long _offset;
    private RandomAccessFile _raf;
    protected int _version;

    public IFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        this._offset = offset;
        this._info = info;
        this._raf = raf;
        this._bigEndian = bigEndian;
        this._first = false;
        this._thumbnail = false;
        this._next = 0L;
        this._version = 4;
        this._errors = new LinkedList<String>();
        this._format = NumberFormat.getInstance();
        this._format.setGroupingUsed(false);
        this._format.setMinimumFractionDigits(0);
    }

    public List<String> getErrors() {
        return this._errors;
    }

    public long getNext() {
        return this._next;
    }

    public long getOffset() {
        return this._offset;
    }

    public abstract Property getProperty(boolean var1) throws TiffException;

    public int getVersion() {
        return this._version;
    }

    public boolean isFirst() {
        return this._first;
    }

    public boolean isThumbnail() {
        return this._thumbnail;
    }

    public abstract void lookupTag(int var1, int var2, long var3, long var5) throws TiffException;

    public long parse() throws TiffException {
        return this.parse(false, false);
    }

    public long parse(boolean byteOffsetIsValid, boolean suppressErrors) throws TiffException {
        try {
            return this.parse(byteOffsetIsValid);
        }
        catch (TiffException e) {
            if (suppressErrors) {
                this._info.setMessage(new InfoMessage(e.getMessage(), e.getOffset()));
                return 0L;
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long parse(boolean byteOffsetIsValid) throws TiffException {
        byte[] buffer;
        long offset = this._offset;
        this._next = 0L;
        int nFields = 0;
        try {
            this._raf.seek(offset);
            nFields = ModuleBase.readUnsignedShort(this._raf, this._bigEndian);
            offset += 2L;
            int len = 12 * nFields;
            buffer = new byte[len];
            this._raf.read(buffer, 0, len);
            offset += (long)len;
            this._next = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
        }
        catch (Exception e) {
            throw new TiffException("Premature EOF", offset);
        }
        DataInputStream ifdStream = new DataInputStream(new ByteArrayInputStream(buffer));
        try {
            int prevTag = 0;
            for (int i = 0; i < nFields; ++i) {
                int tag = ModuleBase.readUnsignedShort(ifdStream, this._bigEndian, null);
                if (tag < prevTag) {
                    this._info.setMessage(new ErrorMessage("Tag " + tag + " out of sequence", this._offset + 2L + (long)(12 * i)));
                    this._info.setWellFormed(false);
                }
                prevTag = tag;
                int type = ModuleBase.readUnsignedShort(ifdStream, this._bigEndian, null);
                if (type < 1 || type > 13) {
                    this._info.setMessage(new ErrorMessage("Unknown data type", "Type = " + type + ", Tag = " + tag, this._offset + 4L + (long)(12 * i)));
                    continue;
                }
                if (6 <= type && type <= 13) {
                    this._version = 6;
                }
                long count = ModuleBase.readUnsignedInt(ifdStream, this._bigEndian, null);
                long value = ModuleBase.readUnsignedInt(ifdStream, this._bigEndian, null);
                if (edu.harvard.hul.ois.jhove.module.tiff.IFD.calcValueSize(type, count) > 4L) {
                    if ((value & 1L) != 0L) {
                        if (!byteOffsetIsValid) throw new TiffException("Value offset not word-aligned: " + value, this._offset + 10L + (long)(12 * i));
                        this._info.setMessage(new InfoMessage("Value offset not word-aligned: " + value, this._offset + 10L + (long)(12 * i)));
                    }
                } else {
                    value = this._offset + 10L + (long)(12 * i);
                }
                this.lookupTag(tag, type, count, value);
            }
        }
        catch (IOException e) {
            throw new TiffException("Read error", this._offset + 2L);
        }
        this.postParseInitialization();
        return this._next;
    }

    public void setFirst(boolean first) {
        this._first = first;
    }

    public void setThumbnail(boolean thumbnail) {
        this._thumbnail = thumbnail;
    }

    protected Property addBitmaskProperty(String name, long value, String[] labels, boolean rawOutput) {
        Property prop = null;
        if (!rawOutput) {
            LinkedList<String> list = new LinkedList<String>();
            try {
                for (int i = 0; i < labels.length; ++i) {
                    if ((value & (long)(1 << i)) == 0L) continue;
                    list.add(labels[i]);
                }
            }
            catch (Exception e) {
                this._errors.add(name + " value out of range: " + value);
            }
            prop = new Property(name, PropertyType.STRING, PropertyArity.LIST, list);
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.LONG, new Long(value));
        }
        return prop;
    }

    protected Property addIntegerProperty(String name, int value, String[] labels, boolean rawOutput) {
        Property prop = null;
        if (!rawOutput) {
            try {
                prop = new Property(name, PropertyType.STRING, labels[value]);
            }
            catch (Exception e) {
                this._errors.add(name + " value out of range: " + value);
            }
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.INTEGER, new Integer(value));
        }
        return prop;
    }

    protected Property addIntegerProperty(String name, int value, String[] labels, int[] index, boolean rawOutput) {
        Property prop = null;
        if (!rawOutput) {
            int n = -1;
            for (int i = 0; i < index.length; ++i) {
                if (value != index[i]) continue;
                n = i;
                break;
            }
            if (n > -1) {
                prop = new Property(name, PropertyType.STRING, labels[n]);
            } else {
                this._errors.add(name + " value out of range: " + value);
            }
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.INTEGER, new Integer(value));
        }
        return prop;
    }

    protected Property addIntegerArrayProperty(String name, int[] value, String[] labels, boolean rawOutput) {
        Property prop = null;
        if (!rawOutput) {
            String[] s = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                try {
                    s[i] = labels[value[i]];
                    continue;
                }
                catch (Exception e) {
                    this._errors.add(name + " value out of range: " + value[i]);
                }
            }
            prop = new Property(name, PropertyType.STRING, PropertyArity.ARRAY, s);
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.INTEGER, PropertyArity.ARRAY, value);
        }
        return prop;
    }

    protected Property addRationalProperty(String name, Rational r, boolean rawOutput) {
        Property prop = null;
        if (!rawOutput) {
            prop = new Property(name, PropertyType.STRING, this._format.format(r.toDouble()));
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.RATIONAL, r);
        }
        return prop;
    }

    protected Property addRationalArrayProperty(String name, Rational[] r, boolean rawOutput) {
        Property prop = null;
        if (!rawOutput) {
            String[] s = new String[r.length];
            for (int i = 0; i < r.length; ++i) {
                s[i] = this._format.format(r[i].toDouble());
            }
            prop = new Property(name, PropertyType.STRING, PropertyArity.ARRAY, s);
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.RATIONAL, PropertyArity.ARRAY, r);
        }
        return prop;
    }

    protected void postParseInitialization() {
    }

    protected Property propertyHeader(String type, List entries) {
        Property[] array = new Property[]{new Property("Offset", PropertyType.LONG, new Long(this._offset)), new Property("Type", PropertyType.STRING, type), new Property("Entries", PropertyType.PROPERTY, PropertyArity.LIST, entries)};
        return new Property("IFD", PropertyType.PROPERTY, PropertyArity.ARRAY, array);
    }

    protected String readASCII(long count, long value) throws IOException {
        byte c;
        this._raf.seek(value);
        byte[] buffer = new byte[(int)count];
        this._raf.read(buffer);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < count && (c = buffer[i]) != 0) {
            if (c < 32 || c > 127) {
                sb.append(this.byteToHex(c));
            } else {
                sb.append((char)c);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String[] readASCIIArray(long count, long value) throws IOException {
        this._raf.seek(value);
        int nstrs = 0;
        LinkedList<String> list = new LinkedList<String>();
        byte[] buf = new byte[(int)count];
        this._raf.read(buf);
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while ((long)i < count) {
            byte b = buf[i];
            if (b == 0) {
                list.add(strbuf.toString());
                strbuf.setLength(0);
            } else if (b < 32 || b > 127) {
                strbuf.append(this.byteToHex(b));
            } else {
                strbuf.append((char)b);
            }
            ++i;
        }
        String[] strs = new String[nstrs];
        ListIterator iter = list.listIterator();
        for (int i2 = 0; i2 < nstrs; ++i2) {
            strs[i2] = (String)iter.next();
        }
        return strs;
    }

    protected int readByte(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        return (int)this.readUnsigned(type);
    }

    protected int[] readByteArray(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        int[] array = new int[(int)count];
        int i = 0;
        while ((long)i < count) {
            array[i] = (int)this.readUnsigned(type);
            ++i;
        }
        return array;
    }

    protected byte[] readTrueByteArray(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        byte[] array = new byte[(int)count];
        this._raf.read(array);
        return array;
    }

    protected double[] readDoubleArray(long count, long value) throws IOException {
        this._raf.seek(value);
        double[] darray = new double[(int)count];
        int i = 0;
        while ((long)i < count) {
            darray[i] = ModuleBase.readDouble(this._raf, this._bigEndian);
            ++i;
        }
        return darray;
    }

    protected long readLong(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        return this.readUnsigned(type);
    }

    protected long[] readLongArray(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        long[] array = new long[(int)count];
        int i = 0;
        while ((long)i < count) {
            array[i] = this.readUnsigned(type);
            ++i;
        }
        return array;
    }

    public long readUnsigned(int type) throws IOException {
        long u = 0L;
        switch (type) {
            case 1: 
            case 7: {
                u = ModuleBase.readUnsignedByte(this._raf);
                break;
            }
            case 3: {
                u = ModuleBase.readUnsignedShort(this._raf, this._bigEndian);
                break;
            }
            case 4: 
            case 13: {
                u = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
            }
        }
        return u;
    }

    protected Rational readRational(long count, long value) throws IOException {
        this._raf.seek(value);
        long numer = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
        long denom = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
        return new Rational(numer, denom);
    }

    protected Rational[] readRationalArray(long count, long value) throws IOException {
        this._raf.seek(value);
        byte[] buffer = new byte[(int)edu.harvard.hul.ois.jhove.module.tiff.IFD.calcValueSize(5, count)];
        this._raf.read(buffer);
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(buffer));
        Rational[] rarray = new Rational[(int)count];
        int i = 0;
        while ((long)i < count) {
            long numer = ModuleBase.readUnsignedInt(stream, this._bigEndian, null);
            long denom = ModuleBase.readUnsignedInt(stream, this._bigEndian, null);
            rarray[i] = new Rational(numer, denom);
            ++i;
        }
        return rarray;
    }

    protected Rational readSignedRational(long count, long value) throws IOException {
        this._raf.seek(value);
        long numer = ModuleBase.readSignedInt(this._raf, this._bigEndian);
        long denom = ModuleBase.readSignedInt(this._raf, this._bigEndian);
        return new Rational(numer, denom);
    }

    protected Rational[] readSignedRationalArray(long count, long value) throws IOException {
        this._raf.seek(value);
        byte[] buffer = new byte[(int)edu.harvard.hul.ois.jhove.module.tiff.IFD.calcValueSize(10, count)];
        this._raf.read(buffer);
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(buffer));
        Rational[] rarray = new Rational[(int)count];
        int i = 0;
        while ((long)i < count) {
            long numer = ModuleBase.readSignedInt(stream, this._bigEndian, null);
            long denom = ModuleBase.readSignedInt(stream, this._bigEndian, null);
            rarray[i] = new Rational(numer, denom);
            ++i;
        }
        return rarray;
    }

    protected int readShort(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        return (int)this.readUnsigned(type);
    }

    protected int[] readShortArray(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        int[] iarray = new int[(int)count];
        int i = 0;
        while ((long)i < count) {
            iarray[i] = (int)this.readUnsigned(type);
            ++i;
        }
        return iarray;
    }

    protected int[] readSShortArray(int type, long count, long value) throws IOException {
        this._raf.seek(value);
        int[] iarray = new int[(int)count];
        int i = 0;
        while ((long)i < count) {
            iarray[i] = ModuleBase.readSignedShort(this._raf, this._bigEndian);
            ++i;
        }
        return iarray;
    }

    public static long calcValueSize(int type, long count) {
        int fieldSize = 0;
        switch (type) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                fieldSize = 1;
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                fieldSize = 2;
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                fieldSize = 4;
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                fieldSize = 8;
            }
        }
        return count * (long)fieldSize;
    }

    public boolean isBigEndian() {
        return this._bigEndian;
    }

    protected static void checkCount(int tag, long count, int minCount) throws TiffException {
        if (count < (long)minCount) {
            throw new TiffException("Count mismatch for tag " + tag + "; expecting " + minCount + ", saw " + count);
        }
    }

    protected static void checkType(int tag, int type, int expected) throws TiffException {
        if (!(type != 1 && type != 3 && type != 4 && type != 13 || expected != 1 && expected != 3 && expected != 4 && expected != 13)) {
            return;
        }
        if (type != expected) {
            throw new TiffException("Type mismatch for tag " + tag + "; expecting " + expected + ", saw " + type);
        }
    }

    protected static void checkType(int tag, int type, int type1, int type2) throws TiffException {
        if (type != type1 && type != type2) {
            throw new TiffException("Type mismatch for tag " + tag + "; expecting " + type1 + " or " + type2 + ", saw " + type);
        }
    }

    protected static Rational average(Rational r1, Rational r2) {
        long d1 = r1.getDenominator();
        long d2 = r2.getDenominator();
        Rational f1 = new Rational(r1.getNumerator() * d2, r1.getDenominator() * d2);
        Rational f2 = new Rational(r2.getNumerator() * d1, r2.getDenominator() * d1);
        return new Rational((f1.getNumerator() + f2.getNumerator()) / 2L, f1.getDenominator());
    }

    private String byteToHex(byte c) {
        int[] nibbles = new int[]{(c & 0xF0) >> 4, c & 0xF};
        StringBuffer retval = new StringBuffer("%");
        for (int i = 0; i <= 1; ++i) {
            int b = nibbles[i];
            b = b >= 10 ? (b += 55) : (b += 48);
            retval.append((char)b);
        }
        return retval.toString();
    }
}

