/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class InstrumentChunk
extends Chunk {
    public InstrumentChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        int unshiftedNote = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int fineTune = ModuleBase.readSignedByte(this._dstream, this._module);
        int gain = ModuleBase.readSignedByte(this._dstream, this._module);
        int lowNote = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int highNote = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int lowVelocity = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int highVelocity = ModuleBase.readUnsignedByte(this._dstream, this._module);
        Property[] propArr = new Property[]{new Property("UnshiftedNote", PropertyType.INTEGER, new Integer(unshiftedNote)), new Property("FineTune", PropertyType.INTEGER, new Integer(fineTune)), new Property("Gain", PropertyType.INTEGER, new Integer(gain)), new Property("LowNote", PropertyType.INTEGER, new Integer(lowNote)), new Property("HighNote", PropertyType.INTEGER, new Integer(highNote)), new Property("LowVelocity", PropertyType.INTEGER, new Integer(lowVelocity)), new Property("HighVelocity", PropertyType.INTEGER, new Integer(highVelocity))};
        module.addWaveProperty(new Property("Instrument", PropertyType.PROPERTY, PropertyArity.ARRAY, propArr));
        return true;
    }
}

