/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class Base2 {
    public static String[] encodeTab = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    public static byte[] decodeTab = new byte[256];

    protected Base2() {
    }

    public static String decodeToString(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        int mod = 0;
        int cout = 0;
        while (b) {
            if (idx < in.length()) {
                char cin;
                byte cIdx;
                if ((cIdx = decodeTab[cin = in.charAt(idx++)]) != -1) {
                    cout = cout << 1 | cIdx;
                    if ((mod = (mod + 1) % 8) != 0) continue;
                    out.append((char)cout);
                    cout = 0;
                    continue;
                }
                return null;
            }
            b = false;
        }
        if (mod == 0) {
            return out.toString();
        }
        return null;
    }

    public static byte[] decodeToArray(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean b = true;
        int idx = 0;
        int mod = 0;
        int cout = 0;
        while (b) {
            if (idx < in.length()) {
                char cin;
                byte cIdx;
                if ((cIdx = decodeTab[cin = in.charAt(idx++)]) != -1) {
                    cout = cout << 1 | cIdx;
                    if ((mod = (mod + 1) % 8) != 0) continue;
                    out.write(cout);
                    continue;
                }
                return null;
            }
            b = false;
        }
        if (mod == 0) {
            return out.toByteArray();
        }
        return null;
    }

    public static String encodeString(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(in.length() << 3);
        for (int i = 0; i < in.length(); ++i) {
            char cin = in.charAt(i);
            if (cin >= '\u0100') {
                return null;
            }
            out.append(encodeTab[cin >> 4 & 0xF]);
            out.append(encodeTab[cin & 0xF]);
        }
        return out.toString();
    }

    public static String encodeArray(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(in.length << 3);
        for (int i = 0; i < in.length; ++i) {
            out.append(encodeTab[in[i] >> 4 & 0xF]);
            out.append(encodeTab[in[i] & 0xF]);
        }
        return out.toString();
    }

    public static String delimit(String inStr, int width, char delimiter) {
        if (inStr == null) {
            return null;
        }
        if (inStr.length() == 0) {
            return "";
        }
        if (width <= 0) {
            return inStr;
        }
        StringBuffer outSb = new StringBuffer(inStr.length() + (inStr.length() + width - 1) / width);
        int idx = 0;
        int lIdx = width;
        while (idx < inStr.length()) {
            if (idx == lIdx) {
                outSb.append(delimiter);
                lIdx += width;
            }
            outSb.append(inStr.charAt(idx++));
        }
        return outSb.toString();
    }

    static {
        Arrays.fill(decodeTab, (byte)-1);
        Base2.decodeTab[48] = 0;
        Base2.decodeTab[49] = 1;
    }
}

