/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.tiffTests;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.handler.XmlHandler;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import org.opengis.cite.geotiff11.TestRunArg;
import org.opengis.cite.geotiff11.tiffTests.CommonTiffMeta;
import org.opengis.cite.geotiff11.util.TestSuiteLogger;
import org.testng.Assert;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TiffCoreTests
extends CommonTiffMeta {
    private static final String CWD = System.getProperty("user.dir");
    private static final String TCR = "tiff-compliance-report.txt";
    private static final String FULL_TCR = Paths.get(CWD, "tiff-compliance-report.txt").toString();
    private String tiffPath;
    private static final String VALID = "";

    @BeforeClass
    public void setTiffPath(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        this.tiffPath = (String)params.get(TestRunArg.IUT.toString());
    }

    @Test(description="TIFF Core Endianness Test")
    public void verifyTiffEndianness() {
        Assert.assertTrue((this.tiffDump.getMagic().equals("0x4949") || this.tiffDump.getMagic().equals("0x4d4d") ? 1 : 0) != 0);
    }

    @Test(description="TIFF Core Version Test")
    public void verifyTiffVersion() {
        Assert.assertTrue((boolean)this.tiffDump.getVersion().contains("2a"));
    }

    @Test(description="TIFF Core 6.0 Compliance Test")
    public void verifyTiffVersionSixCompliance() throws Exception {
        App app = App.newAppWithName((String)"Tiff Test");
        JhoveBase je = new JhoveBase();
        je.setLogLevel("SEVERE");
        je.setEncoding("utf-8");
        je.setBufferSize(4096);
        je.setChecksumFlag(false);
        je.setShowRawFlag(false);
        je.setSignatureFlag(false);
        Module tiffModule = je.getModule("TIFF-hul");
        XmlHandler handler = new XmlHandler();
        boolean isValid = false;
        File tempFile = File.createTempFile("tiff-compliance-report", ".txt");
        tempFile.deleteOnExit();
        try {
            je.dispatch(app, tiffModule, null, (OutputHandler)handler, tempFile.getAbsolutePath(), new String[]{this.tiffPath});
        }
        catch (NullPointerException e) {
            Assert.fail((String)"JHove failed to generate a compliance report");
        }
        Scanner scanner = new Scanner(tempFile);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains(VALID)) continue;
            isValid = true;
            break;
        }
        scanner.close();
        Assert.assertTrue((boolean)isValid, (String)"a GeoTIFF file SHALL be compliant with the TIFF 6.0 specification");
    }
}

