/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;

public class SpltChunk
extends PNGChunk {
    public SpltChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = true;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badChunk = "Bad sPLT chunk";
        String paletteName = null;
        this.processChunkCommon(info);
        if (this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage("sPLT chunk is not allowed after IDAT chunk");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad sPLT chunk");
        }
        int lengthLeft = (int)this.length;
        int maxNameLen = this.length > 80L ? 80 : (int)this.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxNameLen; ++i) {
            char c = (char)this.readUnsignedByte();
            --lengthLeft;
            if (c == '\u0000') {
                paletteName = sb.toString();
                break;
            }
            sb.append(c);
        }
        if (paletteName == null) {
            ErrorMessage msg = new ErrorMessage("Name not terminated in sPLT chunk");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad sPLT chunk");
        }
        int sampleDepth = this.readUnsignedByte();
        --lengthLeft;
        if (sampleDepth != 8 && sampleDepth != 16) {
            ErrorMessage msg = new ErrorMessage("Invalid sample depth " + sampleDepth + " for sPLT chunk");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad sPLT chunk");
        }
        if (sampleDepth == 8 && lengthLeft % 6 != 0 || sampleDepth == 16 && lengthLeft % 10 != 0) {
            ErrorMessage msg = new ErrorMessage("Invalid length for sPLT chunk");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad sPLT chunk");
        }
        int nSamples = sampleDepth == 8 ? lengthLeft / 6 : lengthLeft / 10;
        this._module.addSplt(paletteName, sampleDepth, nSamples);
        for (int i = 0; i < lengthLeft; ++i) {
            this.readUnsignedByte();
        }
    }
}

