/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.gif.GifStrings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GifModule
extends ModuleBase {
    private static final boolean debug_appIdentCaseInsens = false;
    private static final String NAME = "GIF-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2006, 9, 5};
    private static final String[] FORMAT = new String[]{"GIF", "Graphics Interchange Format"};
    private static final String COVERAGE = "GIF87a, GIF89a";
    private static final String[] MIMETYPE = new String[]{"image/gif"};
    private static final String WELLFORMED = "A GIF file is well-formed if it has a header block; a sequence of properly formed control, graphic-rendering, and special purpose blocks; and a trailer block";
    private static final String VALIDITY = "A GIF file is valid if well-formed, has at most one global color map, and at most one graphic control extension preceding an image descriptor or a plain text extension";
    private static final String REPINFO = "Additional representation information includes: NISO Z39.87 Digital Still Image Technical Metadata, and block-specific metadata";
    private static final String NOTE = "'GIF' and 'Graphics Interchange Format' are trademarks of Compuserve Interactive Services Inc.";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final int EXT_BLOCK = 33;
    private static final int APPLICATION_EXT = 255;
    private static final int COMMENT_EXT = 254;
    private static final int GRAPHIC_CONTROL_EXT = 249;
    private static final int IMAGE_DESC = 44;
    private static final int PLAIN_TEXT_EXT = 1;
    private static final int TRAILER = 59;
    protected byte[] _sig;
    protected Checksummer _ckSummer;
    protected Property _xmpProp;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected boolean _globalColorTableFlag;
    protected int _globalColorTableSize;
    protected int _gceCounter;
    protected Property _metadata;
    protected List _blocksList;
    protected int _numGraphicBlocks;

    public GifModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("GIF (Graphics Interchange Format): A standard defining a mechanism for the storage and transmission of raster-based graphics information", DocumentType.REPORT);
        Agent.Builder builder = new Agent.Builder("Compuserve Interactive Services Inc.", AgentType.COMMERCIAL).address("5000 Arlington Centre Blvd., Columbus, OS 43220").telephone("(614) 457-8600").web("http://www.compuserve.com/");
        Agent cmpsrvAgent = builder.build();
        doc.setAuthor(cmpsrvAgent);
        doc.setDate("1987-06-15");
        doc.setIdentifier(new Identifier("http://www.w3.org/Graphics/GIF/spec-gif87.txt", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("Graphics Interchange Format", DocumentType.REPORT);
        doc.setEdition("Version 89a");
        doc.setAuthor(cmpsrvAgent);
        doc.setDate("1987-06-15");
        doc.setIdentifier(new Identifier("http://www.w3.org/Graphics/GIF/spec-gif89a.txt", IdentifierType.URL));
        this._specification.add(doc);
        InternalSignature sig = new InternalSignature("GIF", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0);
        this._signature.add(sig);
        sig = new InternalSignature("87a", SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 3, "For version 87a");
        this._signature.add(sig);
        sig = new InternalSignature("89a", SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 3, "For version 89a");
        this._signature.add(sig);
        sig = new ExternalSignature(".gif", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        this._bigEndian = false;
    }

    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        int[] sigBytes = new int[]{71, 73, 70, 56, 42, 97};
        try {
            int ch;
            this._dstream = null;
            this._dstream = GifModule.getBufferedDataStream((InputStream)stream, (int)(this._je != null ? this._je.getBufferSize() : 0));
            for (int i = 0; i < 4; ++i) {
                ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch == sigBytes[i]) continue;
                info.setWellFormed(false);
                return;
            }
            ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            if (ch != 55 && ch != 57) {
                info.setWellFormed(false);
                return;
            }
            ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            if (ch != sigBytes[5]) {
                info.setWellFormed(false);
                return;
            }
            info.setModule((Module)this);
            info.setFormat(this._format[0]);
            info.setMimeType(this._mimeType[0]);
            info.setSigMatch(this._name);
        }
        catch (Exception e) {
            info.setWellFormed(false);
            return;
        }
    }

    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        info.setModule((Module)this);
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        this._blocksList = new LinkedList();
        Property _blocks = new Property("Blocks", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._blocksList);
        this._ckSummer = null;
        if (this._app != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, this._ckSummer);
            this._dstream = GifModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._app != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = GifModule.getBufferedDataStream((InputStream)stream, (int)(this._app != null ? this._je.getBufferSize() : 0));
        }
        if (!this.readSig(info)) {
            return 0;
        }
        info.setSigMatch(this._name);
        if (!this.readLSD(info)) {
            return 0;
        }
        boolean moreToCome = true;
        while (moreToCome) {
            moreToCome = this.readBlock(info);
            if (info.getWellFormed() != 0) continue;
            return 0;
        }
        if (this._ckSummer != null) {
            try {
                long n;
                while ((n = this.skipBytes(this._dstream, 2048L, this)) != 0L) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            info.setSize(this._cstream.getNBytes());
            info.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = this._ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = this._ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
        Property[] metaArray = this._xmpProp != null ? new Property[3] : new Property[2];
        this._metadata = new Property("GIFMetadata", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)metaArray);
        metaArray[1] = _blocks;
        metaArray[0] = new Property("GraphicRenderingBlocks", PropertyType.INTEGER, (Object)new Integer(this._numGraphicBlocks));
        if (this._xmpProp != null) {
            metaArray[2] = this._xmpProp;
        }
        info.setProperty(this._metadata);
        return 0;
    }

    protected void initParse() {
        super.initParse();
        this._sig = new byte[6];
        this._globalColorTableFlag = false;
        this._globalColorTableSize = 0;
        this._gceCounter = 0;
        this._numGraphicBlocks = 0;
    }

    protected boolean readSig(RepInfo info) throws IOException {
        String badHeader = "Invalid GIF header";
        for (int nbyt = 0; nbyt < 6; ++nbyt) {
            try {
                int ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (nbyt >= 6) continue;
                this._sig[nbyt] = (byte)ch;
                continue;
            }
            catch (EOFException e) {
                info.setMessage((Message)new ErrorMessage(badHeader, 0L));
                info.setWellFormed(0);
                return false;
            }
        }
        String sigStr = new String(this._sig);
        if ("GIF89a".equals(sigStr)) {
            info.setVersion("89a");
            info.setProfile("GIF 89a");
        } else if ("GIF87a".equals(sigStr)) {
            info.setVersion("87a");
            info.setProfile("GIF 87a");
        } else {
            info.setMessage((Message)new ErrorMessage(badHeader, 0L));
            info.setWellFormed(0);
            return false;
        }
        return true;
    }

    protected boolean readLSD(RepInfo info) throws IOException {
        Vector<Property> propVec = new Vector<Property>(8);
        int width = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("LogicalScreenWidth", PropertyType.INTEGER, (Object)new Integer(width)));
        int height = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("LogicalScreenHeight", PropertyType.INTEGER, (Object)new Integer(height)));
        int packedFields = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        this._globalColorTableFlag = (packedFields & 0x80) != 0;
        int bitsPerColor = ((packedFields & 0x70) >> 4) + 1;
        propVec.add(new Property("ColorResolution", PropertyType.INTEGER, (Object)new Integer(bitsPerColor)));
        boolean sortFlag = (packedFields & 8) != 0;
        int rawGlobalColorTableSize = packedFields & 7;
        if (this._globalColorTableFlag) {
            this._globalColorTableSize = 3 * (1 << rawGlobalColorTableSize + 1);
        }
        int bgColorIndex = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("BackgroundColorIndex", PropertyType.INTEGER, (Object)new Integer(bgColorIndex)));
        int pixAspectRatio = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("PixelAspectRatio", PropertyType.SHORT, (Object)new Short((short)pixAspectRatio)));
        propVec.add(this.addByteProperty("GlobalColorTableFlag", this._globalColorTableFlag ? 1 : 0, GifStrings.GLOBAL_COLOR_TABLE_FLAG));
        propVec.add(this.addByteProperty("GlobalColorTableSortFlag", sortFlag ? 1 : 0, GifStrings.COLOR_TABLE_SORT_FLAG));
        propVec.add(new Property("GlobalColorTableSize", PropertyType.SHORT, (Object)new Short((short)rawGlobalColorTableSize)));
        Property prop = new Property("LogicalScreenDescriptor", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this.vectorToPropArray(propVec));
        this._blocksList.add(prop);
        if (this._globalColorTableFlag) {
            short[] gctArray = new short[this._globalColorTableSize];
            for (int i = 0; i < this._globalColorTableSize; ++i) {
                gctArray[i] = (short)this._dstream.readUnsignedByte();
            }
            this._blocksList.add(new Property("GlobalColorTable", PropertyType.SHORT, PropertyArity.ARRAY, (Object)gctArray));
        }
        return true;
    }

    protected boolean readBlock(RepInfo info) throws IOException {
        int type;
        try {
            type = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        }
        catch (EOFException e) {
            info.setWellFormed(0);
            info.setMessage((Message)new ErrorMessage("End of file reached without encountering Trailer block", this._nByte));
            return false;
        }
        try {
            switch (type) {
                case 33: {
                    return this.readExtBlock(info);
                }
                case 44: {
                    return this.readImage(info);
                }
                case 59: {
                    return false;
                }
            }
            info.setWellFormed(0);
            info.setMessage((Message)new ErrorMessage("Unknown data block type", "Type = " + type, this._nByte));
            return false;
        }
        catch (EOFException e) {
            info.setWellFormed(0);
            info.setMessage((Message)new ErrorMessage("Unexpected end of file", this._nByte));
            return false;
        }
    }

    protected boolean readExtBlock(RepInfo info) throws IOException {
        int subtype = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        switch (subtype) {
            case 255: {
                return this.readAppExtension(info);
            }
            case 254: {
                return this.readCommentExtension(info);
            }
            case 249: {
                return this.readGraphicsCtlBlock(info);
            }
            case 1: {
                return this.readPlainTextExtension(info);
            }
        }
        info.setWellFormed(0);
        info.setMessage((Message)new ErrorMessage("Unknown extension block type", "Type = " + subtype, this._nByte));
        return false;
    }

    protected boolean readImage(RepInfo info) throws IOException {
        int blockSize;
        ++this._numGraphicBlocks;
        Vector<Property> propVec = new Vector<Property>(7);
        NisoImageMetadata niso = new NisoImageMetadata();
        Property nisoProp = new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)niso);
        niso.setMimeType("image/gif");
        niso.setByteOrder("little-endian");
        niso.setCompressionScheme(5);
        niso.setColorSpace(3);
        niso.setOrientation(1);
        niso.setBitsPerSample(new int[]{8});
        this._gceCounter = 0;
        int leftPos = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("ImageLeftPosition", PropertyType.INTEGER, (Object)new Integer(leftPos)));
        int topPos = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("ImageTopPosition", PropertyType.INTEGER, (Object)new Integer(topPos)));
        int width = this.readUnsignedShort(this._dstream);
        niso.setImageWidth((long)width);
        int height = this.readUnsignedShort(this._dstream);
        niso.setImageLength((long)height);
        int packedFields = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int interlaceFlag = (packedFields & 0x40) >> 6;
        propVec.add(this.addByteProperty("InterlaceFlag", interlaceFlag, GifStrings.INTERLACE_FLAG));
        int localColorTableFlag = (packedFields & 0x80) >> 7;
        propVec.add(this.addByteProperty("LocalColorTableFlag", localColorTableFlag, GifStrings.LOCAL_COLOR_TABLE_FLAG));
        int sortFlag = (packedFields & 0x20) >> 5;
        propVec.add(this.addByteProperty("LocalColorTableSortFlag", sortFlag, GifStrings.COLOR_TABLE_SORT_FLAG));
        int localColorTableSize = 0;
        int rawLocalColorTableSize = packedFields & 7;
        propVec.add(new Property("LocalColorTableSize", PropertyType.SHORT, (Object)new Short((short)rawLocalColorTableSize)));
        propVec.add(nisoProp);
        if (localColorTableFlag != 0) {
            localColorTableSize = 3 * (1 << rawLocalColorTableSize + 1);
            this.skipBytes(this._dstream, localColorTableSize, this);
        }
        Property prop = new Property("ImageDescriptor", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this.vectorToPropArray(propVec));
        this._blocksList.add(prop);
        GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        while ((blockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) != 0) {
            this.skipBytes(this._dstream, blockSize, this);
        }
        return true;
    }

    protected boolean readAppExtension(RepInfo info) throws IOException {
        int i;
        int blockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        if (blockSize != 11) {
            info.setMessage((Message)new ErrorMessage("Wrong application extension block size", this._nByte));
            info.setWellFormed(0);
            return false;
        }
        Vector<Property> propVec = new Vector<Property>(3);
        StringBuffer appIdent = new StringBuffer();
        for (i = 0; i < 8; ++i) {
            appIdent.append((char)GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this));
        }
        propVec.add(new Property("ApplicationIdentifier", PropertyType.STRING, (Object)appIdent.toString()));
        short[] appAuth = new short[3];
        for (i = 0; i < 3; ++i) {
            appAuth[i] = (short)GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        }
        propVec.add(new Property("ApplicationAuthenticationCode", PropertyType.SHORT, PropertyArity.ARRAY, (Object)appAuth));
        int appDataSize = 0;
        if ("XMP Data".equals(appIdent.toString()) && appAuth[0] == 88 && appAuth[1] == 77 && appAuth[2] == 80) {
            appDataSize = this.readXMP();
        } else {
            while (true) {
                int subBlockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                appDataSize += subBlockSize + 1;
                if (subBlockSize == 0) break;
                this.skipBytes(this._dstream, subBlockSize, this);
            }
        }
        propVec.add(new Property("ApplicationDataSize", PropertyType.INTEGER, (Object)new Integer(appDataSize)));
        Property prop = new Property("ApplicationExtension", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this.vectorToPropArray(propVec));
        this._blocksList.add(prop);
        return true;
    }

    protected boolean readCommentExtension(RepInfo info) throws IOException {
        int subBlockSize;
        StringBuffer buf = new StringBuffer();
        while ((subBlockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) != 0) {
            for (int i = 0; i < subBlockSize; ++i) {
                int ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch == 0) continue;
                buf.append((char)ch);
            }
        }
        Property prop = new Property("CommentExtension", PropertyType.STRING, (Object)buf.toString());
        return true;
    }

    protected boolean readPlainTextExtension(RepInfo info) throws IOException {
        int subBlockSize;
        ++this._numGraphicBlocks;
        this._gceCounter = 0;
        int blockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        if (blockSize != 12) {
            info.setMessage((Message)new ErrorMessage("Wrong plain text extension block size", this._nByte));
            info.setWellFormed(0);
            return false;
        }
        if (!this._globalColorTableFlag) {
            info.setMessage((Message)new ErrorMessage("Plain text extension requires global color table", this._nByte));
            info.setValid(false);
        }
        Vector<Property> propVec = new Vector<Property>(9);
        int textLeft = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("TextGridLeftPosition", PropertyType.INTEGER, (Object)new Integer(textLeft)));
        int textTop = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("TextGridTopPosition", PropertyType.INTEGER, (Object)new Integer(textTop)));
        int textGWidth = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("TextGridWidth", PropertyType.INTEGER, (Object)new Integer(textGWidth)));
        int textGHeight = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("TextGridHeight", PropertyType.INTEGER, (Object)new Integer(textGHeight)));
        int charCWidth = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("CharacterCellWidth", PropertyType.SHORT, (Object)new Short((short)charCWidth)));
        int charCHeight = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("CharacterCellHeight", PropertyType.SHORT, (Object)new Short((short)charCHeight)));
        int textFgIdx = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("TextForegroundColorIndex", PropertyType.SHORT, (Object)new Short((short)textFgIdx)));
        int textBgIdx = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("TextBackgroundColorIndex", PropertyType.SHORT, (Object)new Short((short)textBgIdx)));
        StringBuffer buf = new StringBuffer();
        while ((subBlockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) != 0) {
            for (int i = 0; i < subBlockSize; ++i) {
                int ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch >= 32 || ch <= 247) {
                    buf.append((char)ch);
                    continue;
                }
                buf.append(' ');
            }
        }
        propVec.add(new Property("PlainTextData", PropertyType.STRING, (Object)buf.toString()));
        Property prop = new Property("PlainTextExtension", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this.vectorToPropArray(propVec));
        this._blocksList.add(prop);
        return true;
    }

    protected boolean readGraphicsCtlBlock(RepInfo info) throws IOException {
        int blockSize;
        Vector<Property> propVec = new Vector<Property>(5);
        if (++this._gceCounter > 1) {
            info.setMessage((Message)new ErrorMessage("Multiple graphics control blocks for one image", this._nByte));
            info.setWellFormed(0);
        }
        if ((blockSize = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) != 4) {
            info.setMessage((Message)new ErrorMessage("Wrong graphics control block size", this._nByte));
            info.setWellFormed(0);
            return false;
        }
        int packedFields = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int dispMethod = (packedFields & 0x1C) >> 3;
        propVec.add(this.addByteProperty("DisposalMethod", dispMethod, GifStrings.GCE_DISPOSAL_METHOD));
        int userInputFlag = (packedFields & 2) >> 1;
        propVec.add(this.addByteProperty("UserInputFlag", userInputFlag, GifStrings.GCE_USER_INPUT_FLAG));
        int transparencyFlag = packedFields & 1;
        propVec.add(this.addByteProperty("TransparencyFlag", transparencyFlag, GifStrings.GCE_TRANSPARENCY_FLAG));
        int delayTime = this.readUnsignedShort(this._dstream);
        propVec.add(new Property("DelayTime", PropertyType.INTEGER, (Object)new Integer(delayTime)));
        int transIndex = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        propVec.add(new Property("TransparentColorIndex", PropertyType.SHORT, (Object)new Short((short)transIndex)));
        GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        Property prop = new Property("GraphicControlExtension", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this.vectorToPropArray(propVec));
        this._blocksList.add(prop);
        return true;
    }

    protected int readXMP() throws IOException {
        int i;
        LinkedList<byte[]> bufList = new LinkedList<byte[]>();
        int bufsiz = 4096;
        byte[] curBuf = new byte[4096];
        int curBufOff = 0;
        while (true) {
            int ch;
            if ((ch = GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) == 0) break;
            if (curBufOff == 4096) {
                bufList.add(curBuf);
                curBuf = new byte[4096];
                curBufOff = 0;
            }
            curBuf[curBufOff++] = (byte)ch;
        }
        GifModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int appDataSize = bufList.size() * 4096 + curBufOff + 2;
        int totalSize = appDataSize - 258;
        byte[] bigBuf = new byte[totalSize];
        int bigBufOff = 0;
        ListIterator iter = bufList.listIterator();
        block7: while (iter.hasNext()) {
            byte[] buf = (byte[])iter.next();
            for (i = 0; i < 4096; ++i) {
                bigBuf[bigBufOff++] = buf[i];
                if (bigBufOff >= totalSize) break block7;
            }
        }
        for (i = 0; i < curBufOff && bigBufOff < totalSize; ++i) {
            bigBuf[bigBufOff++] = curBuf[i];
        }
        String badMetadata = "Invalid or ill-formed XMP metadata";
        try {
            ByteArrayInputStream strm = new ByteArrayInputStream(bigBuf);
            ByteArrayXMPSource src = new ByteArrayXMPSource(strm, "UTF-8");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            XMPHandler handler = new XMPHandler();
            parser.setContentHandler((ContentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            try {
                parser.parse((InputSource)src);
                this._xmpProp = src.makeProperty();
                return appDataSize;
            }
            catch (SAXException se) {
                String msg = se.getMessage();
                if (msg != null && msg.startsWith("ENC=")) {
                    String encoding = msg.substring(5);
                    try {
                        src = new ByteArrayXMPSource(strm, encoding);
                        parser.parse((InputSource)src);
                    }
                    catch (UnsupportedEncodingException uee) {
                        return appDataSize;
                    }
                }
                this._xmpProp = src.makeProperty();
                return appDataSize;
            }
        }
        catch (Exception e) {
            return appDataSize;
        }
    }

    protected Property addByteProperty(String name, int value, String[] labels) {
        if (!this._je.getShowRawFlag()) {
            try {
                return new Property(name, PropertyType.STRING, (Object)labels[value]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Property(name, PropertyType.BYTE, (Object)new Byte((byte)value));
    }

    protected int readUnsignedShort(DataInputStream stream) throws IOException {
        return GifModule.readUnsignedShort((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }
}

