/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExifIFD;

public final class TiffProfileExif
extends TiffProfile {
    private String[] profileText = new String[]{"Exif 2.0", "Exif 2.1 (JEIDA-49-1998)", "Exif 2.2 (JEITA CP-3451)"};
    private TiffProfileExifIFD _exifIFDProfile = new TiffProfileExifIFD();

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getXSamplingFrequency() == null || niso.getYSamplingFrequency() == null) {
            return false;
        }
        if (this.satisfiesCompression(tifd, 1)) {
            if (niso.getImageWidth() == -1L || niso.getImageLength() == -1L || niso.getStripOffsets() == null || niso.getRowsPerStrip() == -1L || niso.getStripByteCounts() == null) {
                return false;
            }
            if (niso.getSamplesPerPixel() != 3) {
                return false;
            }
            int[] bps = niso.getBitsPerSample();
            if (bps == null || bps.length < 3 || bps[0] != 8 || bps[1] != 8 || bps[2] != 8) {
                return false;
            }
            int pInterpretation = niso.getColorSpace();
            if (pInterpretation != 2 && pInterpretation != 6) {
                return false;
            }
            if (pInterpretation == 6 && (niso.getYCbCrSubSampling() == null || niso.getYCbCrPositioning() == -1)) {
                return false;
            }
        } else if (tifd.getJpegInterchangeFormat() == -1L) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        if (tifd.isFirst()) {
            ExifIFD eifd = tifd.getTheExifIFD();
            if (eifd == null) {
                return false;
            }
            if (!this._exifIFDProfile.satisfiesThisProfile(eifd)) {
                return false;
            }
            String version = eifd.getExifVersion();
            int idx = 0;
            if (version.equals("0220")) {
                idx = 2;
            } else if (version.equals("0210")) {
                idx = 1;
            } else if (version.equals("0200")) {
                idx = 0;
            }
            this._profileText = this.profileText[idx];
        }
        return true;
    }
}

