/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXS
extends TiffFXBase {
    public TiffProfileFXS() {
        this._profileText = "TIFF-FX (Profile S)";
        this._mimeClass = 1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesClass(tifd)) {
            return false;
        }
        if (ifd.isBigEndian()) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps[0] != 1) {
            return false;
        }
        if (niso.getStripOffsets().length > 1) {
            return false;
        }
        int resUnit = niso.getSamplingFrequencyUnit();
        if (resUnit != 2 && resUnit != -1) {
            return false;
        }
        if (niso.getCompressionScheme() != 3) {
            return false;
        }
        if (tifd.getFillOrder() != 2) {
            return false;
        }
        if (niso.getImageWidth() != 1728L) {
            return false;
        }
        if (niso.getSamplesPerPixel() != 1) {
            return false;
        }
        long xRes = niso.getXSamplingFrequency().toLong();
        long yRes = niso.getYSamplingFrequency().toLong();
        if (xRes != 200L && xRes != 204L) {
            return false;
        }
        if (yRes != 98L && yRes != 100L && yRes != 196L && yRes != 200L) {
            return false;
        }
        long t4Opt = tifd.getT4Options();
        return (t4Opt & 3L) == 0L;
    }
}

