/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.warc;

import java.util.LinkedList;
import java.util.List;
import org.jwat.common.HeaderLine;
import org.jwat.common.HttpHeader;
import org.jwat.common.Payload;
import org.jwat.common.PayloadWithHeaderAbstract;
import org.jwat.warc.WarcConcurrentTo;
import org.jwat.warc.WarcHeader;
import org.jwat.warc.WarcRecord;

public class WarcRecordData {
    protected Long startOffset;
    protected Long consumed;
    protected String warcVersionStr;
    protected String warcType;
    protected String warcFilename;
    protected String warcRecordId;
    protected String warcDate;
    protected String contentLength;
    protected String contentType;
    protected String warcTruncated;
    protected String warcIpAddress;
    protected List<String> warcConcurrentToList;
    protected String warcRefersTo;
    protected String warcTargetUri;
    protected String warcWarcinfoId;
    protected String warcIdentifiedPayloadType;
    protected String warcProfile;
    protected String warcSegmentNumber;
    protected String warcSegmentOriginId;
    protected String warcSegmentTotalLength;
    protected String warcBlockDigest;
    protected String warcBlockDigestAlgorithm;
    protected String warcBlockDigestEncoding;
    protected String warcPayloadDigest;
    protected String warcPayloadDigestAlgorithm;
    protected String warcPayloadDigestEncoding;
    protected String computedBlockDigest;
    protected String computedBlockDigestAlgorithm;
    protected String computedBlockDigestEncoding;
    protected String computedPayloadDigest;
    protected String computedPayloadDigestAlgorithm;
    protected String computedPayloadDigestEncoding;
    protected String recordIdScheme;
    protected Boolean bIsNonCompliant;
    protected Boolean isValidBlockDigest;
    protected Boolean isValidPayloadDigest;
    protected Boolean bHasPayload;
    protected String payloadLength;
    protected String ipVersion;
    protected String resultCode;
    protected String protocolVersion;
    protected String protocolContentType;
    protected String protocolServer;
    protected String protocolUserAgent;

    public WarcRecordData() {
    }

    public WarcRecordData(WarcRecord record) {
        int idx;
        if (record == null) {
            throw new IllegalArgumentException("'record' should never be null");
        }
        WarcHeader header = record.header;
        this.startOffset = record.getStartOffset();
        this.consumed = record.getConsumed();
        if (header.bValidVersionFormat) {
            this.warcVersionStr = header.versionStr;
        }
        this.warcType = header.warcTypeStr;
        this.warcFilename = header.warcFilename;
        this.warcRecordId = header.warcRecordIdStr;
        this.warcDate = header.warcDateStr;
        this.contentLength = header.contentLengthStr;
        this.contentType = header.contentTypeStr;
        this.warcTruncated = header.warcTruncatedStr;
        this.warcIpAddress = header.warcIpAddress;
        if (header.warcConcurrentToList != null && header.warcConcurrentToList.size() > 0) {
            this.warcConcurrentToList = new LinkedList<String>();
            for (int i = 0; i < header.warcConcurrentToList.size(); ++i) {
                WarcConcurrentTo warcConcurrentTo = (WarcConcurrentTo)header.warcConcurrentToList.get(i);
                if (warcConcurrentTo.warcConcurrentToStr == null) continue;
                this.warcConcurrentToList.add(warcConcurrentTo.warcConcurrentToStr);
            }
        }
        this.warcRefersTo = header.warcRefersToStr;
        this.warcTargetUri = header.warcTargetUriStr;
        this.warcWarcinfoId = header.warcWarcinfoIdStr;
        this.warcIdentifiedPayloadType = header.warcIdentifiedPayloadTypeStr;
        this.warcProfile = header.warcProfileStr;
        this.warcSegmentNumber = header.warcSegmentNumberStr;
        this.warcSegmentOriginId = header.warcSegmentOriginIdStr;
        this.warcSegmentTotalLength = header.warcSegmentTotalLengthStr;
        if (header.warcBlockDigest != null) {
            if (header.warcBlockDigest.digestString != null && header.warcBlockDigest.digestString.length() > 0) {
                this.warcBlockDigest = header.warcBlockDigest.digestString;
            }
            if (header.warcBlockDigest.algorithm != null && header.warcBlockDigest.algorithm.length() > 0) {
                this.warcBlockDigestAlgorithm = header.warcBlockDigest.algorithm;
            }
            if (header.warcBlockDigest.encoding != null && header.warcBlockDigest.encoding.length() > 0) {
                this.warcBlockDigestEncoding = header.warcBlockDigest.encoding;
            }
        }
        if (header.warcPayloadDigest != null) {
            if (header.warcPayloadDigest.digestString != null && header.warcPayloadDigest.digestString.length() > 0) {
                this.warcPayloadDigest = header.warcPayloadDigest.digestString;
            }
            if (header.warcPayloadDigest.algorithm != null && header.warcPayloadDigest.algorithm.length() > 0) {
                this.warcPayloadDigestAlgorithm = header.warcPayloadDigest.algorithm;
            }
            if (header.warcPayloadDigest.encoding != null && header.warcPayloadDigest.encoding.length() > 0) {
                this.warcPayloadDigestEncoding = header.warcPayloadDigest.encoding;
            }
        }
        if (record.computedBlockDigest != null) {
            if (record.computedBlockDigest.digestString != null && record.computedBlockDigest.digestString.length() > 0) {
                this.computedBlockDigest = record.computedBlockDigest.digestString;
            }
            if (record.computedBlockDigest.algorithm != null && record.computedBlockDigest.algorithm.length() > 0) {
                this.computedBlockDigestAlgorithm = record.computedBlockDigest.algorithm;
            }
            if (record.computedBlockDigest.encoding != null && record.computedBlockDigest.encoding.length() > 0) {
                this.computedBlockDigestEncoding = record.computedBlockDigest.encoding;
            }
        }
        if (record.computedPayloadDigest != null) {
            if (record.computedPayloadDigest.digestString != null && record.computedPayloadDigest.digestString.length() > 0) {
                this.computedPayloadDigest = record.computedPayloadDigest.digestString;
            }
            if (record.computedPayloadDigest.algorithm != null && record.computedPayloadDigest.algorithm.length() > 0) {
                this.computedPayloadDigestAlgorithm = record.computedPayloadDigest.algorithm;
            }
            if (record.computedPayloadDigest.encoding != null && record.computedPayloadDigest.encoding.length() > 0) {
                this.computedPayloadDigestEncoding = record.computedPayloadDigest.encoding;
            }
        }
        if (this.warcRecordId != null && (idx = this.warcRecordId.indexOf(58)) >= 0) {
            this.recordIdScheme = this.warcRecordId.startsWith("<") ? this.warcRecordId.substring(1, idx) : this.warcRecordId.substring(0, idx);
        }
        this.bIsNonCompliant = !record.isCompliant();
        this.isValidBlockDigest = record.isValidBlockDigest;
        this.isValidPayloadDigest = record.isValidPayloadDigest;
        this.bHasPayload = record.hasPayload();
        Payload payload = record.getPayload();
        if (payload != null) {
            PayloadWithHeaderAbstract payloadHeaderWrapped = payload.getPayloadHeaderWrapped();
            HttpHeader httpHeader = null;
            if (payloadHeaderWrapped instanceof HttpHeader) {
                httpHeader = (HttpHeader)payloadHeaderWrapped;
            }
            if (httpHeader != null) {
                this.payloadLength = Long.toString(httpHeader.getPayloadLength());
                this.protocolVersion = httpHeader.httpVersion;
                switch (httpHeader.headerType) {
                    case 1: {
                        this.resultCode = httpHeader.statusCodeStr;
                        this.protocolContentType = httpHeader.contentType;
                        HeaderLine headerLine = httpHeader.getHeader("server");
                        if (headerLine == null || headerLine.value == null) break;
                        this.protocolServer = headerLine.value;
                        break;
                    }
                    case 2: {
                        HeaderLine headerLine = httpHeader.getHeader("user-agent");
                        if (headerLine == null || headerLine.value == null) break;
                        this.protocolUserAgent = headerLine.value;
                    }
                }
            } else {
                this.payloadLength = Long.toString(payload.getTotalLength());
            }
        }
        if (header.warcInetAddress != null) {
            this.ipVersion = header.warcInetAddress.getAddress().length == 4 ? "4" : "6";
        }
    }
}

